/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __RAD64_HPP__
#define __RAD64_HPP__

#include <string.h>

#include "globals.hpp"
#include "errors.hpp"
#include "public.hpp"

#define BASE64_VECTOR			"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
#define BASE64_PADCHAR			'='
#define BASE64_MAXLINESIZE		72

class SCL_API CBase64Coder
{
	public:
		CBase64Coder();
	
	public:
		Word EncodeData(const Byte *, Word, char * = NULL, bool = true);
		Word DecodeData(const char *, Word, Byte *);
		Word DecodeData(Byte *, Word, int);
		Word EncodedSize(Word wRawBytes) { return ((wRawBytes + 2) / 3) * 4; };
		Word DecodedSize(Word wEncodedBytes) { return (wEncodedBytes / 4) * 3; };
		void Reset();
	
	private:
		char *Encode(const Byte *, Word = 3);
		Word Decode(const char *, Byte *);
		char EncodeChar(Byte);
		Byte DecodeChar(char);
	
	private:
		char *pszEncode;
		char szEncode[5];
		Byte bDecode[3];
		Byte bLastBlock[3];
		Word wLastBlock;
		Word wLinePos;
		Word wDecodePos;
};

#endif // __RAD64_HPP__
