/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DH_HPP__
#define __DH_HPP__

#include "obn.hpp"
#include "primes.hpp"
#include "keyexchange.hpp"

class SCL_API CDHKeyExchange : public CKeyExchange
{
	public:
		CDHKeyExchange(Word);
		CDHKeyExchange(const CProbablePrime &, const CBigNumber &);
		CDHKeyExchange(const CProbablePrime &, const CBigNumber &, const CBigNumber &);
		CDHKeyExchange(const CDHKeyExchange &);
	
	private:
		void MakeKeys();
	
	public:
		void Dump();
		void SetOtherPublic(const CBigNumber &cPublic) { cOtherPublic = cPublic; };
		CBigNumber & GetPublic() { return cPublic; };
		CBigNumber & GetPrivate() { return cPrivate; };
		CBigNumber & GetSecret() { return cKey; };
		CProbablePrime & GetPrime() { return cPrime; };
		CBigNumber & GetGenerator() { return cGenerator; };
	
	public:
		virtual void Agree();
		virtual void WritePublic(int);
		virtual void ReadOtherPublic(int);
		virtual Byte *GetKey();
		virtual Word GetKeySize();
	
	protected:
		Word wPrimeSize;
		CProbablePrime cPrime;
		CBigNumber cGenerator, cPrivate, cPublic, cOtherPublic, cKey;
};

class SCL_API CDH2KeyExchange : public CDHKeyExchange
{
	public:
		CDH2KeyExchange(Word);
		CDH2KeyExchange(const CProbablePrime &, const CBigNumber &);
		CDH2KeyExchange(const CProbablePrime &, const CBigNumber &, const CBigNumber &, const CBigNumber &);
		CDH2KeyExchange(const CDH2KeyExchange &);
	
	private:
		void MakeKeys();
	
	public:
		void Dump();
		void SetOtherPublic(const CBigNumber &, const CBigNumber &);
		CBigNumber & GetTempPublic() { return cTempPublic; };
		CBigNumber & GetTempPrivate() { return cTempPrivate; };

	public:
		virtual void Agree();
		virtual void WritePublic(int);
		virtual void ReadOtherPublic(int);

	private:
		CBigNumber cTempPrivate, cTempPublic, cOtherTempPublic;
};

#endif // __DH_HPP__
