/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __ERRORS_HPP__
#define __ERRORS_HPP__

#include "globals.hpp"

#define MEMORYALLOCATION_ERROR		"Memory allocation error..."
#define DIVISIONBYZERO_ERROR			"Division by zero..."
#define BASE64DECODING_ERROR			"Base - 64 decoding error..."
#define OPEN_ERROR						"Open file error..."
#define WRITE_ERROR						"Write file error..."
#define READ_ERROR						"Read file error..."
#define KEYFILE_ERROR					"Invalid key file..."
#define PARSE_ERROR						"Error parsing ASN1 token..."
#define UNEXPECTEDTYPE_ERROR			"Unexpected ASN1 type read..."
#define UNEXPECTEDLENGTH_ERROR		"Unexpected ASN1 length read..."
#define BAD_RSA_MODULUSSIZE			"Bad RSA modulus size..."
#define BAD_RSA_OPERATION				"Bad RSA operation..."
#define BAD_RABIN_MODULUSSIZE			"Bad Rabin modulus size..."
#define BAD_RABIN_OPERATION			"Bad Rabin operation..."
#define BAD_RW_MODULUSSIZE				"Bad Rabin-Williams modulus size..."
#define BAD_RW_OPERATION				"Bad Rabin-Williams operation..."
#define BAD_BG_MODULUSSIZE				"Bad Blum-Goldwasser modulus size..."
#define BAD_BG_OPERATION				"Bad Blum-Goldwasser operation..."
#define BAD_DSA_PRIMESIZE				"Bad DSA prime size..."
#define BAD_DSA_OPERATION				"Bad DSA operation..."
#define BAD_ELGAMAL_PRIMESIZE			"Bad ElGamal prime size..."
#define BAD_ELGAMAL_OPERATION			"Bad ElGamal operation..."
#define OPEN_RAND_DEV_ERROR			"Error opening /dev/random device..."

#define RSA_OK								0x0000
#define RSA_PNOTPRIME					0x0001
#define RSA_QNOTPRIME					0x0002
#define RSA_BADN							0x0004
#define RSA_BADPUB						0x0008
#define RSA_BADSEC						0x0010
#define RSA_BADCOEFF						0x0020
#define RSA_BADDP							0x0040
#define RSA_BADDQ							0x0080

#define RABIN_OK							0x0000
#define RABIN_PNOTPRIME					0x0001
#define RABIN_QNOTPRIME					0x0002
#define RABIN_PNOTCON					0x0004
#define RABIN_QNOTCON					0x0008
#define RABIN_BADN						0x0010

#define RW_OK								0x0000
#define RW_PNOTPRIME						0x0001
#define RW_QNOTPRIME						0x0002
#define RW_PNOTCON						0x0004
#define RW_QNOTCON						0x0008
#define RW_BADN							0x0010
#define RW_BADSEC							0x0020

#define BG_OK								0x0000
#define BG_PNOTPRIME						0x0001
#define BG_QNOTPRIME						0x0002
#define BG_PNOTCON						0x0004
#define BG_QNOTCON						0x0008
#define BG_BADN							0x0010
#define BG_BADSEC							0x0020

#define DSA_OK								0x0000
#define DSA_PNOTPRIME					0x0001
#define DSA_QNOTPRIME					0x0002
#define DSA_QNOTSUBPRIME				0x0004
#define DSA_BADPUBLIC					0x0008

#define ELGAMAL_OK						0x0000
#define ELGAMAL_PNOTPRIME				0x0001
#define ELGAMAL_BADPUBLIC				0x0002

extern SCL_API char *ppszRSACheckResults[];
extern SCL_API char *ppszRabinCheckResults[];
extern SCL_API char *ppszRWCheckResults[];
extern SCL_API char *ppszBGCheckResults[];
extern SCL_API char *ppszDSACheckResults[];
extern SCL_API char *ppszElGamalCheckResults[];

#endif // __ERRORS_HPP__
