/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __HAVAL_HPP__
#define __HAVAL_HPP__

#include <string.h>
#include <stdio.h>

#include "config.h"
#include "globals.hpp"
#include "digest.hpp"

class SCL_API CHavalDigest : public CDigest
{
	public:
		CHavalDigest();
		CHavalDigest(const Byte *, Word);
		CHavalDigest(const char *);

	public:
		virtual Word GetBlockSize() const { return BLOCKSIZE; };
		virtual Word GetFingerPrintSize() const { return FINGERPRINTSIZE; };
		virtual const Byte *GetFingerPrint() const;
		virtual void SetFingerPrint(const Byte *);
		virtual void SetBlock(const Byte *);
		virtual void HashBlock();
		virtual void HashData(const Byte *, Word);

		enum { BLOCKSIZE = 128, FINGERPRINTSIZE = 32 };
	
	protected:
		void Initialize();
		void HavalFold();

	protected:
		Word wFingerPrint[8];
		Word wBlock[32];

	private:
		Dword dwBits;
		Word wTemp;
};

#endif // __HAVAL_HPP__
