/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __INITRND_HPP__
#define __INITRND_HPP__

#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <sys/timeb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifdef WIN32
#include <io.h>
#include <conio.h>

#define RANDOM_FILE	"\\windows\\sssl\\sssl.rand"
#else
#include <sys/time.h>
#include <termios.h>
#include <unistd.h>

#define RANDOM_FILE	".sssl.rand"
#endif

#include "globals.hpp"
#include "obn.hpp"
#include "settings.hpp"
#include "pgprp.hpp"
#include "errors.hpp"

extern SCL_API CPRNG cPRNG;					// Defined in obn.cpp

extern SCL_API bool InitDefPRNG(Word = 32);
extern SCL_API CPRNG &GetDefPRNG();
extern bool CreateRandomFile(Word, char *);
extern bool InitDefPRNGFromFile(Word, char *);
extern bool InitDefPRNGFromRandDev(Word);
extern bool RandPoolKeystroke(CPGPRandomPool &, Byte, Word);
#ifdef WIN32
extern bool InitDefPRNGFromWindowsTTY(Word);
#else
extern bool InitDefPRNGFromUnixTTY(Word);
#endif

#endif // __INITRND_HPP__
