#!/usr/bin/perl -w

print <<EOT;
// Automatically generated header.
// See "lokisboxes.pl" for more information.
// Do not edit by hand.

#ifndef __LOKISBOXES_HPP__
#define __LOKISBOXES_HPP__

Byte S1[] =
{
EOT

printf("\t");
for (0 .. 8190) {
	if (($_ + 1) % 16 == 0) {
		printf("%3d,\n\t", f($_));
	} else {
		printf("%3d, ", f($_));
	}
}
printf("%3d\n", f(8191));

print <<EOT;
};

Byte S2[] =
{
EOT

printf("\t");
for (0 .. 2046) {
	if (($_ + 1) % 16 == 0) {
		printf("%3d,\n\t", g($_));
	} else {
		printf("%3d, ", g($_));
	}
}
printf("%3d\n", g(2047));

print <<EOT;
};

#endif // __LOKISBOXES_HPP__
EOT

sub f
{
	$x = $_[0] ^ 0x1FFF;
	$y = exp3($x, 0x2911, 0x2000);
	return $y & 0xFF;
}

sub g
{
	$x = $_[0] ^ 0x7FF;
	$y = exp3($x, 0xaa7, 0x800);
	return $y & 0xFF;
}

# Returns (b ** 3) % g in GF(2 ** n)
# b => $_[0]	- The base;
# g => $_[1]	- The irreducible polynomial generating galois field;
# n => $_[2]	- The size of the galois field;
sub exp3
{
	return 0 if ($_[0] == 0);
	$a = $_[0];
	$b = $_[0];
	$c = $_[0];
	$d = mult($a, $b, $_[1], $_[2]);
	$e = mult($d, $c, $_[1], $_[2]);
	return $e;
}

# Returns (a * b) in GF(2 ** n)
# a => $_[0]	- The first multiplier;
# b => $_[1]	- The second multiplier;
# g => $_[2]	- The irreducible polynomial generating galois field;
# n => $_[3]	- The size of the galois field;
# returns      - (a * b) % g.
sub mult
{
	$p = 0;
	while ($_[1] != 0) {
		$p ^= $_[0] if ($_[1] & 1);
		$_[0] <<= 1;
		$_[0] ^= $_[2] if ($_[0] >= $_[3]);
		$_[1] >>= 1;
	}
	return $p;
}