/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __RW_HPP__
#define __RW_HPP__

// Rabin-Williams' encryption scheme

#include "globals.hpp"
#include "obn.hpp"
#include "primes.hpp"
#include "public.hpp"
#include "der.hpp"

#define RW_PRIVATE_KEY_VERSION			0

#define BEGIN_RW_PRIVATE_KEY			"-----BEGIN RABIN-WILLIAMS PRIVATE KEY-----"
#define END_RW_PRIVATE_KEY				"-----END RABIN-WILLIAMS PRIVATE KEY-----"
#define BEGIN_RW_PUBLIC_KEY			"-----BEGIN RABIN-WILLIAMS PUBLIC KEY-----"
#define END_RW_PUBLIC_KEY				"-----END RABIN-WILLIAMS PUBLIC KEY-----"

class SCL_API CRWKey : public CAsymmetricKey
{
	public:
		CRWKey();
		CRWKey(Word);
		CRWKey(const CRWKey &);
		CRWKey(const CBigNumber &);
		CRWKey(const CBigNumber &, const CBigNumber &);
		CRWKey(const CBigNumber &, const CBigNumber &, const CProbablePrime &, const CProbablePrime &);
	
	public:
		CBigNumber & GetModulus() { return N; };
		CBigNumber & GetPrivate() { return K; };
		CProbablePrime & GetP() { return P; };
		CProbablePrime & GetQ() { return Q; };
	
	public:
		bool EncryptOnlyFlag() { return fgEncryptOnly; };
		bool HoldKeyFlag() { return fgHoldKey; };
		void WritePrivateKey(int, bool = true);
		void WritePublicKey(int, bool = true);
		void ReadPrivateKey(int, bool = true);
		void ReadPublicKey(int, bool = true);
		void Dump();
		Word Check();
	
	private:
		void GenerateKeys();
	
	private:
		bool fgEncryptOnly;
		bool fgHoldKey;
		CProbablePrime P, Q;
		CBigNumber N, K;
		Word wModulusSize;
};

class SCL_API CRWBlock
{
	public:
		CRWBlock(const CRWKey &, void *, Word);
		CRWBlock(const CRWKey &, const CBigNumber &);
	
	public:
		void Sign();
		void Verify();

	public:
		CBigNumber & GetData() { return cData; };
		void Dump();

	private:
		CRWKey cKey;
		CBigNumber cData;
};

#endif // __RW_HPP__
