/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SAFER_HPP__
#define __SAFER_HPP__

#include <string.h>

#include "config.h"
#include "globals.hpp"
#include "block.hpp"

#define SK
#define SAFERROUNDS 6

class SCL_API CSAFERKey : public CBlockKey
{
	public:
		enum { KEYSIZE = 8 };

	public:
		CSAFERKey();
		CSAFERKey(const CSAFERKey &);
		CSAFERKey(Dword);
		CSAFERKey(Byte *, Word = KEYSIZE);
		virtual ~CSAFERKey();

	public:
		Dword GetMaster() const { return dwMaster; };
		Dword GetKey(Word i) const { return dwKey[i]; };

	public:
		virtual Word GetKeySize() { return KEYSIZE; };

	private:
		void MakeKeys();

	private:
		Dword dwMaster;
		Dword dwKey[2 * SAFERROUNDS + 1];
};

class SCL_API CSAFERBlock : public CBlockObject
{
	public:
		enum { BLOCKSIZE = 8 };

	public:
		CSAFERBlock();
		CSAFERBlock(const CSAFERBlock &);
		CSAFERBlock(Dword);
		CSAFERBlock(const Byte *, Word = BLOCKSIZE);
		virtual ~CSAFERBlock();

	public:
		virtual void Encrypt(const CBlockKey &cKey) { Encrypt((const CSAFERKey &)cKey); };
		virtual void Decrypt(const CBlockKey &cKey) { Decrypt((const CSAFERKey &)cKey); };
		virtual void SetData(const Byte *, Word = BLOCKSIZE);
		virtual Byte *GetData();
		virtual Word GetBlockSize() { return BLOCKSIZE; };

	public:
		void Encrypt(const CSAFERKey &);
		void Decrypt(const CSAFERKey &);
		void Encrypt(const CSAFERKey &, const CSAFERKey &);
		void Decrypt(const CSAFERKey &, const CSAFERKey &);
		void SetValue(Dword);
		Dword GetValue();

	private:
		Dword dwData, dwResult;
};

#endif // __SAFER_HPP__
