#!/usr/bin/perl

$primes = 16384;
$ready = 0;

$last = 2;

while ($ready < $primes) {
	push(@primes, $last);
	$ready += 1;
	$last += 1;
	$j = sqrt($ready);
	for ($i = 1; $i <= $j; $i++) {
		if ($last % $primes[$i - 1] == 0) {
			$last += 1;
			$i = 0;
		}
	}
}

print << "EOF";
// Automatically generated header.
// See "genprimes.pl" for more information.
// Do not edit by hand.

#ifndef __SMALLPRIMES_HPP__
#define __SMALLPRIMES_HPP__

int iSmallPrimes[] = 
{
EOF

for ($i = 1; $i <= $ready; $i++) {
	printf("%8d, ", $primes[$i - 1]);	
	printf("\n") if ($i % 8 == 0);
}
print << "EOF";
};

#endif // __SMALLPRIMES_HPP__
EOF
