#!/usr/bin/perl -w

@ror4 = (  0,  8,  1,  9,  2, 10,  3, 11,  4, 12,  5, 13,  6, 14,  7, 15 );
@ashx = (  0,  9,  2, 11,  4, 13,  6, 15,  8,  1, 10,  3, 12,  5, 14,  7 );

@q =
(
	[
		[  8,  1,  7, 13,  6, 15,  3,  2,  0, 11,  5,  9, 14, 12, 10,  4 ],
		[ 14, 12, 11,  8,  1,  2,  3,  5, 15,  4, 10,  6,  7,  0,  9, 13 ],
		[ 11, 10,  5, 14,  6, 13,  9,  0, 12,  8, 15,  3,  2,  4,  7,  1 ],
		[ 13,  7, 15,  4,  1,  2,  6, 14,  9, 11,  3,  0,  8,  5, 12, 10 ]
	],
	[
		[  2,  8, 11, 13, 15,  7,  6, 14,  3,  1,  9,  4,  0, 10, 12,  5 ],
		[  1, 14,  2, 11,  4, 12,  3,  7,  6, 13, 10,  5, 15,  9,  0,  8 ],
		[  4, 12,  7,  5,  1,  6,  9, 10,  0, 14, 13,  8,  2, 11,  3, 15 ],
		[ 11,  9,  5,  1, 12,  3, 13, 14,  6,  4,  7, 15,  2,  0,  8, 10 ]
	]
);

print <<EOT;
// Automatically generated header.
// See "twofishtables.pl" for more information.
// Do not edit by hand.

#ifndef __TWOFISHTABLES_HPP__
#define __TWOFISHTABLES_HPP__

Byte bQ[][256] =
{
EOT

for (0 .. 1) {
	printf("\t{\n");
	for ($i = 0; $i < 256; $i++) {
		printf("\t\t") if ($i % 8 == 0);
		printf("0x%02x,", qp($_, $i));
		printf(" ") if (($i + 1) % 8 != 0);
		printf("\n") if (($i + 1) % 8 == 0);
	}
	printf("\t},\n");
}

print <<EOT;
};

Word wM[][256] =
{
EOT

for (0 .. 3) {
	printf("\t{\n");
	for ($i = 0; $i < 256; $i++) {
		printf("\t\t") if ($i % 4 == 0);
		printf("0x%08xL,", mt($_, $i));
		printf(" ") if (($i + 1) % 4 != 0);
		printf("\n") if (($i + 1) % 4 == 0);
	}
	printf("\t},\n");
}

print <<EOT;
};

#endif // __TWOFISHTABLES_HPP__
EOT

sub qp
{
	$a0 = $_[1] >> 4;
	$b0 = $_[1] & 15;
	$a1 = $a0 ^ $b0;
	$b1 = $ror4[$b0] ^ $ashx[$a0];
	$a2 = $q[$_[0]][0][$a1];
	$b2 = $q[$_[0]][1][$b1];
	$a3 = $a2 ^ $b2;
	$b3 = $ror4[$b2] ^ $ashx[$a2];
	$a4 = $q[$_[0]][2][$a3];
	$b4 = $q[$_[0]][3][$b3];
	return ($b4 << 4) | $a4;
}

sub mt
{
	$f01 = qp((($_[0] == 0) || ($_[0] == 2)) ? 1 : 0, $_[1]);
	$f5b = ffm_5b($f01);
	$fef = ffm_ef($f01);
	return $f01 + ($f5b << 8) + ($fef << 16) + ($fef << 24) if ($_[0] == 0);
	return $fef + ($fef << 8) + ($f5b << 16) + ($f01 << 24) if ($_[0] == 1);
	return $f5b + ($fef << 8) + ($f01 << 16) + ($fef << 24) if ($_[0] == 2);
	return $f5b + ($f01 << 8) + ($fef << 16) + ($f5b << 24) if ($_[0] == 3);
}

sub ffm_5b
{
	@tab_5b = ( 0, 0x0169 >> 2, 0x0169 >> 1, (0x0169 >> 1) ^ (0x0169 >> 2) );

	return ($_[0] ^ ($_[0] >> 2) ^ $tab_5b[$_[0] & 3]);
}

sub ffm_ef
{
	@tab_ef = ( 0, (0x0169 >> 1) ^ (0x0169 >> 2), 0x0169 >> 1, 0x0169 >> 2 );

	return ($_[0] ^ ($_[0] >> 1) ^ ($_[0] >> 2) ^ $tab_ef[$_[0] & 3]);
}
