/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "errors.hpp"

SCL_API char *ppszRSACheckResults[] =
{
	"Ok...",
	"p is not prime...",
	"q is not prime...",
	"n is not equal to p * q...",
	"Invalid public exponent...",
	"The secret key is not the multiplicative inverse of public key in phi...",
	"The coefficient is not the multiplicative inverse of q in p...",
	"The first exponent is not congruent to p - 1 mod secret...",
	"The second exponent is not congruent to q - 1 mod secret..."
};

SCL_API char *ppszRabinCheckResults[] =
{
	"Ok...",
	"p is not prime...",
	"q is not prime...",
	"p is not congruent to 3 mod 4...",
	"q is not congruent to 3 mod 4...",
	"n is not equal to p * q...",
};

SCL_API char *ppszRWCheckResults[] =
{
	"Ok...",
	"p is not prime...",
	"q is not prime...",
	"p is not congruent to 3 mod 8...",
	"q is not congruent to 7 mod 8...",
	"n is not equal to p * q...",
	"The secret key is not the multiplicative inverse of public key in phi...",
};

SCL_API char *ppszBGCheckResults[] =
{
	"Ok...",
	"p is not prime...",
	"q is not prime...",
	"p is not congruent to 3 mod 4...",
	"q is not congruent to 3 mod 4...",
	"n is not equal to p * q...",
	"Invlid secret key...",
};

SCL_API char *ppszDSACheckResults[] =
{
	"Ok...",
	"p is not prime...",
	"q is not prime...",
	"p - 1 is not congruent to q",
	"Invlid public key...",
};

SCL_API char *ppszElGamalCheckResults[] =
{
	"Ok...",
	"p is not prime...",
	"Invlid public key...",
};
