/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "public.hpp"

bool write_string(int iOut, char *pszString)
{
	int iLength = strlen(pszString);
	return iLength == scl_write(iOut, pszString, iLength);
}

bool match_string(int iIn, char *pszString)
{
	int iLength = strlen(pszString);
	int iRead;
	char *pszMatch = new char[iLength + 1];
	if (NULL == pszMatch)
		return false;
	if (-1 == (iRead = scl_read(iIn, pszMatch, iLength)))
		return false;
	pszMatch[iRead] = '\0';

	char *p = pszString;
	char *q = pszMatch;
	while (*p && *q) {
		while ('\n' == *p || '\r' == *p)
			p++;
		while ('\n' == *q || '\r' == *q)
			q++;
		if ((*p && *q) && *p++ != *q++) {
			delete pszMatch;
			return false;
		}
	}
	delete pszMatch;
	return true;
}

CAsymmetricBlock::~CAsymmetricBlock()
{
}

CAsymmetricKey::~CAsymmetricKey()
{
}

void CAsymmetricKey::WritePrivate(char *pszFile, bool fgBase64)
{
	int iFile = 1;
	if (NULL != pszFile)
		if (-1 == (iFile = open(pszFile, O_RDWR | O_CREAT | O_TRUNC, 0644)))
		  throw OPEN_ERROR;
	WritePrivateKey(iFile, fgBase64);
	if (NULL != pszFile)
		close(iFile);
}

void CAsymmetricKey::WritePublic(char *pszFile, bool fgBase64)
{
	int iFile = 1;
	if (NULL != pszFile)
		if (-1 == (iFile = open(pszFile, O_RDWR | O_CREAT | O_TRUNC, 0644)))
		  throw OPEN_ERROR;
	WritePublicKey(iFile, fgBase64);
	if (NULL != pszFile)
		close(iFile);
}

void CAsymmetricKey::ReadPrivate(char *pszFile, bool fgBase64)
{
	int iFile = 0;
	if (NULL != pszFile)
		if (-1 == (iFile = open(pszFile, O_RDONLY)))
		  throw OPEN_ERROR;
	ReadPrivateKey(iFile, fgBase64);
	if (NULL != pszFile)
		close(iFile);
}

void CAsymmetricKey::ReadPublic(char *pszFile, bool fgBase64)
{
	int iFile = 0;
	if (NULL != pszFile)
		if (-1 == (iFile = open(pszFile, O_RDONLY)))
		  throw OPEN_ERROR;
	ReadPublicKey(iFile, fgBase64);
	if (NULL != pszFile)
		close(iFile);
}
