#!/usr/bin/perl

@jl = ( 'El', 'Dl', 'Cl', 'Bl', 'Al' );
@jr = ( 'Er', 'Dr', 'Cr', 'Br', 'Ar' );
@kl = ( 'FF', 'GG', 'HH', 'II', 'JJ' );
@kr = reverse(@kl);
@ll = ( 0, 0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xa953fd4e );
@lr = ( 0x50a28be6, 0x5c4dd124, 0x6d703ef3, 0x7a6d76e9, 0 );
@sl = ( 11, 14, 15, 12,  5,  8,  7,  9, 11, 13, 14, 15,  6,  7,  9,  8,
		   7,  6,  8, 13, 11,  9,  7, 15,  7, 12, 15,  9, 11,  7, 13, 12,
		  11, 13,  6,  7, 14,  9, 13, 15, 14,  8, 13,  6,  5, 12,  7,  5,
		  11, 12, 14, 15, 14, 15,  9,  8,  9, 14,  5,  6,  8,  6,  5, 12,
		   9, 15,  5, 11,  6,  8, 13, 12,  5, 12, 13, 14, 11,  8,  5,  6 );
@sr = (  8,  9,  9, 11, 13, 15, 15,  5,  7,  7,  8, 11, 14, 14, 12,  6,
		   9, 13, 15,  7, 12,  8,  9, 11,  7,  7, 12,  7,  6, 15, 13, 11,
		   9,  7, 15, 11,  8,  6,  6, 14, 12, 13,  5, 14, 13, 13,  7,  5,
		  15,  5,  8, 11, 14, 14,  6, 14,  6,  9, 12,  9, 12,  5, 15,  8,
		   8,  5, 12,  9, 12,  5, 14,  6,  8, 13,  6,  5, 15, 13, 11, 11 );
@zl = (  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
		   7,  4, 13,  1, 10,  6, 15,  3, 12,  0,  9,  5,  2, 14, 11,  8,
		   3, 10, 14,  4,  9, 15,  8,  1,  2,  7,  0,  6, 13, 11,  5, 12,
		   1,  9, 11, 10,  0,  8, 12,  4, 13,  3,  7, 15, 14,  5,  6,  2,
		   4,  0,  5,  9,  7, 12,  2, 10, 14,  1,  3,  8, 11,  6, 15, 13 );
@zr = (  5, 14,  7,  0,  9,  2, 11,  4, 13,  6, 15,  8,  1, 10,  3, 12,
		   6, 11,  3,  7,  0, 13,  5, 10, 14, 15,  8, 12,  4,  9,  1,  2,
		  15,  5,  1,  3,  7, 14,  6,  9, 11,  8, 12,  2, 10,  0,  4, 13,
		   8,  6,  4,  1,  3, 11, 15,  0,  5, 12,  2, 13,  9,  7, 10, 14,
		  12, 15, 10,  4,  1,  5,  8,  7,  6,  2, 13, 14,  0,  3,  9, 11 );

print <<EOT;
// Automatically generated source.
// See "ripemd160rounds.pl" for more information.
// Do not edit by hand.
EOT

for (0..79) {
	printf("%s(%s, %s, %s, %s, %s, X[%2d], %2d, 0x%xL);\n",
			 $kl[$_ / 16],
			 $jl[4],
			 $jl[3], 
			 $jl[2],
			 $jl[1],
			 $jl[0],
			 $zl[$_],
			 $sl[$_],
			 $ll[$_ / 16]);
	push(@jl, reverse(shift(@jl)));
	printf("\n") if ((0 == ($_ + 1) % 16) && (79 != $_));
}
printf("\n");
for (0..79) {
	printf("%s(%s, %s, %s, %s, %s, X[%2d], %2d, 0x%xL);\n",
			 $kr[$_ / 16],
			 $jr[4],
			 $jr[3], 
			 $jr[2],
			 $jr[1],
			 $jr[0],
			 $zr[$_],
			 $sr[$_],
			 $lr[$_ / 16]);
	push(@jr, reverse(shift(@jr)));
	printf("\n") if ((0 == ($_ + 1) % 16) && (79 != $_));
}
