/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "x917.hpp"
#include "timers.hpp"


CX917PRNG::CX917PRNG() : p3DESKey(NULL), iPos(0)
{
	Initialize(0, 0, 0);
}

CX917PRNG::CX917PRNG(Dword dwSeed, Dword dwEncrypt, Dword dwDecrypt) : p3DESKey(NULL), iPos(0)
{
	Initialize(dwSeed, dwEncrypt, dwDecrypt);
}

CX917PRNG::~CX917PRNG()
{
	if (NULL != p3DESKey)
		delete p3DESKey;
	dwSeed = 0;									// Cleanup
	dwInit = 0;
	dwData = 0;
}

void CX917PRNG::Initialize(Dword dwSeed, Dword dwEncrypt, Dword dwDecrypt)
{
	timetype t;
	gettime(&t);

	CX917PRNG::dwSeed = dwSeed;

	p3DESKey = new C3DESKey(dwEncrypt, dwDecrypt, dwEncrypt);
	C3DESBlock c(getdwtime(t));
	if (p3DESKey)
		c.Encrypt(*p3DESKey);
	dwInit = c.GetValue();
}

void CX917PRNG::GetRandomData(void *pvRandom, int iLength)
{
	for (int i = 0; i < iLength; i++, iPos--) {
		if (iPos == 0) {
			C3DESBlock a(dwInit ^ dwSeed);
			if (p3DESKey)
				a.Encrypt(*p3DESKey);
			dwData = a.GetValue();
			C3DESBlock b(dwInit ^ dwData);
			if (p3DESKey)
				b.Encrypt(*p3DESKey);
			dwSeed = b.GetValue();
			iPos = 7;
		}
		((Byte *)pvRandom)[i] = ((Byte *)(&dwData))[7 - iPos];
	}
}
