/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "cast.hpp"
#include "castsboxes.hpp"

Byte bPos[] = {  
					  3,  2,  1,  0,  7,  6,  5,  4,
					 11, 10,  9,  8, 15, 14, 13, 12,
				  };

#define rol(p, q)			(((p) << (q)) | ((p) >> (32 - (q))))
#define ror(p, q)			(((p) >> (q)) | ((p) << (32 - (q))))
#define byte(p, q)		(((Byte *)p)[bPos[(q)]])

#define f(l, r, b, c)	t = rol(b + l, c); \
								r ^= (((wSb[0][WBYTE0(t)] ^ wSb[1][WBYTE1(t)]) - wSb[2][WBYTE2(t)]) + wSb[3][WBYTE3(t)])
#define g(l, r, b, c)	t = rol(b ^ l, c); \
								r ^= (((wSb[0][WBYTE0(t)] - wSb[1][WBYTE1(t)]) + wSb[2][WBYTE2(t)]) ^ wSb[3][WBYTE3(t)])
#define h(l, r, b, c)	t = rol(b - l, c); \
								r ^= (((wSb[0][WBYTE0(t)] + wSb[1][WBYTE1(t)]) ^ wSb[2][WBYTE2(t)]) - wSb[3][WBYTE3(t)])

CCASTKey::CCASTKey()
{
}

CCASTKey::CCASTKey(const CCASTKey &cCASTKey)
{
	for (int i = 0; i < 16; i++)
		bMaster[i] = cCASTKey.bMaster[i];
	MakeKeys();
}

CCASTKey::CCASTKey(const Byte *pbMasterKey, Word wLength)
{
	Word i;
	for (i = 0; i < wLength; i++)
		bMaster[i] = pbMasterKey[i];
	for ( ; i < 16; i++)
		bMaster[i] = pbMasterKey[i];
	MakeKeys();
}

CCASTKey::~CCASTKey()
{
	int i;
	for (i = 0; i < 16; i++)				// Cleanup
		bMaster[i] = 0;
	for (i = 0; i < 32; i++)
		wKey[i] = 0;
}

void CCASTKey::MakeKeys()
{
	Word wOrg[4] = {	
							MakeWord(bMaster[ 0], bMaster[ 1], bMaster[ 2], bMaster[ 3]),
						 	MakeWord(bMaster[ 4], bMaster[ 5], bMaster[ 6], bMaster[ 7]),
						 	MakeWord(bMaster[ 8], bMaster[ 9], bMaster[10], bMaster[11]),
						 	MakeWord(bMaster[12], bMaster[13], bMaster[14], bMaster[15])
						};
	Word wTmp[4];

   wTmp[ 0] = wOrg[0] ^ wSb[4][byte(wOrg, 13)] ^ wSb[5][byte(wOrg, 15)] ^ wSb[6][byte(wOrg, 12)] ^ wSb[7][byte(wOrg, 14)] ^ wSb[6][byte(wOrg,  8)];
   wTmp[ 1] = wOrg[2] ^ wSb[4][byte(wTmp,  0)] ^ wSb[5][byte(wTmp,  2)] ^ wSb[6][byte(wTmp,  1)] ^ wSb[7][byte(wTmp,  3)] ^ wSb[7][byte(wOrg, 10)];
   wTmp[ 2] = wOrg[3] ^ wSb[4][byte(wTmp,  7)] ^ wSb[5][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  5)] ^ wSb[7][byte(wTmp,  4)] ^ wSb[4][byte(wOrg,  9)];
   wTmp[ 3] = wOrg[1] ^ wSb[4][byte(wTmp, 10)] ^ wSb[5][byte(wTmp,  9)] ^ wSb[6][byte(wTmp, 11)] ^ wSb[7][byte(wTmp,  8)] ^ wSb[5][byte(wOrg, 11)];
   wKey[ 0] = wSb[4][byte(wTmp,  8)] ^ wSb[5][byte(wTmp,  9)] ^ wSb[6][byte(wTmp,  7)] ^ wSb[7][byte(wTmp,  6)] ^ wSb[4][byte(wTmp,  2)];
   wKey[ 1] = wSb[4][byte(wTmp, 10)] ^ wSb[5][byte(wTmp, 11)] ^ wSb[6][byte(wTmp,  5)] ^ wSb[7][byte(wTmp,  4)] ^ wSb[5][byte(wTmp,  6)];
   wKey[ 2] = wSb[4][byte(wTmp, 12)] ^ wSb[5][byte(wTmp, 13)] ^ wSb[6][byte(wTmp,  3)] ^ wSb[7][byte(wTmp,  2)] ^ wSb[6][byte(wTmp,  9)];
   wKey[ 3] = wSb[4][byte(wTmp, 14)] ^ wSb[5][byte(wTmp, 15)] ^ wSb[6][byte(wTmp,  1)] ^ wSb[7][byte(wTmp,  0)] ^ wSb[7][byte(wTmp, 12)];
   wOrg[ 0] = wTmp[2] ^ wSb[4][byte(wTmp,  5)] ^ wSb[5][byte(wTmp,  7)] ^ wSb[6][byte(wTmp,  4)] ^ wSb[7][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  0)];
   wOrg[ 1] = wTmp[0] ^ wSb[4][byte(wOrg,  0)] ^ wSb[5][byte(wOrg,  2)] ^ wSb[6][byte(wOrg,  1)] ^ wSb[7][byte(wOrg,  3)] ^ wSb[7][byte(wTmp,  2)];
   wOrg[ 2] = wTmp[1] ^ wSb[4][byte(wOrg,  7)] ^ wSb[5][byte(wOrg,  6)] ^ wSb[6][byte(wOrg,  5)] ^ wSb[7][byte(wOrg,  4)] ^ wSb[4][byte(wTmp,  1)];
   wOrg[ 3] = wTmp[3] ^ wSb[4][byte(wOrg, 10)] ^ wSb[5][byte(wOrg,  9)] ^ wSb[6][byte(wOrg, 11)] ^ wSb[7][byte(wOrg,  8)] ^ wSb[5][byte(wTmp,  3)];
   wKey[ 4] = wSb[4][byte(wOrg,  3)] ^ wSb[5][byte(wOrg,  2)] ^ wSb[6][byte(wOrg, 12)] ^ wSb[7][byte(wOrg, 13)] ^ wSb[4][byte(wOrg,  8)];
   wKey[ 5] = wSb[4][byte(wOrg,  1)] ^ wSb[5][byte(wOrg,  0)] ^ wSb[6][byte(wOrg, 14)] ^ wSb[7][byte(wOrg, 15)] ^ wSb[5][byte(wOrg, 13)];
   wKey[ 6] = wSb[4][byte(wOrg,  7)] ^ wSb[5][byte(wOrg,  6)] ^ wSb[6][byte(wOrg,  8)] ^ wSb[7][byte(wOrg,  9)] ^ wSb[6][byte(wOrg,  3)];
   wKey[ 7] = wSb[4][byte(wOrg,  5)] ^ wSb[5][byte(wOrg,  4)] ^ wSb[6][byte(wOrg, 10)] ^ wSb[7][byte(wOrg, 11)] ^ wSb[7][byte(wOrg,  7)];
   wTmp[ 0] = wOrg[0] ^ wSb[4][byte(wOrg, 13)] ^ wSb[5][byte(wOrg, 15)] ^ wSb[6][byte(wOrg, 12)] ^ wSb[7][byte(wOrg, 14)] ^ wSb[6][byte(wOrg,  8)];
   wTmp[ 1] = wOrg[2] ^ wSb[4][byte(wTmp,  0)] ^ wSb[5][byte(wTmp,  2)] ^ wSb[6][byte(wTmp,  1)] ^ wSb[7][byte(wTmp,  3)] ^ wSb[7][byte(wOrg, 10)];
   wTmp[ 2] = wOrg[3] ^ wSb[4][byte(wTmp,  7)] ^ wSb[5][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  5)] ^ wSb[7][byte(wTmp,  4)] ^ wSb[4][byte(wOrg,  9)];
   wTmp[ 3] = wOrg[1] ^ wSb[4][byte(wTmp, 10)] ^ wSb[5][byte(wTmp,  9)] ^ wSb[6][byte(wTmp, 11)] ^ wSb[7][byte(wTmp,  8)] ^ wSb[5][byte(wOrg, 11)];
   wKey[ 8] = wSb[4][byte(wTmp,  3)] ^ wSb[5][byte(wTmp,  2)] ^ wSb[6][byte(wTmp, 12)] ^ wSb[7][byte(wTmp, 13)] ^ wSb[4][byte(wTmp,  9)];
   wKey[ 9] = wSb[4][byte(wTmp,  1)] ^ wSb[5][byte(wTmp,  0)] ^ wSb[6][byte(wTmp, 14)] ^ wSb[7][byte(wTmp, 15)] ^ wSb[5][byte(wTmp, 12)];
   wKey[10] = wSb[4][byte(wTmp,  7)] ^ wSb[5][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  8)] ^ wSb[7][byte(wTmp,  9)] ^ wSb[6][byte(wTmp,  2)];
   wKey[11] = wSb[4][byte(wTmp,  5)] ^ wSb[5][byte(wTmp,  4)] ^ wSb[6][byte(wTmp, 10)] ^ wSb[7][byte(wTmp, 11)] ^ wSb[7][byte(wTmp,  6)];
   wOrg[ 0] = wTmp[2] ^ wSb[4][byte(wTmp,  5)] ^ wSb[5][byte(wTmp,  7)] ^ wSb[6][byte(wTmp,  4)] ^ wSb[7][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  0)];
   wOrg[ 1] = wTmp[0] ^ wSb[4][byte(wOrg,  0)] ^ wSb[5][byte(wOrg,  2)] ^ wSb[6][byte(wOrg,  1)] ^ wSb[7][byte(wOrg,  3)] ^ wSb[7][byte(wTmp,  2)];
   wOrg[ 2] = wTmp[1] ^ wSb[4][byte(wOrg,  7)] ^ wSb[5][byte(wOrg,  6)] ^ wSb[6][byte(wOrg,  5)] ^ wSb[7][byte(wOrg,  4)] ^ wSb[4][byte(wTmp,  1)];
   wOrg[ 3] = wTmp[3] ^ wSb[4][byte(wOrg, 10)] ^ wSb[5][byte(wOrg,  9)] ^ wSb[6][byte(wOrg, 11)] ^ wSb[7][byte(wOrg,  8)] ^ wSb[5][byte(wTmp,  3)];
   wKey[12] = wSb[4][byte(wOrg,  8)] ^ wSb[5][byte(wOrg,  9)] ^ wSb[6][byte(wOrg,  7)] ^ wSb[7][byte(wOrg,  6)] ^ wSb[4][byte(wOrg,  3)];
   wKey[13] = wSb[4][byte(wOrg, 10)] ^ wSb[5][byte(wOrg, 11)] ^ wSb[6][byte(wOrg,  5)] ^ wSb[7][byte(wOrg,  4)] ^ wSb[5][byte(wOrg,  7)];
   wKey[14] = wSb[4][byte(wOrg, 12)] ^ wSb[5][byte(wOrg, 13)] ^ wSb[6][byte(wOrg,  3)] ^ wSb[7][byte(wOrg,  2)] ^ wSb[6][byte(wOrg,  8)];
   wKey[15] = wSb[4][byte(wOrg, 14)] ^ wSb[5][byte(wOrg, 15)] ^ wSb[6][byte(wOrg,  1)] ^ wSb[7][byte(wOrg,  0)] ^ wSb[7][byte(wOrg, 13)];
   wTmp[ 0] = wOrg[0] ^ wSb[4][byte(wOrg, 13)] ^ wSb[5][byte(wOrg, 15)] ^ wSb[6][byte(wOrg, 12)] ^ wSb[7][byte(wOrg, 14)] ^ wSb[6][byte(wOrg,  8)];
   wTmp[ 1] = wOrg[2] ^ wSb[4][byte(wTmp,  0)] ^ wSb[5][byte(wTmp,  2)] ^ wSb[6][byte(wTmp,  1)] ^ wSb[7][byte(wTmp,  3)] ^ wSb[7][byte(wOrg, 10)];
   wTmp[ 2] = wOrg[3] ^ wSb[4][byte(wTmp,  7)] ^ wSb[5][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  5)] ^ wSb[7][byte(wTmp,  4)] ^ wSb[4][byte(wOrg,  9)];
   wTmp[ 3] = wOrg[1] ^ wSb[4][byte(wTmp, 10)] ^ wSb[5][byte(wTmp,  9)] ^ wSb[6][byte(wTmp, 11)] ^ wSb[7][byte(wTmp,  8)] ^ wSb[5][byte(wOrg, 11)];
   wKey[16] = (wSb[4][byte(wTmp,  8)] ^ wSb[5][byte(wTmp,  9)] ^ wSb[6][byte(wTmp,  7)] ^ wSb[7][byte(wTmp,  6)] ^ wSb[4][byte(wTmp,  2)]) & 0x1f;
   wKey[17] = (wSb[4][byte(wTmp, 10)] ^ wSb[5][byte(wTmp, 11)] ^ wSb[6][byte(wTmp,  5)] ^ wSb[7][byte(wTmp,  4)] ^ wSb[5][byte(wTmp,  6)]) & 0x1f;
   wKey[18] = (wSb[4][byte(wTmp, 12)] ^ wSb[5][byte(wTmp, 13)] ^ wSb[6][byte(wTmp,  3)] ^ wSb[7][byte(wTmp,  2)] ^ wSb[6][byte(wTmp,  9)]) & 0x1f;
   wKey[19] = (wSb[4][byte(wTmp, 14)] ^ wSb[5][byte(wTmp, 15)] ^ wSb[6][byte(wTmp,  1)] ^ wSb[7][byte(wTmp,  0)] ^ wSb[7][byte(wTmp, 12)]) & 0x1f;
   wOrg[ 0] = wTmp[2] ^ wSb[4][byte(wTmp,  5)] ^ wSb[5][byte(wTmp,  7)] ^ wSb[6][byte(wTmp,  4)] ^ wSb[7][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  0)];
   wOrg[ 1] = wTmp[0] ^ wSb[4][byte(wOrg,  0)] ^ wSb[5][byte(wOrg,  2)] ^ wSb[6][byte(wOrg,  1)] ^ wSb[7][byte(wOrg,  3)] ^ wSb[7][byte(wTmp,  2)];
   wOrg[ 2] = wTmp[1] ^ wSb[4][byte(wOrg,  7)] ^ wSb[5][byte(wOrg,  6)] ^ wSb[6][byte(wOrg,  5)] ^ wSb[7][byte(wOrg,  4)] ^ wSb[4][byte(wTmp,  1)];
   wOrg[ 3] = wTmp[3] ^ wSb[4][byte(wOrg, 10)] ^ wSb[5][byte(wOrg,  9)] ^ wSb[6][byte(wOrg, 11)] ^ wSb[7][byte(wOrg,  8)] ^ wSb[5][byte(wTmp,  3)];
   wKey[20] = (wSb[4][byte(wOrg,  3)] ^ wSb[5][byte(wOrg,  2)] ^ wSb[6][byte(wOrg, 12)] ^ wSb[7][byte(wOrg, 13)] ^ wSb[4][byte(wOrg,  8)]) & 0x1f;
   wKey[21] = (wSb[4][byte(wOrg,  1)] ^ wSb[5][byte(wOrg,  0)] ^ wSb[6][byte(wOrg, 14)] ^ wSb[7][byte(wOrg, 15)] ^ wSb[5][byte(wOrg, 13)]) & 0x1f;
   wKey[22] = (wSb[4][byte(wOrg,  7)] ^ wSb[5][byte(wOrg,  6)] ^ wSb[6][byte(wOrg,  8)] ^ wSb[7][byte(wOrg,  9)] ^ wSb[6][byte(wOrg,  3)]) & 0x1f;
   wKey[23] = (wSb[4][byte(wOrg,  5)] ^ wSb[5][byte(wOrg,  4)] ^ wSb[6][byte(wOrg, 10)] ^ wSb[7][byte(wOrg, 11)] ^ wSb[7][byte(wOrg,  7)]) & 0x1f;
   wTmp[ 0] = wOrg[0] ^ wSb[4][byte(wOrg, 13)] ^ wSb[5][byte(wOrg, 15)] ^ wSb[6][byte(wOrg, 12)] ^ wSb[7][byte(wOrg, 14)] ^ wSb[6][byte(wOrg,  8)];
   wTmp[ 1] = wOrg[2] ^ wSb[4][byte(wTmp,  0)] ^ wSb[5][byte(wTmp,  2)] ^ wSb[6][byte(wTmp,  1)] ^ wSb[7][byte(wTmp,  3)] ^ wSb[7][byte(wOrg, 10)];
   wTmp[ 2] = wOrg[3] ^ wSb[4][byte(wTmp,  7)] ^ wSb[5][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  5)] ^ wSb[7][byte(wTmp,  4)] ^ wSb[4][byte(wOrg,  9)];
   wTmp[ 3] = wOrg[1] ^ wSb[4][byte(wTmp, 10)] ^ wSb[5][byte(wTmp,  9)] ^ wSb[6][byte(wTmp, 11)] ^ wSb[7][byte(wTmp,  8)] ^ wSb[5][byte(wOrg, 11)];
   wKey[24] = (wSb[4][byte(wTmp,  3)] ^ wSb[5][byte(wTmp,  2)] ^ wSb[6][byte(wTmp, 12)] ^ wSb[7][byte(wTmp, 13)] ^ wSb[4][byte(wTmp,  9)]) & 0x1f;
   wKey[25] = (wSb[4][byte(wTmp,  1)] ^ wSb[5][byte(wTmp,  0)] ^ wSb[6][byte(wTmp, 14)] ^ wSb[7][byte(wTmp, 15)] ^ wSb[5][byte(wTmp, 12)]) & 0x1f;
   wKey[26] = (wSb[4][byte(wTmp,  7)] ^ wSb[5][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  8)] ^ wSb[7][byte(wTmp,  9)] ^ wSb[6][byte(wTmp,  2)]) & 0x1f;
   wKey[27] = (wSb[4][byte(wTmp,  5)] ^ wSb[5][byte(wTmp,  4)] ^ wSb[6][byte(wTmp, 10)] ^ wSb[7][byte(wTmp, 11)] ^ wSb[7][byte(wTmp,  6)]) & 0x1f;
   wOrg[ 0] = wTmp[2] ^ wSb[4][byte(wTmp,  5)] ^ wSb[5][byte(wTmp,  7)] ^ wSb[6][byte(wTmp,  4)] ^ wSb[7][byte(wTmp,  6)] ^ wSb[6][byte(wTmp,  0)];
   wOrg[ 1] = wTmp[0] ^ wSb[4][byte(wOrg,  0)] ^ wSb[5][byte(wOrg,  2)] ^ wSb[6][byte(wOrg,  1)] ^ wSb[7][byte(wOrg,  3)] ^ wSb[7][byte(wTmp,  2)];
   wOrg[ 2] = wTmp[1] ^ wSb[4][byte(wOrg,  7)] ^ wSb[5][byte(wOrg,  6)] ^ wSb[6][byte(wOrg,  5)] ^ wSb[7][byte(wOrg,  4)] ^ wSb[4][byte(wTmp,  1)];
   wOrg[ 3] = wTmp[3] ^ wSb[4][byte(wOrg, 10)] ^ wSb[5][byte(wOrg,  9)] ^ wSb[6][byte(wOrg, 11)] ^ wSb[7][byte(wOrg,  8)] ^ wSb[5][byte(wTmp,  3)];
   wKey[28] = (wSb[4][byte(wOrg,  8)] ^ wSb[5][byte(wOrg,  9)] ^ wSb[6][byte(wOrg,  7)] ^ wSb[7][byte(wOrg,  6)] ^ wSb[4][byte(wOrg,  3)]) & 0x1f;
   wKey[29] = (wSb[4][byte(wOrg, 10)] ^ wSb[5][byte(wOrg, 11)] ^ wSb[6][byte(wOrg,  5)] ^ wSb[7][byte(wOrg,  4)] ^ wSb[5][byte(wOrg,  7)]) & 0x1f;
   wKey[30] = (wSb[4][byte(wOrg, 12)] ^ wSb[5][byte(wOrg, 13)] ^ wSb[6][byte(wOrg,  3)] ^ wSb[7][byte(wOrg,  2)] ^ wSb[6][byte(wOrg,  8)]) & 0x1f;
   wKey[31] = (wSb[4][byte(wOrg, 14)] ^ wSb[5][byte(wOrg, 15)] ^ wSb[6][byte(wOrg,  1)] ^ wSb[7][byte(wOrg,  0)] ^ wSb[7][byte(wOrg, 13)]) & 0x1f;
}

CCASTBlock::CCASTBlock()
{
	dwData = 0;									// This is here for definiteness
}

CCASTBlock::CCASTBlock(const CCASTBlock &cCASTBlock)
{
	dwData = cCASTBlock.dwData;
}

CCASTBlock::CCASTBlock(Dword dwValue)
{
	dwData = dwValue;
}

CCASTBlock::CCASTBlock(const Byte *pbData, Word wLength)
{
	SetData(pbData, wLength);
}

CCASTBlock::~CCASTBlock()
{
	dwData = 0;									// Cleanup
}

void CCASTBlock::Encrypt(const CCASTKey &cCASTKey)
{
	Word l = LoWORD(dwData);
	Word r = HiWORD(dwData);
	Word s, t;
	const Word *k = cCASTKey.GetKeys();
	
	f(l, r, k[ 0], k[16]);
	g(r, l, k[ 1], k[17]);
	h(l, r, k[ 2], k[18]);
	f(r, l, k[ 3], k[19]);
	g(l, r, k[ 4], k[20]);
	h(r, l, k[ 5], k[21]);
	f(l, r, k[ 6], k[22]);
	g(r, l, k[ 7], k[23]);
	h(l, r, k[ 8], k[24]);
	f(r, l, k[ 9], k[25]);
	g(l, r, k[10], k[26]);
	h(r, l, k[11], k[27]);
	f(l, r, k[12], k[28]);
	g(r, l, k[13], k[29]);
	h(l, r, k[14], k[30]);
	f(r, l, k[15], k[31]);

	dwData = ((Dword)l << 32) | r;
	
	l = r = s = t = 0;						// Cleanup
}

void CCASTBlock::Decrypt(const CCASTKey &cCASTKey)
{
	Word l = HiWORD(dwData);
	Word r = LoWORD(dwData);
	Word s, t;
	const Word *k = cCASTKey.GetKeys();
	
	f(r, l, k[15], k[31]);
	h(l, r, k[14], k[30]);
	g(r, l, k[13], k[29]);
	f(l, r, k[12], k[28]);
	h(r, l, k[11], k[27]);
	g(l, r, k[10], k[26]);
	f(r, l, k[ 9], k[25]);
	h(l, r, k[ 8], k[24]);
	g(r, l, k[ 7], k[23]);
	f(l, r, k[ 6], k[22]);
	h(r, l, k[ 5], k[21]);
	g(l, r, k[ 4], k[20]);
	f(r, l, k[ 3], k[19]);
	h(l, r, k[ 2], k[18]);
	g(r, l, k[ 1], k[17]);
	f(l, r, k[ 0], k[16]);

	dwData = ((Dword)r << 32) | l;
	
	l = r = s = t = 0;						// Cleanup
}

void CCASTBlock::SetValue(Dword dwValue)
{
	dwData = dwValue;
}

Dword CCASTBlock::GetValue()
{
	return dwData;
}

void CCASTBlock::SetData(const Byte *pbData, Word wLength)
{
	dwData = 0;
	memcpy(&dwData, pbData, wLength);
	dwData = REVERSEDWORD(dwData);
}

Byte *CCASTBlock::GetData()
{
	dwResult = REVERSEDWORD(dwData);
	return (Byte *)&dwResult;
}