/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "mdc.hpp"

CDigestCipherKey::CDigestCipherKey(CDigest &cDigestObject) : cDigest(cDigestObject)
{
}

CDigestCipherKey::CDigestCipherKey(CDigest &cDigestObject, const Byte *bData, Word) : cDigest(cDigestObject), bKey(bData)
{
	wKeySize = cDigest.GetBlockSize();
}

const Byte *CDigestCipherKey::GetKey() const
{
	return bKey;
}

CDigestCipherBlock::CDigestCipherBlock(CDigest &cDigestClass) : cDigest(cDigestClass)
{
	wBlockSize = cDigest.GetFingerPrintSize();
}

CDigestCipherBlock::CDigestCipherBlock(CDigest &cDigestClass, const Byte *bData, Word) : cDigest(cDigestClass)
{
	wBlockSize = cDigest.GetFingerPrintSize();
	
	cDigest.SetFingerPrint(bData);
}

void CDigestCipherBlock::Encrypt(const CDigestCipherKey &cDigestCipherKey)
{
	cDigest.SetBlock(cDigestCipherKey.GetKey());
	cDigest.HashBlock();
}

void CDigestCipherBlock::SetData(const Byte *bData, Word wLength)
{
	wBlockSize = (0 == wLength ? cDigest.GetFingerPrintSize() : wLength);
	
	cDigest.SetFingerPrint(bData);
}

Byte *CDigestCipherBlock::GetData()
{
	return (Byte *)cDigest.GetFingerPrint();
}
