/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "shark.hpp"
#include "sharktables.hpp"
#include "gf256_1f5.hpp"

#define r(a, b, c)		\
a ^= b;						\
a = c[0][DWBYTE0(a)] ^	\
	 c[1][DWBYTE1(a)] ^	\
	 c[2][DWBYTE2(a)] ^	\
	 c[3][DWBYTE3(a)] ^	\
	 c[4][DWBYTE4(a)] ^	\
	 c[5][DWBYTE5(a)] ^	\
	 c[6][DWBYTE6(a)] ^	\
	 c[7][DWBYTE7(a)]

#define l(a, b, c)						\
a ^= b;										\
a = ((Dword)c[DWBYTE0(a)] << 56) ^	\
	 ((Dword)c[DWBYTE1(a)] << 48) ^	\
	 ((Dword)c[DWBYTE2(a)] << 40) ^	\
	 ((Dword)c[DWBYTE3(a)] << 32) ^	\
	 ((Dword)c[DWBYTE4(a)] << 24) ^	\
	 ((Dword)c[DWBYTE5(a)] << 16) ^	\
	 ((Dword)c[DWBYTE6(a)] <<  8) ^	\
	 ((Dword)c[DWBYTE7(a)]      )

#define f(a, p)														\
for (int ii = 0; ii < (SHARKROUNDS - 1); ii++) {			\
	r(a, p[ii], dwSHARKE);											\
}																			\
l(a, p[SHARKROUNDS - 1], bSHARKE);								\
a ^= p[SHARKROUNDS]

#define g(a, p)														\
for (int i = 0; i < (SHARKROUNDS - 1); i++) {				\
	r(a, p[i], dwSHARKD);											\
}																			\
l(a, p[SHARKROUNDS - 1], bSHARKD);								\
a ^= p[SHARKROUNDS]

#define u(a, b)										\
gf256_1f5_mul(bSHARKI[b][0], DWBYTE0(a)) ^	\
gf256_1f5_mul(bSHARKI[b][1], DWBYTE1(a)) ^	\
gf256_1f5_mul(bSHARKI[b][2], DWBYTE2(a)) ^	\
gf256_1f5_mul(bSHARKI[b][3], DWBYTE3(a)) ^	\
gf256_1f5_mul(bSHARKI[b][4], DWBYTE4(a)) ^	\
gf256_1f5_mul(bSHARKI[b][5], DWBYTE5(a)) ^	\
gf256_1f5_mul(bSHARKI[b][6], DWBYTE6(a)) ^	\
gf256_1f5_mul(bSHARKI[b][7], DWBYTE7(a))

#define t(a)			\
MAKEDWORDB(u(a, 0),	\
			  u(a, 1),	\
			  u(a, 2),	\
			  u(a, 3),	\
			  u(a, 4),	\
			  u(a, 5),	\
			  u(a, 6),	\
			  u(a, 7))

CSHARKKey::CSHARKKey()
{
}

CSHARKKey::CSHARKKey(const CSHARKKey &cSHARKKey)
{
	for (int i = 0; i < 16; i++)
		bMaster[i] = cSHARKKey.bMaster[i];
	MakeKeys();
}

CSHARKKey::CSHARKKey(const Byte *pbMasterKey, Word wLength)
{
	memcpy(bMaster, pbMasterKey, wLength);
	memset(bMaster + wLength, 0, sizeof(bMaster) - wLength);
//	for (int i = 0; i < 2; i++)
//		((Dword *)bMaster)[i] = REVERSEDWORD(((Dword *)bMaster)[i]);
	MakeKeys();
}

CSHARKKey::~CSHARKKey()
{
	int i;
	for (i = 0; i < 16; i++)				// Cleanup
		bMaster[i] = 0;
	for (i = 0; i <= SHARKROUNDS; i++)
		dwEncryptionKey[i] = dwDecryptionKey[i] = 0;
}

void CSHARKKey::MakeKeys()
{
	Dword dwTemp[SHARKROUNDS + 1];
	Dword dwBuff[SHARKROUNDS + 1];
	Dword dw = DWORDCONST(0);

	int i;
	for (i = 0; i <= SHARKROUNDS; i++)
		dwTemp[i] = dwSHARKE[0][i];
	dwTemp[SHARKROUNDS] = t(dwTemp[SHARKROUNDS]);
	
	for (i = 0; i <= SHARKROUNDS; i++)
		dwBuff[i] = MAKEDWORDB(bMaster[(i * 8    ) % 16],
									  bMaster[(i * 8 + 1) % 16],
									  bMaster[(i * 8 + 2) % 16],
									  bMaster[(i * 8 + 3) % 16],
									  bMaster[(i * 8 + 4) % 16],
									  bMaster[(i * 8 + 5) % 16],
									  bMaster[(i * 8 + 6) % 16],
									  bMaster[(i * 8 + 7) % 16]);
	
	f(dw, dwTemp);
	dwEncryptionKey[0] = dwBuff[0] ^ dw;
	for (i = 1; i <= SHARKROUNDS; i++) {
		dw = dwEncryptionKey[i - 1];
		f(dw, dwTemp);
		dwEncryptionKey[i] = dwBuff[i] ^ dw;
	}
	dwEncryptionKey[SHARKROUNDS] = t(dwEncryptionKey[SHARKROUNDS]);
	
	dwDecryptionKey[0] = dwEncryptionKey[SHARKROUNDS];
	dwDecryptionKey[SHARKROUNDS] = dwEncryptionKey[0];
	for (i = 1; i < SHARKROUNDS; i++)
		dwDecryptionKey[i] = t(dwEncryptionKey[SHARKROUNDS - i]);
	
	for (i = 0; i <= SHARKROUNDS; i++)
		dwTemp[i] = dwBuff[i] = 0;			// Cleanup
}

CSHARKBlock::CSHARKBlock()
{
	dwData = 0;									// This is here for definiteness
}

CSHARKBlock::CSHARKBlock(const CSHARKBlock &cSHARKBlock)
{
	dwData = cSHARKBlock.dwData;
}

CSHARKBlock::CSHARKBlock(Dword dwValue)
{
	dwData = dwValue;
	dwValue = 0;								// Cleanup
}

CSHARKBlock::CSHARKBlock(const Byte *pbData, Word wLength)
{
	SetData(pbData, wLength);
}

CSHARKBlock::~CSHARKBlock()
{
	dwData = 0;									// Cleanup
}

void CSHARKBlock::Encrypt(const CSHARKKey &cSHARKKey)
{
	const Dword *pdwKeys = cSHARKKey.GetEncryptionKeys();
	f(dwData, pdwKeys);
}

void CSHARKBlock::Decrypt(const CSHARKKey &cSHARKKey)
{
	const Dword *pdwKeys = cSHARKKey.GetDecryptionKeys();
	g(dwData, pdwKeys);
}

void CSHARKBlock::SetValue(Dword dwValue)
{
	dwData = dwValue;
}

Dword CSHARKBlock::GetValue()
{
	return dwData;
}

void CSHARKBlock::SetData(const Byte *pbData, Word wLength)
{
	dwData = 0;
	memcpy(&dwData, pbData, wLength);
	dwData = REVERSEDWORD(dwData);
}

Byte *CSHARKBlock::GetData()
{
	dwResult = REVERSEDWORD(dwData);
	return (Byte *)&dwResult;
}
