/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "twofish.hpp"
#include "twofishtables.hpp"

#define rol(p, q) (((p) << (q)) | ((p) >> (32 - (q))))
#define ror(p, q) (((p) >> (q)) | ((p) << (32 - (q))))

#define h(a, b) wM[0][bQ[0][bQ[0][bQ[1][bQ[1][WBYTE3(a)] ^ WBYTE3(b[3])] ^ WBYTE3(b[2])] ^ WBYTE3(b[1])] ^ WBYTE3(b[0])] ^ \
					 wM[1][bQ[0][bQ[1][bQ[1][bQ[0][WBYTE2(a)] ^ WBYTE2(b[3])] ^ WBYTE2(b[2])] ^ WBYTE2(b[1])] ^ WBYTE2(b[0])] ^ \
					 wM[2][bQ[1][bQ[0][bQ[0][bQ[0][WBYTE1(a)] ^ WBYTE1(b[3])] ^ WBYTE1(b[2])] ^ WBYTE1(b[1])] ^ WBYTE1(b[0])] ^ \
					 wM[3][bQ[1][bQ[1][bQ[0][bQ[1][WBYTE0(a)] ^ WBYTE0(b[3])] ^ WBYTE0(b[2])] ^ WBYTE0(b[1])] ^ WBYTE0(b[0])]

#define i(a, b) wM[0][bQ[0][bQ[0][bQ[1][WBYTE3(a)] ^ WBYTE3(b[2])] ^ WBYTE3(b[1])] ^ WBYTE3(b[0])] ^ \
					 wM[1][bQ[0][bQ[1][bQ[1][WBYTE2(a)] ^ WBYTE2(b[2])] ^ WBYTE2(b[1])] ^ WBYTE2(b[0])] ^ \
					 wM[2][bQ[1][bQ[0][bQ[0][WBYTE1(a)] ^ WBYTE1(b[2])] ^ WBYTE1(b[1])] ^ WBYTE1(b[0])] ^ \
					 wM[3][bQ[1][bQ[1][bQ[0][WBYTE0(a)] ^ WBYTE0(b[2])] ^ WBYTE0(b[1])] ^ WBYTE0(b[0])]

#define j(a, b) wM[0][bQ[0][bQ[0][WBYTE3(a)] ^ WBYTE3(b[1])] ^ WBYTE3(b[0])] ^ \
					 wM[1][bQ[0][bQ[1][WBYTE2(a)] ^ WBYTE2(b[1])] ^ WBYTE2(b[0])] ^ \
					 wM[2][bQ[1][bQ[0][WBYTE1(a)] ^ WBYTE1(b[1])] ^ WBYTE1(b[0])] ^ \
					 wM[3][bQ[1][bQ[1][WBYTE0(a)] ^ WBYTE0(b[1])] ^ WBYTE0(b[0])]

#define g0(x, y)	y(x, pwSKey)
#define g1(x, y)	y(rol(x, 8), pwSKey)

#define f(i, y)																		\
	t1 = g1(wData[1], y);															\
	t0 = g0(wData[0], y);															\
	wData[2] = ror(wData[2] ^ (t0 + t1 + pwKey[4 * i + 8]), 1);			\
	wData[3] = rol(wData[3], 1) ^ (t0 + 2 * t1 + pwKey[4 * i + 9]);	\
	t1 = g1(wData[3], y);															\
	t0 = g0(wData[2], y);															\
	wData[0] = ror(wData[0] ^ (t0 + t1 + pwKey[4 * i + 10]), 1);		\
	wData[1] = rol(wData[1], 1) ^ (t0 + 2 * t1 + pwKey[4 * i + 11])

#define g(i, y)																		\
	t1 = g1(wData[1], y);															\
	t0 = g0(wData[0], y);															\
	wData[2] = rol(wData[2], 1) ^ (t0 + t1 + pwKey[4 * i + 10]);		\
	wData[3] = ror(wData[3] ^ (t0 + 2 * t1 + pwKey[4 * i + 11]), 1);	\
	t1 = g1(wData[3], y);															\
	t0 = g0(wData[2], y);															\
	wData[0] = rol(wData[0], 1) ^ (t0 + t1 + pwKey[4 * i + 8]);			\
	wData[1] = ror(wData[1] ^ (t0 + 2 * t1 + pwKey[4 * i + 9]), 1)

#define m(b, c, d)						\
Word a = b; d = c;						\
for (int ii = 0; ii < 8; ii++) {		\
	Word t = d >> 24;						\
	d = (d << 8) | (a >> 24);			\
	a <<= 8;									\
	Word u = (t << 1);					\
	if (t & 0x80)							\
		u ^= 0x14d;							\
	d ^= t ^ (u << 16);					\
	u ^= (t >> 1);							\
	if (t & 0x01)							\
		u ^= 0x14d >> 1;					\
	d ^= (u << 24) | (u << 8);			\
}												\

CTwofishKey::CTwofishKey()
{
}

CTwofishKey::CTwofishKey(const CTwofishKey &cTwofishKey)
{
	for (int i = 0; i < 32; i++)
		bMaster[i] = cTwofishKey.bMaster[i];
	wKeyLength = cTwofishKey.wKeyLength;
	MakeKeys();
}

CTwofishKey::CTwofishKey(const Byte *pbMasterKey, Word wKeyLength)
{
	Word i;
	CTwofishKey::wKeyLength = wKeyLength;
	for (i = 0; i < wKeyLength; i++)
		bMaster[i] = pbMasterKey[i];
	for ( ; i < 32; i++)
		bMaster[i] = 0;
	MakeKeys();
}

CTwofishKey::~CTwofishKey()
{
	int i;
	for (i = 0; i < 32; i++)				// Cleanup
		bMaster[i] = 0;
	for (i = 0; i < 40; i++)
		wKey[i] = 0;
}

void CTwofishKey::MakeKeys()
{
	Word A, B, i;
	Word Mo[4];
	Word Me[4];
	
	if (wKeyLength <= 16)
		wKeyLength = 2;
	else if (wKeyLength <= 24)
		wKeyLength = 3;
	else
		wKeyLength = 4;
	
	for (i = 0; i < wKeyLength; i++) {
		Me[i] = MakeWord(bMaster[4 * (i * 2) + 3],
							  bMaster[4 * (i * 2) + 2],
							  bMaster[4 * (i * 2) + 1],
							  bMaster[4 * (i * 2) + 0]);
		Mo[i] = MakeWord(bMaster[4 * (i * 2 + 1) + 3],
							  bMaster[4 * (i * 2 + 1) + 2],
							  bMaster[4 * (i * 2 + 1) + 1],
							  bMaster[4 * (i * 2 + 1) + 0]);
		m(Me[i], Mo[i], wSKey[wKeyLength - 1 - i]);
	}
	for (i = 0; i < 20; i++) {
		A = 0x02020202 * i;
		B = A + 0x01010101;
		switch (wKeyLength) {
			case 2:
				A = j(A, Me);
				B = rol(j(B, Mo), 8);
			break;
			case 3:
				A = i(A, Me);
				B = rol(i(B, Mo), 8);
			break;
			case 4:
				A = h(A, Me);
				B = rol(h(B, Mo), 8);
			break;
		}
		wKey[i * 2] = A + B;
		wKey[i * 2 + 1] = rol(A + 2 * B, 9);
	}
	A = B = 0;									// Cleanup
}

CTwofishBlock::CTwofishBlock()
{
	for (int i = 0; i < 4; i++)			// This is here for definiteness
		wData[i] = 0;
}

CTwofishBlock::CTwofishBlock(const CTwofishBlock &cTwofishBlock)
{
	for (int i = 0; i < 4; i++)	
		wData[i] = cTwofishBlock.wData[i];
}

CTwofishBlock::CTwofishBlock(Word a, Word b, Word c, Word d)
{
	wData[0] = a;
	wData[1] = b;
	wData[2] = c;
	wData[3] = d;
}

CTwofishBlock::CTwofishBlock(const Byte *pbData, Word wLength)
{
	SetData(pbData, wLength);
}

CTwofishBlock::~CTwofishBlock()
{
	for (int i = 0; i < 4; i++)			// Cleanup
		wData[i] = 0;
}

void CTwofishBlock::Encrypt(const CTwofishKey &cTwofishKey)
{
	Word t0, t1, z;
	const Word *pwKey = cTwofishKey.GetKeys();
	const Word *pwSKey = cTwofishKey.GetSKeys();

	wData[0] ^= pwKey[0];
	wData[1] ^= pwKey[1];
	wData[2] ^= pwKey[2];
	wData[3] ^= pwKey[3];

	switch (cTwofishKey.GetKeyLength()) {
		case 2:
			for (z = 0; z < 8; z++) {
				f(z, j);
			}
//			f(0, j); f(1, j); f(2, j); f(3, j);
//			f(4, j); f(5, j); f(6, j); f(7, j);
		break;
		case 3:
			for (z = 0; z < 8; z++) {
				f(z, i);
			}
//			f(0, i); f(1, i); f(2, i); f(3, i);
//			f(4, i); f(5, i); f(6, i); f(7, i);
		break;
		case 4:
			for (z = 0; z < 8; z++) {
				f(z, h);
			}
//			f(0, h); f(1, h); f(2, h); f(3, h);
//			f(4, h); f(5, h); f(6, h); f(7, h);
		break;
	}

	t0 = wData[0];
	t1 = wData[1];
	wData[0] = wData[2] ^ pwKey[4];
	wData[1] = wData[3] ^ pwKey[5];
	wData[2] = t0 ^ pwKey[6];
	wData[3] = t1 ^ pwKey[7];

	t0 = t1 = 0;								// Cleanup
}

void CTwofishBlock::Decrypt(const CTwofishKey &cTwofishKey)
{
	Word t0, t1, z;
	const Word *pwKey = cTwofishKey.GetKeys();
	const Word *pwSKey = cTwofishKey.GetSKeys();

	wData[0] ^= pwKey[4];
	wData[1] ^= pwKey[5];
	wData[2] ^= pwKey[6];
	wData[3] ^= pwKey[7];

	switch (cTwofishKey.GetKeyLength()) {
		case 2:
			for (z = 7; z < 8; z--) {
				g(z, j);
			}
//			g(7, j); g(6, j); g(5, j); g(4, j);
//			g(3, j); g(2, j); g(1, j); g(0, j);
		break;
		case 3:
			for (z = 7; z < 8; z--) {
				g(z, i);
			}
//			g(7, i); g(6, i); g(5, i); g(4, i);
//			g(3, i); g(2, i); g(1, i); g(0, i);
		break;
		case 4:
			for (z = 7; z < 8; z--) {
				g(z, h);
			}
//			g(7, h); g(6, h); g(5, h); g(4, h);
//			g(3, h); g(2, h); g(1, h); g(0, h);
		break;
	}

	t0 = wData[0];
	t1 = wData[1];
	wData[0] = wData[2] ^ pwKey[0];
	wData[1] = wData[3] ^ pwKey[1];
	wData[2] = t0 ^ pwKey[2];
	wData[3] = t1 ^ pwKey[3];

	t0 = t1 = 0;								// Cleanup
}

void CTwofishBlock::SetData(const Byte *pbData, Word wLength)
{
	memcpy((Byte *)wData, pbData, wLength);
	memset((Byte *)wData + wLength, 0, sizeof(wData) - wLength);
}

Byte *CTwofishBlock::GetData()
{
	return (Byte *)wData;
}
