/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __AGREE_HPP__
#define __AGREE_HPP__

#include <sys/types.h>

#ifndef WIN32
#include <netinet/in.h>
#include <unistd.h>
#endif

#include "globals.hpp"
#include "methods.hpp"
#include "strings.hpp"
#include "sclio.hpp"
#include "conf.hpp"

#ifdef WIN32
#include <winsock2.h>

#define bzero(p, q) memset(p, 0, q)
#define snprintf _snprintf
#define mkdir(p, q) mkdir(p)

#endif

#define AGREE		0x17
#define REFUSE		0x18

typedef struct {
	Byte bSymmetric;
	Byte bDigest;
	Byte bAsymmetric;
	Word wBlockSize;
	Word wKeySize;
	Word wDigestSize;
	bool fgKeyExchange;
} AGREEMENT_STR;

extern bool ServerAgree(CConfigurationFile *, int, AGREEMENT_STR *);
extern bool ClientAgree(CConfigurationFile *, int, AGREEMENT_STR *);

#endif // __AGREE_HPP__
