/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __METHODS_HPP__
#define __METHODS_HPP__

#include "keyexchange.hpp"
#include "digest.hpp"
#include "block.hpp"
#include "public.hpp"

#include "rsa.hpp"
#include "rabin.hpp"
#include "bg.hpp"
#include "elgamal.hpp"
#include "dsa.hpp"
#include "dh.hpp"
#include "mqv.hpp"

#include "cast.hpp"
#include "idea.hpp"
#include "3way.hpp"
#include "rijndael.hpp"
#include "des.hpp"
#include "mars.hpp"
#include "twofish.hpp"
#include "serpent.hpp"
#include "rc6.hpp"
#include "rc5.hpp"
#include "rc2.hpp"
#include "safer.hpp"
#include "gost.hpp"
#include "diamond.hpp"
#include "square.hpp"
#include "shark.hpp"
#include "loki.hpp"
#include "blowfish.hpp"
#include "feal.hpp"

#include "md2.hpp"
#include "md4.hpp"
#include "md5.hpp"
#include "ripemd160.hpp"
#include "sha1.hpp"
#include "tiger.hpp"
#include "haval.hpp"

#define EMPTY			0x00

#define SYMMETRIC		0x01
#define SERPENT		0x02
#define RC6				0x03
#define LOKI97			0x04
#define MARS			0x05
#define TWOFISH		0x06
#define RIJNDAEL		0x07
#define RC5				0x08
#define TRIPLEDES		0x09
#define IDEA			0x0A
#define SAFER			0x0B
#define FEAL			0x0C
#define THREEWAY		0x0D
#define BLOWFISH		0x0E
#define DIAMOND		0x0F
#define CAST			0x10
#define SHARK			0x11
#define DES				0x12
#define RC2				0x13
#define GOST			0x14
#define SQUARE			0x15

#define DIGEST			0x40
#define TIGER			0x41
#define MD5				0x42
#define RIPEMD			0x43
#define SHA1			0x44
#define HAVAL			0x45
#define MD2				0x46
#define MD4				0x47

#define ASYMMETRIC	0x70
#define RSA				0x71
#define DH				0x72
#define MQV				0x73
#define RABIN			0x74
#define BG				0x75
#define ELGAMAL		0x76

#define LAST			0xFF

typedef struct {
	char *pszName;
	Byte bID;
	Word wParam1;
	Word wParam2;
} METHOD_ID;

extern CAsymmetricBlock *NewAsymmetricBlock(Byte, CAsymmetricKey *);
extern CAsymmetricKey *NewAsymmetricKey(Byte);
extern CKeyExchange *NewKeyExchange(Byte, CAsymmetricKey *);
extern CBlockObject *NewSymmetricBlock(Byte, Byte *);
extern CBlockKey *NewSymmetricKey(Byte, Byte *, Word);
extern CDigest *NewDigest(Byte, Byte *, Word);
extern char *FindName(Byte);
extern Word FindParam(Byte, Byte);
extern Byte FindID(char *, Byte, Byte);

#endif // __METHODS_HPP__
