/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SSSL_HPP__
#define __SSSL_HPP__

#include "config.h"

#define SSSL_API

#ifdef WIN32
# ifdef SSSL_EXPORTS
#	undef SSSL_API
#	define SSSL_API __declspec(dllexport)
# endif
# ifdef SSSL_IMPORTS
#	undef SSSL_API
#	define SSSL_API __declspec(dllimport)
# endif
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SETRLIMIT
# ifdef HAVE_SYS_RESOURCE_H
#	include <sys/resource.h>
# endif
#endif

#ifndef WIN32
# include <sys/socket.h>
# include <netinet/in.h>
# include <arpa/inet.h>
# ifdef HAVE_WORDEXP_H
#	include <wordexp.h>
# endif
# include <unistd.h>
# include <string.h>
# include <stdlib.h>
# include <stdio.h>
#else
# include <direct.h>
# include <winsock2.h>
#endif

#include "settings.hpp"
#include "strings.hpp"
#include "methods.hpp"
#include "initrnd.hpp"
#include "errors.hpp"
#include "digest.hpp"
#include "space.hpp"
#include "block.hpp"
#include "agree.hpp"
#include "conf.hpp"

#ifdef _SOCKLEN_T_UNDEFINED
	typedef int socklen_t;
#endif

// Request type identifiers. This value is sent (in an octet) from the
// client to the server. If the client knows the public key of the server
// she only needs to know its hash. This fingerprint will be used to match
// the public key on the file system of the client with the "real" public
// key of the server. The connection will not continue if there is a
// the calculated hash of the public key and that, received from the server
// are distinct.
#define GET_KEY					1
#define GET_HASH					2

#define HASH_OK					3
#define HASH_BAD					4

#define SSSL_NO_ERROR			0
#define BAD_ALLOCCALL			1
#define BAD_ACCEPTCALL			2
#define BAD_CONNECTCALL			3
#define BAD_PRIVATEKEY			4
#define BAD_PUBLICKEY			5
#define BAD_HASH					6
#define BAD_CONFIGFILE			7
#define BAD_AGREEMENT			8
#define BAD_OPENCALL				9
#define BAD_KEYEXCHANGE		  10
#define BAD_SSSLSOCKET		  11
#define BAD_READCALL			  12
#define BAD_WRITECALL		  13
#define BAD_EXTENDED			  14
#define BAD_SAVEPUBLICKEY	  15
#define BAD_CLIENTPUBLIC	  16

#ifndef WIN32

# ifndef PATH_SYSCONFDIR
#	define PATH_SYSCONFDIR	  "/etc/sssl"
# endif

# define SSSL_CONFIG_FILE	  PATH_SYSCONFDIR "/sssl.conf"
# define PATH_PUBLICKEYDIR	  "~/.sssl"

#else

# define SSSL_CONFIG_FILE	  "\\windows\\sssl\\sssl.conf"
# define PATH_PUBLICKEYDIR	  "\\windows\\sssl"

#endif

extern SSSL_API int iSSSLError;

extern SSSL_API int SSSLaccept(int, struct sockaddr *, socklen_t *);
extern SSSL_API int SSSLconnect(int, const struct sockaddr *, socklen_t);
extern SSSL_API ssize_t SSSLread(int, void *, size_t);
extern SSSL_API ssize_t SSSLwrite(int, const void *, size_t);
extern SSSL_API int SSSLclose(int);
extern SSSL_API char *SSSLerror();

#endif // __SSSL_HPP__
