/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    transient ComponentPeer peer;
    transient Container parent;
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Cursor cursor = Cursor.getPredefinedCursor(0);
    Locale locale;
    boolean visible = true;
    boolean enabled = true;
    boolean valid = false;
    Vector popups;
    String name;
    static final Object LOCK = new Object();
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly = false;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    static final String actionListenerK = "actionL";
    static final String adjustmentListenerK = "adjustmentL";
    static final String componentListenerK = "componentL";
    static final String containerListenerK = "containerL";
    static final String focusListenerK = "focusL";
    static final String itemListenerK = "itemL";
    static final String keyListenerK = "keyL";
    static final String mouseListenerK = "mouseL";
    static final String mouseMotionListenerK = "mouseMotionL";
    static final String textListenerK = "textL";
    static final String windowListenerK = "windowL";
    long eventMask;
    static boolean isInc;
    static int incRate;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    private static final long serialVersionUID = -7644114512714619750L;
    private int componentSerializedDataVersion = 1;

    protected Component() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public Toolkit getToolkit() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getToolkit();
        }
        Container container = this.parent;
        if (container != null) {
            return container.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (this.visible && this.peer != null) {
            Container container = this.parent;
            return container == null || container.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable() {
        if (!this.enabled) {
            Component component = this;
            synchronized (component) {
                this.enabled = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.enable();
                }
                return;
            }
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
            return;
        }
        this.disable();
    }

    public void disable() {
        if (this.enabled) {
            Component component = this;
            synchronized (component) {
                this.enabled = false;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.disable();
                }
                return;
            }
        }
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if (!this.visible) {
            Object object = LOCK;
            synchronized (object) {
                this.visible = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.show();
                    if (componentPeer instanceof LightweightPeer) {
                        this.repaint();
                    }
                }
                if (this.componentListener != null) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
            return;
        }
        this.hide();
    }

    public void hide() {
        if (this.visible) {
            Object object = LOCK;
            synchronized (object) {
                this.visible = false;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.hide();
                    if (componentPeer instanceof LightweightPeer) {
                        this.repaint();
                    }
                }
                if (this.componentListener != null) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 103);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getForeground();
        }
        return null;
    }

    public void setForeground(Color color) {
        ComponentPeer componentPeer = this.peer;
        this.foreground = color;
        if (componentPeer != null && (color = this.getForeground()) != null) {
            componentPeer.setForeground(color);
        }
    }

    public Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getBackground();
        }
        return null;
    }

    public void setBackground(Color color) {
        ComponentPeer componentPeer = this.peer;
        this.background = color;
        if (componentPeer != null && (color = this.getBackground()) != null) {
            componentPeer.setBackground(color);
        }
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getFont();
        }
        return null;
    }

    public synchronized void setFont(Font font) {
        ComponentPeer componentPeer = this.peer;
        this.font = font;
        if (componentPeer != null && (font = this.getFont()) != null) {
            componentPeer.setFont(font);
        }
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.parent;
        if (container == null) {
            throw new IllegalComponentStateException("This component must have a parent in order to determine its locale");
        }
        return container.getLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ColorModel getColorModel() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point getLocationOnScreen() {
        Object object = LOCK;
        synchronized (object) {
            if (this.peer == null) throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
            if (!this.isShowing()) throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
            Point point = this.peer.getLocationOnScreen();
            if (!(this.peer instanceof LightweightPeer)) return point;
            Container container = this.getNativeContainer();
            Point point2 = container.peer.getLocationOnScreen();
            Component component = this;
            while (component != container) {
                point2.x += component.x;
                point2.y += component.y;
                component = component.getParent();
            }
            return point2;
        }
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = this.width != n3 || this.height != n4;
            boolean bl2 = this.x != n || this.y != n2;
            boolean bl3 = this.peer instanceof LightweightPeer;
            if (bl || bl2) {
                if (bl3) {
                    this.repaint();
                }
                this.x = n;
                this.y = n2;
                this.width = n3;
                this.height = n4;
                if (this.peer != null) {
                    if (this.peer instanceof LightweightPeer) {
                        this.peer.setBounds(n, n2, n3, n4);
                    } else {
                        int n5 = n;
                        int n6 = n2;
                        Container container = this.parent;
                        while (container != null && container.peer instanceof LightweightPeer) {
                            n5 += container.x;
                            n6 += container.y;
                            container = container.parent;
                        }
                        this.peer.setBounds(n5, n6, n3, n4);
                    }
                    if (bl) {
                        this.invalidate();
                        if (this.componentListener != null) {
                            ComponentEvent componentEvent = new ComponentEvent(this, 101);
                            Toolkit.getEventQueue().postEvent(componentEvent);
                        }
                    }
                    if (bl2 && this.componentListener != null) {
                        ComponentEvent componentEvent = new ComponentEvent(this, 100);
                        Toolkit.getEventQueue().postEvent(componentEvent);
                    }
                    if (this.parent != null && this.parent.valid) {
                        this.parent.invalidate();
                    }
                    if (bl3) {
                        this.repaint();
                    }
                }
            }
            return;
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = LOCK;
        synchronized (object) {
            Dimension dimension2 = this.prefSize = this.peer != null ? this.peer.preferredSize() : this.getMinimumSize();
            Object var4_4 = null;
            return dimension2;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = LOCK;
        synchronized (object) {
            Dimension dimension2 = this.minSize = this.peer != null ? this.peer.minimumSize() : this.size();
            Object var4_4 = null;
            return dimension2;
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    public void validate() {
        if (!this.valid) {
            Object object = LOCK;
            synchronized (object) {
                this.valid = true;
                return;
            }
        }
    }

    public void invalidate() {
        Object object = LOCK;
        synchronized (object) {
            this.valid = false;
            this.prefSize = null;
            this.minSize = null;
            if (this.parent != null && this.parent.valid) {
                this.parent.invalidate();
            }
            return;
        }
    }

    public Graphics getGraphics() {
        if (this.peer instanceof LightweightPeer) {
            Graphics graphics = this.parent.getGraphics();
            graphics.translate(this.x, this.y);
            graphics.setClip(0, 0, this.width, this.height);
            return graphics;
        }
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.getGraphics();
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getFontMetrics(font);
        }
        return this.getToolkit().getFontMetrics(font);
    }

    public synchronized void setCursor(Cursor cursor) {
        this.cursor = cursor;
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            componentPeer.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        if (!(this.peer instanceof LightweightPeer)) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(this.getForeground());
        }
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (this.visible && componentPeer != null) {
            this.validate();
            if (componentPeer instanceof LightweightPeer) {
                this.paint(graphics);
                return;
            }
            componentPeer.paint(graphics);
        }
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.peer instanceof LightweightPeer) {
            this.parent.repaint(l, this.x + n, this.y + n2, n3, n4);
            return;
        }
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && n3 > 0 && n4 > 0) {
            componentPeer.repaint(l, n, n2, n3, n4);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (this.visible && componentPeer != null) {
            this.validate();
            componentPeer.print(graphics);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        if ((n & 0x30) != 0) {
            n6 = 0;
        } else if ((n & 8) != 0 && isInc) {
            try {
                n6 = incRate;
                if (n6 < 0) {
                    n6 = 0;
                }
            }
            catch (Exception exception) {
                n6 = 100;
            }
        }
        if (n6 >= 0) {
            this.repaint(n6, 0, 0, this.width, this.height);
        }
        return (n & 0xA0) == 0;
    }

    public Image createImage(ImageProducer imageProducer) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent.createImage(n, n2);
        }
        if (componentPeer != null) {
            return componentPeer.createImage(n, n2);
        }
        return null;
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent.prepareImage(image, n, n2, imageObserver);
        }
        if (componentPeer != null) {
            return componentPeer.prepareImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent.checkImage(image, n, n2, imageObserver);
        }
        if (componentPeer != null) {
            return componentPeer.checkImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean inside(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component locate(int n, int n2) {
        if (this.contains(n, n2)) {
            return this;
        }
        return null;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        Serializable serializable;
        int n = aWTEvent.getID();
        switch (n) {
            case 800: 
            case 801: {
                Graphics graphics = this.getGraphics();
                if (graphics == null) {
                    return;
                }
                Rectangle rectangle = ((PaintEvent)aWTEvent).getUpdateRect();
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (n == 800) {
                    this.paint(graphics);
                } else {
                    this.update(graphics);
                }
                graphics.dispose();
                return;
            }
            case 1004: {
                if (this.parent == null || this instanceof Window) break;
                this.parent.setFocusOwner(this);
                break;
            }
            case 401: 
            case 402: {
                Container container = (Container)(this instanceof Container ? this : this.parent);
                if (container == null) break;
                container.preProcessKeyEvent((KeyEvent)aWTEvent);
                break;
            }
        }
        if (this.newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            }
        } else if ((!(aWTEvent instanceof MouseEvent) || this.postsOldMouseEvents()) && (serializable = aWTEvent.convertToOld()) != null) {
            int n2 = ((Event)serializable).key;
            int n3 = ((Event)serializable).modifiers;
            this.postEvent((Event)serializable);
            if (((Event)serializable).isConsumed()) {
                aWTEvent.consume();
            }
            switch (((Event)serializable).id) {
                case 401: 
                case 402: 
                case 403: 
                case 404: {
                    if (((Event)serializable).key != n2) {
                        ((KeyEvent)aWTEvent).setKeyChar(((Event)serializable).getKeyEventChar());
                    }
                    if (((Event)serializable).modifiers == n3) break;
                    ((KeyEvent)aWTEvent).setModifiers(((Event)serializable).modifiers);
                    break;
                }
            }
        }
        if (!aWTEvent.isConsumed() && aWTEvent instanceof KeyEvent && (serializable = (Container)(this instanceof Container ? this : this.parent)) != null) {
            ((Container)serializable).postProcessKeyEvent((KeyEvent)aWTEvent);
        }
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                if ((this.eventMask & 1L) == 0L && this.componentListener == null) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this.eventMask & 4L) == 0L && this.focusListener == null) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this.eventMask & 8L) == 0L && this.keyListener == null) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this.eventMask & 0x10L) == 0L && this.mouseListener == null) break;
                return true;
            }
            case 503: 
            case 506: {
                if ((this.eventMask & 0x20L) == 0L && this.mouseMotionListener == null) break;
                return true;
            }
        }
        return aWTEvent.id > 1999;
    }

    public boolean postEvent(Event event) {
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        Container container = this.parent;
        int n = event.x;
        int n2 = event.y;
        if (container != null) {
            event.translate(this.x, this.y);
            if (container.postEvent(event)) {
                event.consume();
                return true;
            }
            event.x = n;
            event.y = n2;
        }
        return false;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(4L);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(8L);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(16L);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(32L);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(this.eventMask);
        }
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    return;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.componentListener != null) {
            int n = componentEvent.getID();
            switch (n) {
                case 101: {
                    this.componentListener.componentResized(componentEvent);
                    return;
                }
                case 100: {
                    this.componentListener.componentMoved(componentEvent);
                    return;
                }
                case 102: {
                    this.componentListener.componentShown(componentEvent);
                    return;
                }
                case 103: {
                    this.componentListener.componentHidden(componentEvent);
                    return;
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener != null) {
            int n = focusEvent.getID();
            switch (n) {
                case 1004: {
                    this.focusListener.focusGained(focusEvent);
                    return;
                }
                case 1005: {
                    this.focusListener.focusLost(focusEvent);
                    return;
                }
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            int n = keyEvent.getID();
            switch (n) {
                case 400: {
                    this.keyListener.keyTyped(keyEvent);
                    return;
                }
                case 401: {
                    this.keyListener.keyPressed(keyEvent);
                    return;
                }
                case 402: {
                    this.keyListener.keyReleased(keyEvent);
                    return;
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 501: {
                    this.mouseListener.mousePressed(mouseEvent);
                    return;
                }
                case 502: {
                    this.mouseListener.mouseReleased(mouseEvent);
                    return;
                }
                case 500: {
                    this.mouseListener.mouseClicked(mouseEvent);
                    return;
                }
                case 505: {
                    this.mouseListener.mouseExited(mouseEvent);
                    return;
                }
                case 504: {
                    this.mouseListener.mouseEntered(mouseEvent);
                    return;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 503: {
                    this.mouseMotionListener.mouseMoved(mouseEvent);
                    return;
                }
                case 506: {
                    this.mouseMotionListener.mouseDragged(mouseEvent);
                    return;
                }
            }
        }
    }

    boolean postsOldMouseEvents() {
        return false;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void addNotify() {
        MenuContainer menuContainer;
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
            long l = 0L;
            if (this.mouseListener != null || (this.eventMask & 0x10L) != 0L) {
                l |= 0x10L;
            }
            if (this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L) {
                l |= 0x20L;
            }
            if (this.focusListener != null || (this.eventMask & 4L) != 0L) {
                l |= 4L;
            }
            if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                l |= 8L;
            }
            if (l != 0L) {
                this.parent.proxyEnableEvents(l);
            }
        }
        this.invalidate();
        int n = this.popups != null ? this.popups.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            menuContainer = (PopupMenu)this.popups.elementAt(n2);
            ((PopupMenu)menuContainer).addNotify();
            ++n2;
        }
        menuContainer = this.getParent();
        while (menuContainer != null) {
            if (menuContainer instanceof Window) {
                ((Window)menuContainer).getWarningString();
                return;
            }
            menuContainer = ((Component)menuContainer).getParent();
        }
    }

    public void removeNotify() {
        Object object;
        int n = this.popups != null ? this.popups.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            object = (PopupMenu)this.popups.elementAt(n2);
            ((Menu)object).removeNotify();
            ++n2;
        }
        if (this.peer != null) {
            object = this.peer;
            object.hide();
            this.peer = null;
            Toolkit.getEventQueue().removeSourceEvents(this);
            object.dispose();
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.isFocusTraversable();
        }
        return false;
    }

    public void requestFocus() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            if (componentPeer instanceof LightweightPeer) {
                this.parent.proxyRequestFocus(this);
                return;
            }
            componentPeer.requestFocus();
            Toolkit.getEventQueue().changeKeyEventFocus(this);
        }
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public void nextFocus() {
        Container container = this.parent;
        if (container != null) {
            container.transferFocus(this);
        }
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popupMenu);
        popupMenu.parent = this;
        if (this.peer != null && popupMenu.peer == null) {
            popupMenu.addNotify();
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n = this.popups.indexOf(menuComponent);
        if (n >= 0) {
            PopupMenu popupMenu = (PopupMenu)menuComponent;
            if (popupMenu.peer != null) {
                popupMenu.removeNotify();
            }
            popupMenu.parent = null;
            this.popups.removeElementAt(n);
            if (this.popups.size() == 0) {
                this.popups = null;
            }
        }
    }

    protected String paramString() {
        String string = String.valueOf(this.name != null ? this.name : "") + "," + this.x + "," + this.y + "," + this.width + "x" + this.height;
        if (!this.valid) {
            string = String.valueOf(string) + ",invalid";
        }
        if (!this.visible) {
            string = String.valueOf(string) + ",hidden";
        }
        if (!this.enabled) {
            string = String.valueOf(string) + ",disabled";
        }
        return string;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
        printStream.println(this);
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("  ");
            ++n2;
        }
        printWriter.println(this);
    }

    Container getNativeContainer() {
        Container container = this.parent;
        while (container != null && container.peer instanceof LightweightPeer) {
            container = container.getParent();
        }
        return container;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, componentListenerK, this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, focusListenerK, this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, keyListenerK, this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, mouseListenerK, this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, mouseMotionListenerK, this.mouseMotionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == componentListenerK) {
                this.addComponentListener((ComponentListener)objectInputStream.readObject());
                continue;
            }
            if (string == focusListenerK) {
                this.addFocusListener((FocusListener)objectInputStream.readObject());
                continue;
            }
            if (string == keyListenerK) {
                this.addKeyListener((KeyListener)objectInputStream.readObject());
                continue;
            }
            if (string == mouseListenerK) {
                this.addMouseListener((MouseListener)objectInputStream.readObject());
                continue;
            }
            if (string == mouseMotionListenerK) {
                this.addMouseMotionListener((MouseMotionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    static {
        String string = System.getProperty("awt.image.incrementaldraw");
        isInc = string == null || string.equals("true");
        string = System.getProperty("awt.image.redrawrate");
        incRate = string != null ? Integer.parseInt(string) : 100;
    }
}

