/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static Random randomNumberGenerator;
    private static long negativeZeroFloatBits;
    private static long negativeZeroDoubleBits;

    private Math() {
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double sqrt(double var0);

    public static native double IEEEremainder(double var0, double var2);

    public static native double ceil(double var0);

    public static native double floor(double var0);

    public static native double rint(double var0);

    public static native double atan2(double var0, double var2);

    public static native double pow(double var0, double var2);

    public static int round(float f) {
        return (int)Math.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)Math.floor(d + 0.5);
    }

    public static synchronized double random() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator.nextDouble();
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static float abs(float f) {
        if (f < 0.0f) {
            return -f;
        }
        return f;
    }

    public static double abs(double d) {
        if (d < 0.0) {
            return -d;
        }
        return d;
    }

    public static int max(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    public static long max(long l, long l2) {
        if (l >= l2) {
            return l;
        }
        return l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f) == negativeZeroFloatBits) {
            return f2;
        }
        if (f >= f2) {
            return f;
        }
        return f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d) == negativeZeroDoubleBits) {
            return d2;
        }
        if (d >= d2) {
            return d;
        }
        return d2;
    }

    public static int min(int n, int n2) {
        if (n <= n2) {
            return n;
        }
        return n2;
    }

    public static long min(long l, long l2) {
        if (l <= l2) {
            return l;
        }
        return l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f2;
        }
        if (f <= f2) {
            return f;
        }
        return f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d2;
        }
        if (d <= d2) {
            return d;
        }
        return d2;
    }

    static {
        negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
        negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    }
}

