/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public final class System {
    public static final InputStream in = System.nullInputStream();
    public static final PrintStream out = System.nullPrintStream();
    public static final PrintStream err = System.nullPrintStream();
    private static SecurityManager security = null;
    private static Properties props;

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        if (security != null) {
            security.checkExec("setio");
        }
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        if (security != null) {
            security.checkExec("setio");
        }
        System.setOut0(printStream);
    }

    public static void setErr(PrintStream printStream) {
        if (security != null) {
            security.checkExec("setio");
        }
        System.setErr0(printStream);
    }

    private static void checkIO() {
        if (security != null) {
            security.checkExec("setio");
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != null) {
            throw new SecurityException("SecurityManager already set");
        }
        security = securityManager;
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return props;
    }

    public static void setProperties(Properties properties) {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        props = properties;
    }

    public static String getProperty(String string) {
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    public static String getenv(String string) {
        throw new Error("getenv no longer supported, use properties and -D instead: " + string);
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        Runtime.getRuntime().load(string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string);
    }

    private static InputStream nullInputStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static PrintStream nullPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static void initializeSystemClass() {
        props = System.initProperties(new Properties());
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fileInputStream));
        System.setOut0(new PrintStream(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fileOutputStream2, 128), true));
    }
}

