/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;

public class DecimalFormat
extends NumberFormat {
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    private static final char patternZeroDigit = '0';
    private static final char patternGroupingSeparator = ',';
    private static final char patternDecimalSeparator = '.';
    private static final char patternPerMill = '\u2030';
    private static final char patternPercent = '%';
    private static final char patternDigit = '#';
    private static final char patternSeparator = ';';

    public DecimalFormat() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", Locale.getDefault());
        String[] stringArray = (String[])resourceBundle.getObject("NumberPatterns");
        this.applyPattern(stringArray[0], false);
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
    }

    public DecimalFormat(String string) {
        this.applyPattern(string, false);
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.applyPattern(string, false);
        this.symbols = decimalFormatSymbols;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        if (d != d) {
            stringBuffer.append(this.symbols.getNaN());
        } else {
            boolean bl;
            boolean bl2 = bl = d < 0.0;
            if (!bl) {
                stringBuffer.append(this.positivePrefix);
            } else {
                stringBuffer.append(this.negativePrefix);
                d = -d;
            }
            if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                stringBuffer.append(this.symbols.getInfinity());
            } else {
                if (this.multiplier != 1) {
                    d *= (double)this.multiplier;
                }
                this.digitList.set(d, this.getMaximumFractionDigits());
                this.appendNativeDigits(stringBuffer, fieldPosition);
            }
            if (!bl) {
                stringBuffer.append(this.positiveSuffix);
            } else {
                stringBuffer.append(this.negativeSuffix);
            }
        }
        return stringBuffer;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        double d = l;
        if (d != d || false) {
            stringBuffer.append(this.symbols.getNaN());
        } else {
            boolean bl;
            boolean bl2 = bl = l < 0L;
            if (!bl) {
                stringBuffer.append(this.positivePrefix);
            } else {
                stringBuffer.append(this.negativePrefix);
                l = -l;
            }
            double d2 = l;
            if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || false) {
                stringBuffer.append(this.symbols.getInfinity());
            } else {
                if (this.multiplier != 1) {
                    l *= (long)this.multiplier;
                }
                this.digitList.set(l);
                this.appendNativeDigits(stringBuffer, fieldPosition);
            }
            if (!bl) {
                stringBuffer.append(this.positiveSuffix);
            } else {
                stringBuffer.append(this.negativeSuffix);
            }
        }
        return stringBuffer;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.index;
        if (string.regionMatches(n, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index = n + this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean bl = string.regionMatches(n, this.positivePrefix, 0, this.positivePrefix.length());
        boolean bl2 = string.regionMatches(n, this.negativePrefix, 0, this.negativePrefix.length());
        if (bl && bl2) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                bl2 = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                bl = false;
            }
        }
        if (bl) {
            n += this.positivePrefix.length();
        } else if (bl2) {
            n += this.negativePrefix.length();
        } else {
            return null;
        }
        double d = Double.NaN;
        long l = Long.MIN_VALUE;
        boolean bl3 = true;
        if (string.regionMatches(n, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            this.digitList.decimalAt = n += this.symbols.getInfinity().length();
            d = Double.POSITIVE_INFINITY;
        } else {
            this.digitList.count = 0;
            this.digitList.decimalAt = -1;
            int n2 = -1;
            int n3 = -1;
            while (n < string.length()) {
                int n4;
                DigitList digitList;
                char c = string.charAt(n);
                if (this.symbols.getZeroDigit() < c && c <= (char)(this.symbols.getZeroDigit() + 9)) {
                    n2 = -1;
                    this.digitList.decimalAt = n3;
                    digitList = this.digitList;
                    n4 = c - this.symbols.getZeroDigit() + 48;
                    if (digitList.count < 19) {
                        digitList.digits[digitList.count] = (byte)n4;
                    }
                    ++digitList.count;
                } else if (c == this.symbols.getZeroDigit()) {
                    if (this.digitList.count != 0) {
                        n2 = -1;
                        this.digitList.decimalAt = n3;
                        if (this.digitList.count != 0 || n3 != -1) {
                            digitList = this.digitList;
                            n4 = c - this.symbols.getZeroDigit() + 48;
                            if (digitList.count < 19) {
                                digitList.digits[digitList.count] = (byte)n4;
                            }
                            ++digitList.count;
                        }
                    }
                } else {
                    if (this.digitList.decimalAt >= 0) break;
                    if (c == this.symbols.getDecimalSeparator() && !this.isParseIntegerOnly()) {
                        n2 = n;
                        n3 = this.digitList.count;
                    } else {
                        if (c != this.symbols.getGroupingSeparator() || !this.isGroupingUsed()) break;
                        n2 = n;
                    }
                }
                ++n;
            }
            if (n2 != -1) {
                n = n2;
            }
            if (this.digitList.decimalAt == -1) {
                this.digitList.decimalAt = this.digitList.count;
            }
            if (this.digitList.decimalAt == this.digitList.count && this.digitList.count <= 19) {
                bl3 = false;
                if (this.digitList.count == 19 && bl2 && this.isLongMIN_VALUE(this.digitList)) {
                    l = Long.MIN_VALUE;
                } else {
                    if (this.digitList.count == 0) {
                        return null;
                    }
                    l = this.digitList.getLong();
                }
            } else {
                if (this.digitList.count == 0) {
                    return null;
                }
                d = this.digitList.getDouble();
            }
        }
        if (bl) {
            bl = string.regionMatches(n, this.positiveSuffix, 0, this.positiveSuffix.length());
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.negativeSuffix, 0, this.negativeSuffix.length());
        }
        if (!bl && !bl2) {
            return null;
        }
        if (bl && bl2) {
            if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                bl2 = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                bl = false;
            } else {
                return null;
            }
        }
        if (bl == bl2) {
            return null;
        }
        if (this.multiplier != 1) {
            if (bl3) {
                d /= (double)this.multiplier;
            } else {
                d = (double)l / (double)this.multiplier;
                bl3 = true;
            }
        }
        if (bl) {
            parsePosition.index = n + this.positiveSuffix.length();
        } else {
            parsePosition.index = n + this.negativeSuffix.length();
            d = -d;
            l = -l;
        }
        if (bl3) {
            return new Double(d);
        }
        if (this.digitList.decimalAt == this.digitList.count && (l >= Long.MIN_VALUE || l <= Long.MAX_VALUE)) {
            return new Long(l);
        }
        return new Double(l);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return this.positivePrefix.equals(decimalFormat.positivePrefix) && this.positiveSuffix.equals(decimalFormat.positiveSuffix) && this.negativePrefix.equals(decimalFormat.negativePrefix) && this.negativeSuffix.equals(decimalFormat.negativeSuffix) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private String toPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n >= 0) {
            if (n == 1) {
                stringBuffer.append(this.positivePrefix);
            } else {
                stringBuffer.append(this.negativePrefix);
            }
            int n2 = this.groupingSize;
            int n3 = this.getMinimumIntegerDigits();
            n3 = n2 = (n2 >= n3 ? n2 : n3) + 1;
            while (n3 > 0) {
                if (n3 == this.groupingSize) {
                    stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                }
                if (n3 <= this.getMinimumIntegerDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                } else {
                    stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
                }
                --n3;
            }
            if (this.getMaximumFractionDigits() > 0) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            n3 = 0;
            while (n3 < this.getMaximumFractionDigits()) {
                if (n3 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                } else {
                    stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
                }
                ++n3;
            }
            if (n == 1) {
                stringBuffer.append(this.positiveSuffix);
                if (this.negativeSuffix.equals(this.positiveSuffix) && this.negativePrefix.equals(String.valueOf(this.symbols.getMinusSign()) + this.positivePrefix)) break;
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
            } else {
                stringBuffer.append(this.negativeSuffix);
            }
            --n;
        }
        return new String(stringBuffer);
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 1;
        while (n2 >= 0 && n < string.length()) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 1;
            boolean bl4 = false;
            boolean bl5 = false;
            int n8 = 0;
            char c = '0';
            char c2 = ',';
            char c3 = '.';
            char c4 = '%';
            char c5 = '\u2030';
            char c6 = '#';
            char c7 = ';';
            if (bl) {
                c = this.symbols.getZeroDigit();
                c2 = this.symbols.getGroupingSeparator();
                c3 = this.symbols.getDecimalSeparator();
                c4 = this.symbols.getPercent();
                c5 = this.symbols.getPerMill();
                c6 = this.symbols.getDigit();
                c7 = this.symbols.getPatternSeparator();
            }
            while (n < string.length()) {
                char c8 = string.charAt(n);
                if (bl2) {
                    if (c8 == '\'') {
                        bl2 = false;
                    } else if (n3 <= 0) {
                        stringBuffer.append(c8);
                    } else {
                        stringBuffer2.append(c8);
                    }
                } else if (c8 == '\'') {
                    bl2 = true;
                } else {
                    if (c8 == c7) {
                        ++n;
                        break;
                    }
                    if (!bl5) {
                        if (c8 == c6) {
                            n3 = (byte)(n3 + 1);
                            if (n4 > 0) {
                                throw new IllegalArgumentException();
                            }
                            if (bl4) {
                                n8 = (byte)(n8 + 1);
                            }
                        } else if (c8 == c) {
                            n4 = (byte)(n4 + 1);
                            n3 = (byte)(n3 + 1);
                            if (bl4) {
                                n8 = (byte)(n8 + 1);
                            }
                        } else if (c8 == c2) {
                            bl4 = true;
                            n8 = 0;
                        } else if (c8 == c3) {
                            if (bl5) {
                                throw new IllegalArgumentException();
                            }
                            bl5 = true;
                        } else if (n3 > 0) {
                            if (bl5) {
                                throw new IllegalArgumentException();
                            }
                            bl5 = true;
                            if (c8 == c4) {
                                stringBuffer2.append(this.symbols.getPercent());
                                n7 = 100;
                            } else if (c8 == c5) {
                                stringBuffer2.append(this.symbols.getPerMill());
                                n7 = 1000;
                            } else {
                                stringBuffer2.append(c8);
                            }
                        } else {
                            stringBuffer.append(c8);
                        }
                    } else if (c8 == c6) {
                        n5 = (byte)(n5 + 1);
                    } else if (c8 == c) {
                        n6 = (byte)(n6 + 1);
                        n5 = (byte)(n5 + 1);
                    } else if (c8 == c4) {
                        stringBuffer2.append(this.symbols.getPercent());
                        n7 = 100;
                    } else if (c8 == c5) {
                        stringBuffer2.append(this.symbols.getPerMill());
                        n7 = 1000;
                    } else {
                        stringBuffer2.append(c8);
                    }
                }
                ++n;
            }
            if (n2 == 1) {
                this.positivePrefix = new String(stringBuffer);
                this.positiveSuffix = new String(stringBuffer2);
                this.negativePrefix = this.positivePrefix;
                this.negativeSuffix = this.positiveSuffix;
                this.setMaximumIntegerDigits(127);
                this.setMinimumIntegerDigits(n4);
                this.setMaximumFractionDigits(n5);
                this.setMinimumFractionDigits(n6);
                this.setGroupingUsed(bl4);
                bl5 = false;
                this.setDecimalSeparatorAlwaysShown(bl5);
                this.groupingSize = (byte)n8;
                this.multiplier = n7;
            } else {
                this.negativePrefix = new String(stringBuffer);
                this.negativeSuffix = new String(stringBuffer2);
                bl3 = true;
            }
            --n2;
        }
        if (!bl3 || this.negativePrefix.equals(this.positivePrefix) && this.negativeSuffix.equals(this.positiveSuffix)) {
            this.negativeSuffix = this.positiveSuffix;
            this.negativePrefix = String.valueOf(this.symbols.getMinusSign()) + this.negativePrefix;
        }
    }

    private void appendNativeDigits(StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = this.digitList.decimalAt;
        if (fieldPosition.field == 0) {
            fieldPosition.beginIndex = stringBuffer.length();
        }
        int n2 = 0;
        int n3 = this.getMinimumIntegerDigits();
        int n4 = n - n2;
        int n5 = this.getMaximumIntegerDigits();
        n4 = n4 <= n5 ? n4 : n5;
        n4 = n3 = n3 >= n4 ? n3 : n4;
        while (n4 > 0) {
            if (n4 > n - n2 || n - n4 >= this.digitList.count) {
                stringBuffer.append(this.symbols.getZeroDigit());
            } else {
                stringBuffer.append((char)(this.digitList.digits[n - n4] - 48 + this.symbols.getZeroDigit()));
            }
            if (this.isGroupingUsed() && (n4 - 1) % this.groupingSize == 0 && n4 != 1) {
                stringBuffer.append(this.symbols.getGroupingSeparator());
            }
            --n4;
        }
        if (fieldPosition.field == 0) {
            fieldPosition.endIndex = stringBuffer.length();
        }
        n2 = n;
        n = this.digitList.count;
        n5 = this.getMinimumFractionDigits();
        int n6 = n - n2;
        int n7 = this.getMaximumFractionDigits();
        n6 = n6 <= n7 ? n6 : n7;
        int n8 = n3 = n5 >= n6 ? n5 : n6;
        if (this.decimalSeparatorAlwaysShown || n3 > 0) {
            stringBuffer.append(this.symbols.getDecimalSeparator());
            if (fieldPosition.field == 1) {
                fieldPosition.beginIndex = stringBuffer.length();
            }
            n5 = 0;
            while (n5 < n3) {
                if (n5 >= n - n2) {
                    stringBuffer.append(this.symbols.getZeroDigit());
                } else {
                    stringBuffer.append((char)(this.digitList.digits[n2 + n5] - 48 + this.symbols.getZeroDigit()));
                }
                ++n5;
            }
            if (fieldPosition.field == 1) {
                fieldPosition.endIndex = stringBuffer.length();
            }
        }
    }

    private boolean isSpecialChar(char c) {
        return c == '0' || c == ',' || c == '.' || c == '%' || c == '\u2030' || c == '#' || c == ';';
    }

    private boolean isLongMIN_VALUE(DigitList digitList) {
        StringBuffer stringBuffer = new StringBuffer(digitList.count + 1);
        stringBuffer.append('-');
        int n = 0;
        while (n < digitList.count) {
            stringBuffer.append((char)digitList.digits[n]);
            ++n;
        }
        return new String(stringBuffer).regionMatches(false, 0, Long.toString(Long.MIN_VALUE, 10), 0, digitList.count + 1);
    }
}

