/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.io.CharToByteConverter;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected Properties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry = new Hashtable(5);
    protected String aliasName;
    protected String styleString;
    private static Properties fprops;

    public PlatformFont(String string, int n) {
        int n2;
        if (fprops == null) {
            this.props = null;
            return;
        }
        this.props = fprops;
        this.aliasName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.aliasName == null) {
            this.aliasName = string.toLowerCase();
        }
        if (this.props.getProperty(String.valueOf(this.aliasName) + ".0") == null && this.props.getProperty(String.valueOf(this.aliasName) + ".plain.0") == null) {
            this.aliasName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector vector = new Vector(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(String.valueOf(this.aliasName) + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(String.valueOf(this.aliasName) + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.aliasName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.aliasName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(n6 * 10, n6 * 10 + 4);
                        string6 = string5.substring(n6 * 10 + 5, n6 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[n6] = n7 << 16 | n8;
                    ++n6;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        int n9 = 0;
        while (n9 < n3) {
            this.componentFonts[n9] = (FontDescriptor)vector.elementAt(n9);
            ++n9;
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        int n10 = 0;
        while (n10 < this.componentFonts.length) {
            if (!this.componentFonts[n10].isExcluded((char)n2) && this.componentFonts[n10].fontCharset.canConvert((char)n2)) {
                this.defaultFont = this.componentFonts[n10];
                this.defaultChar = (char)n2;
                return;
            }
            ++n10;
        }
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        int n;
        Object object;
        Vector vector = new Vector(3, 1);
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = this.defaultChar;
        Object object2 = this.defaultFont;
        if (stringBuffer.length() < 1) {
            return new CharsetString[0];
        }
        int n2 = 0;
        while (n2 < this.componentFonts.length) {
            if (!this.componentFonts[n2].isExcluded(string.charAt(0)) && this.componentFonts[n2].fontCharset.canConvert(string.charAt(0))) {
                object2 = this.componentFonts[n2];
                c = string.charAt(0);
                break;
            }
            ++n2;
        }
        stringBuffer.setCharAt(0, c);
        int n3 = 0;
        int n4 = 1;
        while (n4 < string.length()) {
            char c2 = string.charAt(n4);
            object = this.defaultFont;
            c = this.defaultChar;
            n = 0;
            while (n < this.componentFonts.length) {
                if (!this.componentFonts[n].isExcluded(c2) && this.componentFonts[n].fontCharset.canConvert(c2)) {
                    object = this.componentFonts[n];
                    c = c2;
                    break;
                }
                ++n;
            }
            stringBuffer.setCharAt(n4, c);
            if (object2 != object) {
                String string2 = stringBuffer.toString().substring(n3, n4);
                vector.addElement(new CharsetString(string2, (FontDescriptor)object2));
                object2 = object;
                object = this.defaultFont;
                n3 = n4;
            }
            ++n4;
        }
        String string3 = stringBuffer.toString().substring(n3, string.length());
        vector.addElement(new CharsetString(string3, (FontDescriptor)object2));
        object = new CharsetString[vector.size()];
        n = 0;
        while (n < vector.size()) {
            object[n] = (CharsetString)vector.elementAt(n);
            ++n;
        }
        return object;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    static {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("user.home");
        if (string == null) {
            throw new Error("java.home property not set");
        }
        String string3 = System.getProperty("user.language", "en");
        String string4 = System.getProperty("user.region");
        try {
            File file = null;
            if (string4 != null) {
                file = new File(String.valueOf(string) + File.separator + "lib" + File.separator + "font.properties." + string3 + "_" + string4);
            }
            if (!(file != null && file.canRead() || (file = new File(String.valueOf(string) + File.separator + "lib" + File.separator + "font.properties." + string3)).canRead() || (file = new File(String.valueOf(string) + File.separator + "lib" + File.separator + "font.properties")).canRead())) {
                if (string4 != null) {
                    file = new File(String.valueOf(string2) + File.separator + "lib" + File.separator + "font.properties." + string3 + "_" + string4);
                }
                if (!(file.canRead() || (file = new File(String.valueOf(string2) + File.separator + "font.properties." + string3)).canRead() || (file = new File(String.valueOf(string2) + File.separator + "font.properties")).canRead())) {
                    throw new Exception();
                }
            }
            Properties properties = new Properties();
            properties.put("serif.0", "unknown");
            properties.put("sansserif.0", "unknown");
            properties.put("monospaced.0", "unknown");
            properties.put("dialog.0", "unknown");
            properties.put("dialoginput.0", "unknown");
            fprops = new Properties(properties);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
            fprops.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {}
    }
}

