/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.image.GifImageDecoder;
import sun.awt.image.ImageConsumerQueue;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetchable;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.JPEGImageDecoder;
import sun.awt.image.PixelStore;
import sun.awt.image.XbmImageDecoder;

public abstract class InputStreamImageSource
implements ImageProducer,
ImageFetchable {
    PixelStore pixelstore;
    ImageConsumerQueue consumers;
    ImageDecoder decoder;
    ImageDecoder decoders;
    boolean awaitingFetch = false;

    abstract boolean checkSecurity(Object var1, boolean var2);

    int countConsumers(ImageConsumerQueue imageConsumerQueue) {
        int n = 0;
        while (imageConsumerQueue != null) {
            ++n;
            imageConsumerQueue = imageConsumerQueue.next;
        }
        return n;
    }

    synchronized int countConsumers() {
        ImageDecoder imageDecoder = this.decoders;
        int n = this.countConsumers(this.consumers);
        while (imageDecoder != null) {
            n += this.countConsumers(imageDecoder.queue);
            imageDecoder = imageDecoder.next;
        }
        return n;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, false);
    }

    synchronized void printQueue(ImageConsumerQueue imageConsumerQueue, String string) {
        while (imageConsumerQueue != null) {
            System.out.println(String.valueOf(string) + imageConsumerQueue);
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    synchronized void printQueues(String string) {
        System.out.println(String.valueOf(string) + "[ -----------");
        this.printQueue(this.consumers, "  ");
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            System.out.println("    " + imageDecoder);
            this.printQueue(imageDecoder.queue, "      ");
            imageDecoder = imageDecoder.next;
        }
        System.out.println("----------- ]" + string);
    }

    synchronized void addConsumer(ImageConsumer imageConsumer, boolean bl) {
        this.checkSecurity(null, false);
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                return;
            }
            imageDecoder = imageDecoder.next;
        }
        ImageConsumerQueue imageConsumerQueue = this.consumers;
        while (imageConsumerQueue != null && imageConsumerQueue.consumer != imageConsumer) {
            imageConsumerQueue = imageConsumerQueue.next;
        }
        if (imageConsumerQueue == null) {
            imageConsumerQueue = new ImageConsumerQueue(this, imageConsumer);
            imageConsumerQueue.next = this.consumers;
            this.consumers = imageConsumerQueue;
        } else {
            if (!imageConsumerQueue.secure) {
                Object object = null;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    object = securityManager.getSecurityContext();
                }
                if (imageConsumerQueue.securityContext == null) {
                    imageConsumerQueue.securityContext = object;
                } else if (imageConsumerQueue.securityContext != object) {
                    this.errorConsumer(imageConsumerQueue);
                    throw new SecurityException("Applets are trading image data!");
                }
            }
            imageConsumerQueue.interested = true;
        }
        if (bl && this.decoder == null) {
            this.startProduction();
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                return true;
            }
            imageDecoder = imageDecoder.next;
        }
        return ImageConsumerQueue.isConsumer(this.consumers, imageConsumer);
    }

    private void errorAllConsumers(ImageConsumerQueue imageConsumerQueue) {
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested) {
                this.errorConsumer(imageConsumerQueue);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    private void errorConsumer(ImageConsumerQueue imageConsumerQueue) {
        imageConsumerQueue.consumer.imageComplete(1);
        this.removeConsumer(imageConsumerQueue.consumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            imageDecoder.removeConsumer(imageConsumer);
            imageDecoder = imageDecoder.next;
        }
        this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumer, false);
        if (this.consumers == null) {
            this.stopProduction();
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, true);
    }

    private synchronized void startProduction() {
        if (!this.awaitingFetch) {
            ImageFetcher.add(this);
            this.awaitingFetch = true;
        }
    }

    private synchronized void stopProduction() {
        if (this.awaitingFetch) {
            ImageFetcher.remove(this);
            this.awaitingFetch = false;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                imageDecoder.replayConsumer(imageConsumer);
            }
            imageDecoder = imageDecoder.next;
        }
    }

    protected abstract ImageDecoder getDecoder();

    protected ImageDecoder decoderForType(InputStream inputStream, String string) {
        return null;
    }

    protected ImageDecoder getDecoder(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(6);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            inputStream.read();
            inputStream.read();
            inputStream.reset();
            inputStream.mark(-1);
            if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
                return new GifImageDecoder(this, inputStream);
            }
            if (n == 255 && n2 == 216 && n3 == 255) {
                return new JPEGImageDecoder(this, inputStream);
            }
            if (n == 35 && n2 == 100 && n3 == 101 && n4 == 102) {
                return new XbmImageDecoder(this, inputStream);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public void doFetch() {
        this.updateFromStore();
        Object object = this;
        synchronized (object) {
            if (this.consumers == null) {
                this.awaitingFetch = false;
                Object var2_2 = null;
                return;
            }
        }
        object = this.getDecoder();
        if (object == null) {
            this.badDecoder();
            return;
        }
        this.setDecoder((ImageDecoder)object);
        try {
            try {
                ((ImageDecoder)object).produceImage();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ImageFormatException imageFormatException) {
                imageFormatException.printStackTrace();
            }
            Object var3_6 = null;
            this.removeDecoder((ImageDecoder)object);
            this.errorAllConsumers(((ImageDecoder)object).queue);
            return;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.removeDecoder((ImageDecoder)object);
            this.errorAllConsumers(((ImageDecoder)object).queue);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateFromStore() {
        ImageConsumerQueue imageConsumerQueue;
        PixelStore pixelStore;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            pixelStore = this.pixelstore;
            if (pixelStore == null) {
                return false;
            }
            imageConsumerQueue = this.consumers;
        }
        while (true) {
            boolean bl;
            block17: {
                if (imageConsumerQueue == null) {
                    return true;
                }
                inputStreamImageSource = this;
                synchronized (inputStreamImageSource) {
                    block16: {
                        if (!imageConsumerQueue.interested) {
                            imageConsumerQueue = imageConsumerQueue.next;
                            Object var5_6 = null;
                            break block16;
                        }
                        bl = this.checkSecurity(imageConsumerQueue.securityContext, true);
                        break block17;
                    }
                    continue;
                }
            }
            if (bl) {
                if (!pixelStore.replay(this, imageConsumerQueue.consumer)) {
                    return false;
                }
            } else {
                this.errorConsumer(imageConsumerQueue);
            }
            inputStreamImageSource = this;
            synchronized (inputStreamImageSource) {
                imageConsumerQueue = imageConsumerQueue.next;
            }
        }
    }

    private void badDecoder() {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        this.errorAllConsumers(imageConsumerQueue);
    }

    /*
     * Unable to fully structure code
     */
    private void setDecoder(ImageDecoder var1_1) {
        var3_2 = this;
        synchronized (var3_2) {
            var1_1.next = this.decoders;
            this.decoders = var1_1;
            this.decoder = var1_1;
            var1_1.queue = var2_3 = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl18
        }
        do {
            if (var2_3.interested && !this.checkSecurity(var2_3.securityContext, true)) {
                this.errorConsumer(var2_3);
            }
            var2_3 = var2_3.next;
lbl18:
            // 2 sources

        } while (var2_3 != null);
    }

    private synchronized void removeDecoder(ImageDecoder imageDecoder) {
        this.doneDecoding(imageDecoder);
        ImageDecoder imageDecoder2 = null;
        ImageDecoder imageDecoder3 = this.decoders;
        while (imageDecoder3 != null) {
            if (imageDecoder3 == imageDecoder) {
                if (imageDecoder2 == null) {
                    this.decoders = imageDecoder3.next;
                    return;
                }
                imageDecoder2.next = imageDecoder3.next;
                return;
            }
            imageDecoder2 = imageDecoder3;
            imageDecoder3 = imageDecoder3.next;
        }
    }

    synchronized void doneDecoding(ImageDecoder imageDecoder) {
        if (this.decoder == imageDecoder) {
            this.decoder = null;
            if (this.consumers != null) {
                this.startProduction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void latchConsumers(ImageDecoder imageDecoder) {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            if (imageDecoder != this.decoder) {
                return;
            }
            imageConsumerQueue = this.consumers;
        }
        while (true) {
            block19: {
                if (imageConsumerQueue == null) {
                    return;
                }
                inputStreamImageSource = this;
                synchronized (inputStreamImageSource) {
                    block18: {
                        if (!imageConsumerQueue.interested) {
                            imageConsumerQueue = imageConsumerQueue.next;
                            Object var4_4 = null;
                            break block18;
                        }
                        break block19;
                    }
                    continue;
                }
            }
            if (!imageDecoder.catchupConsumer(this, imageConsumerQueue.consumer)) {
                inputStreamImageSource = this;
                synchronized (inputStreamImageSource) {
                    this.doneDecoding(imageDecoder);
                    return;
                }
            }
            inputStreamImageSource = this;
            synchronized (inputStreamImageSource) {
                ImageConsumerQueue imageConsumerQueue2 = imageConsumerQueue.next;
                if (imageConsumerQueue.interested) {
                    this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumerQueue.consumer, true);
                    imageConsumerQueue.next = imageDecoder.queue;
                    imageDecoder.queue = imageConsumerQueue;
                }
                imageConsumerQueue = imageConsumerQueue2;
            }
        }
    }

    synchronized void flush() {
        this.pixelstore = null;
        this.decoder = null;
    }

    synchronized void setPixelStore(ImageDecoder imageDecoder, PixelStore pixelStore) {
        if (imageDecoder == this.decoder) {
            this.pixelstore = pixelStore;
        }
    }
}

