/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import sun.misc.BASE64Decoder;
import sun.net.www.MessageHeader;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.x509.X509Cert;
import sun.tools.jar.Manifest;
import sun.tools.jar.SignatureFile;

public class JarVerifierStream
extends ZipInputStream {
    static boolean debug;
    private ZipEntry currentEntry;
    private Vector scopes;
    private Hashtable nameToHash = new Hashtable();
    private MessageDigest md5;
    private MessageDigest sha;
    private Hashtable signatures = new Hashtable();
    private Hashtable verifiedSignatures = new Hashtable();
    private boolean parsingBlock = false;
    private boolean computingHashes = false;
    private ByteArrayOutputStream blockOut;
    private boolean parsingManifest = false;
    private Manifest manifest;
    private ByteArrayOutputStream manifestOut;

    public JarVerifierStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.scopes = new Vector();
        IdentityScope identityScope = IdentityScope.getSystemScope();
        if (identityScope != null) {
            this.addScope(identityScope);
        }
        try {
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            JarVerifierStream.debug("didn't find an implementation for SHA");
        }
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            JarVerifierStream.debug("didn't find an implementation for MD5");
            return;
        }
    }

    public synchronized ZipEntry getNextEntry() throws IOException {
        if (this.currentEntry != null) {
            this.computeHashes(this.currentEntry.getName());
        }
        this.computingHashes = false;
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        this.currentEntry = super.getNextEntry();
        if (this.currentEntry == null) {
            this.computeSignatures();
            return null;
        }
        String string = this.currentEntry.getName().toUpperCase();
        if (Manifest.isManifestName(string) && this.manifest == null) {
            this.parsingManifest = true;
            this.manifestOut = new ByteArrayOutputStream();
        }
        if (string.endsWith("DSA") || string.endsWith("RSA")) {
            this.parsingBlock = true;
            this.blockOut = new ByteArrayOutputStream();
        }
        return this.currentEntry;
    }

    private void processData() throws ZipException, IOException {
        if (this.parsingManifest) {
            this.manifest = new Manifest(this.manifestOut.toByteArray());
            this.parsingManifest = false;
        }
        if (this.parsingBlock) {
            PKCS7 pKCS7 = new PKCS7(this.blockOut.toByteArray());
            this.addBlock(pKCS7);
            this.parsingBlock = false;
        }
    }

    public synchronized void closeEntry() throws ZipException, IOException {
        super.closeEntry();
        this.processData();
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            if (this.parsingBlock) {
                this.blockOut.write(n);
            }
            if (this.parsingManifest) {
                this.manifestOut.write(n);
            }
            if (this.computingHashes) {
                this.sha.update((byte)n);
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            if (this.parsingBlock) {
                this.blockOut.write(byArray, n, n3);
            }
            if (this.parsingManifest) {
                this.manifestOut.write(byArray, n, n3);
            }
            if (this.computingHashes) {
                this.sha.update(byArray);
            }
        }
        return n3;
    }

    private void addBlock(PKCS7 pKCS7) throws IOException {
        byte[] byArray = pKCS7.getContentInfo().getData();
        SignatureFile signatureFile = new SignatureFile(byArray);
        this.signatures.put(signatureFile, pKCS7);
    }

    private void computeHashes(String string) {
        byte[] byArray = this.sha.digest();
        byte[] byArray2 = this.md5.digest();
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger, bigInteger2};
        this.nameToHash.put(string, bigIntegerArray);
        this.md5.reset();
        this.sha.reset();
    }

    private void computeSignatures() {
        JarVerifierStream.debug("computeSignatures::: invoke");
        Enumeration enumeration = this.signatures.keys();
        while (enumeration.hasMoreElements()) {
            SignatureFile signatureFile = (SignatureFile)enumeration.nextElement();
            PKCS7 pKCS7 = (PKCS7)this.signatures.get(signatureFile);
            this.processSignature(signatureFile, pKCS7);
        }
    }

    private void processSignature(SignatureFile signatureFile, PKCS7 pKCS7) {
        MessageDigest messageDigest;
        BASE64Decoder bASE64Decoder;
        SignerInfo[] signerInfoArray;
        try {
            signerInfoArray = pKCS7.verify();
            if (signerInfoArray == null) {
                return;
            }
            bASE64Decoder = new BASE64Decoder();
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (SignatureException signatureException) {
            JarVerifierStream.debug("signature exception", signatureException);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            JarVerifierStream.debug("algorithm not available", noSuchAlgorithmException);
            return;
        }
        Enumeration enumeration = signatureFile.entries();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            MessageHeader messageHeader;
            MessageHeader messageHeader2 = (MessageHeader)enumeration.nextElement();
            String string = messageHeader2.findValue("Name");
            if (string == null || (messageHeader = this.manifest.getEntry(string)) == null) continue;
            String string2 = messageHeader2.findValue("SHA-Digest");
            try {
                byArray = bASE64Decoder.decodeBuffer(string2);
            }
            catch (IOException iOException) {
                continue;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            messageHeader.print(printStream);
            byte[] byArray2 = messageDigest.digest(byteArrayOutputStream.toByteArray());
            if (!MessageDigest.isEqual(byArray2, byArray)) continue;
            this.addIdentities(string, signerInfoArray, pKCS7);
        }
    }

    private void addIdentities(String string, SignerInfo[] signerInfoArray, PKCS7 pKCS7) {
        Vector vector = (Vector)this.verifiedSignatures.get(string);
        if (vector == null) {
            vector = new Vector();
        }
        Vector vector2 = this.findIdentities(signerInfoArray, pKCS7);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        this.verifiedSignatures.put(string, vector);
    }

    public void addScope(IdentityScope identityScope) {
        this.scopes.addElement(identityScope);
    }

    public void removeScope(IdentityScope identityScope) {
        this.scopes.removeElement(identityScope);
    }

    private Vector findIdentities(SignerInfo[] signerInfoArray, PKCS7 pKCS7) {
        Vector vector = new Vector();
        Enumeration enumeration = this.scopes.elements();
        while (enumeration.hasMoreElements()) {
            IdentityScope identityScope = (IdentityScope)enumeration.nextElement();
            Identity[] identityArray = this.findIdentities0(signerInfoArray, pKCS7, identityScope);
            if (identityArray == null) continue;
            int n = 0;
            while (n < identityArray.length) {
                vector.addElement(identityArray[n]);
                ++n;
            }
        }
        return vector;
    }

    private Identity[] findIdentities0(SignerInfo[] signerInfoArray, PKCS7 pKCS7, IdentityScope identityScope) {
        Vector vector = new Vector();
        if (identityScope instanceof IdentityDatabase) {
            Object[] objectArray;
            IdentityDatabase identityDatabase = (IdentityDatabase)identityScope;
            int n = 0;
            while (n < signerInfoArray.length) {
                objectArray = signerInfoArray[n];
                X509Cert x509Cert = objectArray.getCertificate(pKCS7);
                PublicKey publicKey = x509Cert.getPublicKey();
                Identity identity = identityDatabase.getIdentity(publicKey);
                JarVerifierStream.debug("Identity:::" + identity);
                if (identity != null) {
                    vector.addElement(identity);
                } else {
                    try {
                        String string = x509Cert.getPrincipal().getName();
                        identity = new SystemIdentity(string, identityScope);
                        identity.setPublicKey(publicKey);
                        identity.addCertificate(x509Cert);
                        vector.addElement(identity);
                        identity.toString(true);
                    }
                    catch (KeyManagementException keyManagementException) {}
                }
                ++n;
            }
            if (vector.size() != 0) {
                objectArray = new Identity[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
        }
        return null;
    }

    public Hashtable getVerifiedSignatures() {
        return this.verifiedSignatures;
    }

    public Enumeration getBlocks() {
        return this.signatures.elements();
    }

    public Hashtable getNameToHash() {
        return this.nameToHash;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    static void debug(String string) {
        if (debug) {
            System.err.println("sun.tools.jar.JarVerifierStream:::" + string);
        }
    }

    static void debug(String string, Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
            JarVerifierStream.debug(string);
        }
    }

    public Hashtable getHashTable() {
        return this.nameToHash;
    }
}

