#! /bin/ksh
#
#     @(#)java_template.sh	1.1 97/03/06
#
#===================================================================
# THIS SCRIPT IS A TEMPLATE FOR THE JAVA RUNTIME
# IT DIFFERS FROM THE JDK WRAPPER SCRIPT IN THAT
# IT IGNORES THE ENVIRONEMT VARIABLES CLASSPATH
# JAVA_HOME AND THREADS_FLAG.  MODIFY THIS TO SUIT 
# YOUR NEEDS.
#===================================================================

PRG=`whence $0` >/dev/null 2>&1
JAVA_HOME=`dirname $PRG`/..

export JAVA_HOME

CLASSPATH="$JAVA_HOME/lib/rt.jar:$JAVA_HOME/lib/i18n.jar:$JAVA_HOME/lib/classes:."
export CLASSPATH

THREADS_TYPE=green_threads
if [[ $THREADS_FLAG = native ]] ;\
	then THREADS_TYPE=native_threads;\
fi
export THREADS_TYPE

export LD_LIBRARY_PATH
LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$JAVA_HOME/lib/`uname -m`/$THREADS_TYPE"

prog="$JAVA_HOME/bin/`uname -m`/$THREADS_TYPE/java"
if [ -n "$NS_JAVA" ]
then
    prog="${prog}_ns"
elif [ -n "$DYN_JAVA" ]
then
    prog="${prog}_dyn"
fi

eval exec $prog '"$@"'


