/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.motif.MComponentPeer;

class MScrollbarPeer
extends MComponentPeer
implements ScrollbarPeer {
    native void create(MComponentPeer var1);

    MScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    public native void setValues(int var1, int var2, int var3, int var4);

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(18, 50);
        }
        return new Dimension(50, 18);
    }

    public void lineUp(int n) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n);
        this.postEvent(new AdjustmentEvent(scrollbar, 601, 2, n));
    }

    public void lineDown(int n) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n);
        this.postEvent(new AdjustmentEvent(scrollbar, 601, 1, n));
    }

    public void pageUp(int n) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n);
        this.postEvent(new AdjustmentEvent(scrollbar, 601, 3, n));
    }

    public void pageDown(int n) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n);
        this.postEvent(new AdjustmentEvent(scrollbar, 601, 4, n));
    }

    public void dragAbsolute(int n) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n);
        this.postEvent(new AdjustmentEvent(scrollbar, 601, 5, n));
    }

    public void print(Graphics graphics) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        Dimension dimension = scrollbar.size();
        Color color = scrollbar.getBackground();
        boolean bl = scrollbar.getOrientation() == 0;
        this.drawScrollbar(graphics, color, bl ? dimension.height : dimension.width, bl ? dimension.width : dimension.height, scrollbar.getMinimum(), scrollbar.getMaximum(), scrollbar.getValue(), scrollbar.getVisible(), bl);
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

