/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Hashtable;
import sun.security.util.BigInt;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class DSA
extends Signature {
    private static boolean debug;
    private DSAParams params;
    private static Hashtable keyGenParams;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetY;
    private BigInteger presetX;
    private MessageDigest dataSHA;
    private byte[] kseed;
    int strength;
    private int[] k_t = new int[]{-271733879, -1732584194, 271733878, -1009589776, 1732584193};
    private static SecureRandom signingRandom;
    private static final int round1_kt = 1518500249;
    private static final int round2_kt = 1859775393;
    private static final int round3_kt = -1894007588;
    private static final int round4_kt = -899497514;
    static BigInteger p512;
    static BigInteger q512;
    static BigInteger g512;
    static BigInteger x512;
    static BigInteger y512;
    static String pString;
    static BigInteger testP;
    static String gString;
    static BigInteger testG;
    static BigInteger testQ;
    static BigInteger testX;
    static String yString;
    static BigInteger testY;

    public DSA() throws NoSuchAlgorithmException {
        super("SHAwithDSA");
        this.dataSHA = MessageDigest.getInstance("SHA");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.presetX = dSAPrivateKey.getX();
        this.initialize(dSAPrivateKey.getParams());
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.presetY = dSAPublicKey.getY();
        this.initialize(dSAPublicKey.getParams());
    }

    private void initialize(DSAParams dSAParams) {
        this.dataSHA.reset();
        this.setParams(dSAParams);
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.generateK(this.presetQ);
        BigInteger bigInteger2 = this.generateR(this.presetP, this.presetQ, this.presetG, bigInteger);
        BigInteger bigInteger3 = this.generateS(this.presetX, this.presetQ, bigInteger2, bigInteger);
        BigInt bigInt = new BigInt(bigInteger2.toByteArray());
        BigInt bigInt2 = new BigInt(bigInteger3.toByteArray());
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInt);
            derOutputStream.putInteger(bigInt2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.reset();
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        Object object2;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            object2 = new DerInputStream(byArray);
            object = ((DerInputStream)object2).getSequence(2);
            bigInteger = object[0].getInteger().toBigInteger();
            bigInteger2 = object[1].getInteger().toBigInteger();
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature");
        }
        object2 = this.generateW(this.presetP, this.presetQ, this.presetG, bigInteger2);
        object = this.generateV(this.presetY, this.presetP, this.presetQ, this.presetG, (BigInteger)object2, bigInteger);
        this.reset();
        return ((BigInteger)object).equals(bigInteger);
    }

    private void reset() {
        this.dataSHA.reset();
    }

    BigInteger generateR(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
        return bigInteger5.remainder(bigInteger2);
    }

    BigInteger generateS(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        byte[] byArray = this.dataSHA.digest();
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger2);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger3);
        bigInteger7 = bigInteger5.add(bigInteger7);
        bigInteger7 = bigInteger6.multiply(bigInteger7);
        return bigInteger7.remainder(bigInteger2);
    }

    BigInteger generateW(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger4.modInverse(bigInteger2);
    }

    BigInteger generateV(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        byte[] byArray = this.dataSHA.digest();
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        bigInteger7 = bigInteger7.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.remainder(bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger5).remainder(bigInteger3);
        BigInteger bigInteger10 = bigInteger4.modPow(bigInteger8, bigInteger2);
        BigInteger bigInteger11 = bigInteger.modPow(bigInteger9, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.remainder(bigInteger2);
        return bigInteger13.remainder(bigInteger3);
    }

    BigInteger generateK(BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        if (this.kseed != null) {
            bigInteger2 = new BigInteger(1, this.kseed);
            if (bigInteger2.signum() > 0 && bigInteger2.compareTo(bigInteger) < 0) {
                return bigInteger2;
            }
        } else {
            int[] nArray;
            SecureRandom secureRandom = this.getSigningRandom();
            do {
                nArray = new int[5];
                int n = 0;
                while (n < 5) {
                    nArray[n] = secureRandom.nextInt();
                    ++n;
                }
            } while ((bigInteger2 = this.generateK(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
            return bigInteger2;
        }
        return null;
    }

    private SecureRandom getSigningRandom() {
        if (signingRandom == null) {
            signingRandom = new SecureRandom();
        }
        return signingRandom;
    }

    BigInteger generateK(int[] nArray, BigInteger bigInteger) {
        int[] nArray2 = new int[]{1752852185, 105445779, -2038558177, 1306500571, 18896260};
        nArray = nArray2;
        int[] nArray3 = new int[]{-271733879, -1732584194, 271733878, -1009589776, 1732584193};
        int[] nArray4 = DSA.SHA_7(nArray, nArray3);
        byte[] byArray = new byte[nArray4.length * 4];
        int n = 0;
        while (n < nArray4.length) {
            int n2 = nArray4[n];
            int n3 = 0;
            while (n3 < 4) {
                byArray[n * 4 + n3] = (byte)(n2 >>> 24 - n3 * 8);
                ++n3;
            }
            ++n;
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
        return bigInteger2;
    }

    static int[] SHA_7(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[80];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        int n = 0;
        int n2 = 16;
        while (n2 <= 79) {
            n = nArray3[n2 - 3] ^ nArray3[n2 - 8] ^ nArray3[n2 - 14] ^ nArray3[n2 - 16];
            nArray3[n2] = n << 1 | n >>> 31;
            ++n2;
        }
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = nArray2[4];
        int n8 = 0;
        while (n8 < 20) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n6) + n7 + nArray3[n8] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n8;
        }
        int n9 = 20;
        while (n9 < 40) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n9] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n9;
        }
        int n10 = 40;
        while (n10 < 60) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n6 | n5 & n6) + n7 + nArray3[n10] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n10;
        }
        int n11 = 60;
        while (n11 < 80) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n11] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n11;
        }
        int[] nArray4 = new int[]{nArray2[0] + n3, nArray2[1] + n4, nArray2[2] + n5, nArray2[3] + n6, nArray2[4] + n7};
        return nArray4;
    }

    protected void engineSetParameter(String string, Object object) {
        if (string.equals("KSEED")) {
            if (object instanceof byte[]) {
                this.kseed = (byte[])object;
                return;
            }
            DSA.debug("unrecognized param: " + string);
            throw new InvalidParameterException("kseed not a byte array");
        }
        throw new InvalidParameterException("invalid parameter");
    }

    protected Object engineGetParameter(String string) {
        if (string.equals("kseed")) {
            return this.kseed;
        }
        return null;
    }

    private void setParams(DSAParams dSAParams) {
        this.params = dSAParams;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
    }

    protected void engineUpdate(byte by) {
        this.dataSHA.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.dataSHA.update(byArray, n, n2);
    }

    public String toString() {
        String string = "DSA Signature";
        if (this.presetP != null && this.presetQ != null && this.presetG != null) {
            string = String.valueOf(string) + "\n\tp: " + this.presetP.toString(16);
            string = String.valueOf(string) + "\n\tq: " + this.presetQ.toString(16);
            string = String.valueOf(string) + "\n\tg: " + this.presetG.toString(16);
        } else {
            string = String.valueOf(string) + "\n\t P, Q or G not initialized.";
        }
        if (this.presetY != null) {
            string = String.valueOf(string) + "\n\ty: " + this.presetY.toString(16);
        }
        if (this.presetY == null && this.presetX == null) {
            string = String.valueOf(string) + "\n\tUNINIIALIZED";
        }
        return string;
    }

    static void testDSA() throws Exception {
        PrintStream printStream = System.out;
        DSA dSA = new DSA();
        int[] nArray = new int[]{1752852185, 105445779, -2038558177, 1306500571, 18896260};
        BigInteger bigInteger = dSA.generateK(nArray, q512);
        printStream.println("k: " + bigInteger.toString(16));
        BigInteger bigInteger2 = dSA.generateR(p512, q512, g512, bigInteger);
        printStream.println("r: " + bigInteger2.toString(16));
        byte[] byArray = new byte[]{97, 98, 99};
        dSA.dataSHA.update(byArray);
        BigInteger bigInteger3 = dSA.generateS(x512, q512, bigInteger2, bigInteger);
        printStream.println("s: " + bigInteger3.toString(16));
        dSA.dataSHA.update(byArray);
        BigInteger bigInteger4 = dSA.generateW(p512, q512, g512, bigInteger3);
        printStream.println("w: " + bigInteger4.toString(16));
        BigInteger bigInteger5 = dSA.generateV(y512, p512, q512, g512, bigInteger4, bigInteger2);
        printStream.println("v: " + bigInteger5.toString(16));
        if (bigInteger5.equals(bigInteger2)) {
            printStream.println("signature verifies.");
            return;
        }
        printStream.println("signature does not verify.");
    }

    private static void debug(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    static {
        p512 = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
        q512 = new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16);
        g512 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
        x512 = new BigInteger("3406c2d71b04b5fc0db62afcad58a6607d3de688", 16);
        y512 = new BigInteger("2d335d76b8ec9d610aa8f2cbb4b149fd96fdd3a9a6e62bd6c2e01d406be4d1d72718a2fe08bea6d12f5e452474461f70f4dea60508e9fe2eaec23d2ec5d1a866", 16);
        pString = "8df2a494492276aa3d25759bb06869cbeac0d83afb8d0cf7cbb8324f0d7882e5d0762fc5b7210eafc2e9adac32ab7aac49693dfbf83724c2ec0736ee31c80291";
        testP = new BigInteger(pString, 16);
        gString = "626d027839ea0a13413163a55b4cb500299d5522956cefcb3bff10f399ce2c2e71cb9de5fa24babf58e5b79521925c9cc42e9f6f464b088cc572af53e6d78802";
        testG = new BigInteger(gString, 16);
        testQ = new BigInteger("c773218c737ec8ee993b4f2ded30f48edace915f", 16);
        testX = new BigInteger("2070b3223dba372fde1c0ffc7b2e3b498b260614", 16);
        yString = "19131871d75b1612a819f29d78d1b0d7346f7aa77bb62a859bfd6c5675da9d212d3a36ef1672ef660b8c7c255cc0ec74858fba33f44c06699630a76b030ee333";
        testY = new BigInteger(yString, 16);
    }
}

