/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.peer.ActiveEvent;

class EventDispatchThread
extends Thread {
    private EventQueue theQueue;
    private boolean doDispatch = true;

    EventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    public void stopDispatching() {
        this.doDispatch = false;
    }

    public void run() {
        while (this.doDispatch) {
            try {
                AWTEvent aWTEvent = this.theQueue.getNextEvent();
                Object object = aWTEvent.getSource();
                if (object instanceof Component) {
                    ((Component)object).dispatchEvent(aWTEvent);
                    continue;
                }
                if (object instanceof MenuComponent) {
                    ((MenuComponent)object).dispatchEvent(aWTEvent);
                    continue;
                }
                if (!(aWTEvent instanceof ActiveEvent)) continue;
                ((ActiveEvent)((Object)aWTEvent)).dispatch();
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
        }
    }
}

