/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        this.buf = new byte[n];
    }

    public synchronized void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            int n3 = this.buf.length << 1;
            byte[] byArray = new byte[n3 >= n2 ? n3 : n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            int n4 = this.buf.length << 1;
            byte[] byArray2 = new byte[n4 >= n3 ? n4 : n3];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public String toString(int n) {
        return new String(this.buf, n, 0, this.count);
    }
}

