/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.SystemClassLoader;
import java.util.Vector;

public abstract class ResourceBundle {
    private static SystemClassLoader systemClassLoader = new SystemClassLoader();
    private static boolean debugFlag;
    protected ResourceBundle parent;
    private static final Integer NOTFOUND;
    private static Hashtable cacheList;

    public final String getString(String string) throws MissingResourceException {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) throws MissingResourceException {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) throws MissingResourceException {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource", this.getClass().getName(), string);
            }
        }
        return object;
    }

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return ResourceBundle.getBundle(string, Locale.getDefault(), ResourceBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundle(string, locale, ResourceBundle.getLoader());
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader;
        Class[] classArray = ResourceBundle.getClassContext();
        Class clazz = classArray[2];
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            return systemClassLoader;
        }
        return classLoader;
    }

    private static native Class[] getClassContext();

    private static synchronized ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        StringBuffer stringBuffer = new StringBuffer("_").append(locale.toString());
        ResourceBundle resourceBundle = ResourceBundle.findBundle(string, stringBuffer, classLoader, false);
        if (resourceBundle == null) {
            stringBuffer.setLength(0);
            stringBuffer.append("_").append(Locale.getDefault().toString());
            resourceBundle = ResourceBundle.findBundle(string, stringBuffer, classLoader, true);
            if (resourceBundle == null) {
                throw new MissingResourceException("can't find resource for " + string + "_" + locale, String.valueOf(string) + "_" + locale, "");
            }
        }
        ResourceBundle resourceBundle2 = resourceBundle;
        while (resourceBundle2 != null && resourceBundle2.parent == null) {
            int n = new String(stringBuffer).lastIndexOf(95);
            if (n != -1) {
                stringBuffer.setLength(n);
                String string2 = "Searching for parent " + string + stringBuffer;
                if (debugFlag) {
                    System.out.println("ResourceBundle: " + string2);
                }
                resourceBundle2.setParent(ResourceBundle.findBundle(string, stringBuffer, classLoader, true));
            }
            resourceBundle2 = resourceBundle2.parent;
        }
        return resourceBundle;
    }

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    private static ResourceBundle findBundle(String string, StringBuffer stringBuffer, ClassLoader classLoader, boolean bl) {
        String string2;
        String string3 = new String(stringBuffer);
        String string4 = string.replace('.', '/');
        Object object = null;
        Vector vector = new Vector();
        while (true) {
            String string5 = String.valueOf(string) + string3;
            int n = classLoader.hashCode();
            String string6 = "[" + Integer.toString(n, 10) + "]" + string5;
            object = cacheList.get(string6);
            if (object == NOTFOUND) {
                string2 = "Found " + string5 + " in cache as NOTFOUND";
                if (debugFlag) {
                    System.out.println("ResourceBundle: " + string2);
                }
                stringBuffer.setLength(0);
                break;
            }
            if (object != null) {
                string2 = "Found " + string5 + " in cache";
                if (debugFlag) {
                    System.out.println("ResourceBundle: " + string2);
                }
                stringBuffer.setLength(0);
                break;
            }
            vector.addElement(string6);
            string2 = "Searching for " + string5;
            if (debugFlag) {
                System.out.println("ResourceBundle: " + string2);
            }
            try {
                object = classLoader.loadClass(string5).newInstance();
            }
            catch (Exception exception) {
                int n2;
                InputStream inputStream;
                string5 = String.valueOf(string4) + string3 + ".properties";
                string2 = "Searching for " + string5;
                if (debugFlag) {
                    System.out.println("ResourceBundle: " + string2);
                }
                if ((inputStream = classLoader.getResourceAsStream(string5)) != null) {
                    inputStream = new BufferedInputStream(inputStream);
                    try {
                        object = new PropertyResourceBundle(inputStream);
                        break;
                    }
                    catch (Exception exception2) {}
                }
                if ((n2 = string3.lastIndexOf(95)) == 0 && !bl || n2 == -1) break;
                string3 = string3.substring(0, n2);
                stringBuffer.setLength(n2);
                continue;
            }
            break;
        }
        if (object != null) {
            int n = 0;
            while (n < vector.elementCount) {
                cacheList.put(vector.elementAt(n), object);
                string2 = "Adding " + vector.elementAt(n) + " to cache" + (object == NOTFOUND ? " as NOTFOUND." : ".");
                if (debugFlag) {
                    System.out.println("ResourceBundle: " + string2);
                }
                ++n;
            }
        } else if (bl) {
            int n = 0;
            while (n < vector.elementCount) {
                cacheList.put(vector.elementAt(n), NOTFOUND);
                string2 = "Adding " + vector.elementAt(n) + " to cache as NOTFOUND.";
                if (debugFlag) {
                    System.out.println("ResourceBundle: " + string2);
                }
                ++n;
            }
        }
        if (object == NOTFOUND || object == null) {
            return null;
        }
        return (ResourceBundle)object;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("ResourceBundle: " + string);
        }
    }

    static {
        NOTFOUND = new Integer(-1);
        cacheList = new Hashtable();
    }
}

