/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletSecurity;
import sun.applet.AppletViewer;
import sun.net.www.http.HttpClient;

class AppletProps
extends Frame {
    TextField proxyHost;
    TextField proxyPort;
    Choice networkMode;
    Choice accessMode;
    Choice unsignedMode;
    private static AppletMessageHandler amh = new AppletMessageHandler("appletprops");

    AppletProps() {
        this.setTitle(amh.getMessage("title"));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label(amh.getMessage("label.http.server", "Http proxy server:")));
        this.proxyHost = new TextField();
        panel.add(this.proxyHost);
        panel.add(new Label(amh.getMessage("label.http.proxy")));
        this.proxyPort = new TextField();
        panel.add(this.proxyPort);
        panel.add(new Label(amh.getMessage("label.network")));
        this.networkMode = new Choice();
        panel.add(this.networkMode);
        this.networkMode.addItem(amh.getMessage("choice.network.item.none"));
        this.networkMode.addItem(amh.getMessage("choice.network.item.applethost"));
        this.networkMode.addItem(amh.getMessage("choice.network.item.unrestricted"));
        panel.add(new Label(amh.getMessage("label.class")));
        this.accessMode = new Choice();
        panel.add(this.accessMode);
        this.accessMode.addItem(amh.getMessage("choice.class.item.restricted"));
        this.accessMode.addItem(amh.getMessage("choice.class.item.unrestricted"));
        panel.add(new Label(amh.getMessage("label.unsignedapplet")));
        this.unsignedMode = new Choice();
        panel.add(this.unsignedMode);
        this.unsignedMode.addItem(amh.getMessage("choice.unsignedapplet.no"));
        this.unsignedMode.addItem(amh.getMessage("choice.unsignedapplet.yes"));
        this.add("Center", panel);
        panel = new Panel();
        panel.add(new Button(amh.getMessage("button.apply")));
        panel.add(new Button(amh.getMessage("button.reset")));
        panel.add(new Button(amh.getMessage("button.cancel")));
        this.add("South", panel);
        this.move(200, 150);
        this.pack();
        this.reset();
    }

    void reset() {
        ((AppletSecurity)System.getSecurityManager()).reset();
        switch (((AppletSecurity)System.getSecurityManager()).networkMode) {
            case 3: {
                this.networkMode.select(amh.getMessage("choice.network.item.unrestricted"));
                break;
            }
            case 1: {
                this.networkMode.select(amh.getMessage("choice.network.item.none"));
                break;
            }
            default: {
                this.networkMode.select(amh.getMessage("choice.network.item.applethost"));
            }
        }
        if (Boolean.getBoolean("package.restrict.access.sun")) {
            this.accessMode.select(amh.getMessage("choice.class.item.restricted"));
        } else {
            this.accessMode.select(amh.getMessage("choice.class.item.unrestricted"));
        }
        if (System.getProperty("http.proxyHost") != null) {
            this.proxyHost.setText(System.getProperty("http.proxyHost"));
            this.proxyPort.setText(System.getProperty("http.proxyPort"));
            HttpClient.proxyPort = Integer.valueOf(System.getProperty("http.proxyPort"));
        } else {
            this.proxyHost.setText("");
            this.proxyPort.setText("");
        }
        if (Boolean.getBoolean("appletviewer.security.allowUnsigned")) {
            this.unsignedMode.select(amh.getMessage("choice.unsignedapplet.yes"));
            return;
        }
        this.unsignedMode.select(amh.getMessage("choice.unsignedapplet.no"));
    }

    void apply() {
        Properties properties = System.getProperties();
        properties.put("appletviewer.version", AppletViewer.theVersion);
        if (this.proxyHost.getText().length() > 0) {
            properties.put("http.proxyHost", this.proxyHost.getText().trim());
            properties.put("http.proxyPort", this.proxyPort.getText().trim());
        } else {
            properties.remove("http.proxyHost");
        }
        if ("None".equals(this.networkMode.getSelectedItem())) {
            properties.put("appletviewer.security.mode", "none");
        } else if ("Unrestricted".equals(this.networkMode.getSelectedItem())) {
            properties.put("appletviewer.security.mode", "unrestricted");
        } else {
            properties.put("appletviewer.security.mode", "host");
        }
        if ("Restricted".equals(this.accessMode.getSelectedItem())) {
            properties.put("package.restrict.access.sun", "true");
            properties.put("package.restrict.access.netscape", "true");
        } else {
            properties.put("package.restrict.access.sun", "false");
            properties.put("package.restrict.access.netscape", "false");
        }
        if ("Yes".equals(this.unsignedMode.getSelectedItem())) {
            properties.put("appletviewer.security.allowUnsigned", "true");
        } else {
            properties.put("appletviewer.security.allowUnsigned", "false");
        }
        try {
            this.reset();
            FileOutputStream fileOutputStream = new FileOutputStream(AppletViewer.theUserPropertiesFile);
            properties.save(fileOutputStream, "AppletViewer");
            fileOutputStream.close();
            this.hide();
            return;
        }
        catch (IOException iOException) {
            System.out.println(amh.getMessage("apply.exception", iOException));
            iOException.printStackTrace();
            this.reset();
            return;
        }
    }

    public boolean action(Event event, Object object) {
        if (amh.getMessage("button.apply").equals(object)) {
            this.apply();
            return true;
        }
        if (amh.getMessage("button.reset").equals(object)) {
            this.reset();
            return true;
        }
        if (amh.getMessage("button.cancel").equals(object)) {
            this.hide();
            return true;
        }
        return false;
    }
}

