/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2,
Serializable {
    Hashtable tab = new Hashtable();
    int hgap;
    int vgap;

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
            }
            this.addLayoutComponent((String)object, component);
            return;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (this.tab.size() > 0) {
                component.hide();
            }
            this.tab.put(string, component);
            return;
        }
    }

    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            Enumeration enumeration = this.tab.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.tab.get(string) != component) continue;
                this.tab.remove(string);
                Object var3_5 = null;
                return;
            }
            return;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                Dimension dimension = component.getPreferredSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height > n3) {
                    n3 = dimension.height;
                }
                ++n4;
            }
            Dimension dimension = new Dimension(insets.left + insets.right + n2 + this.hgap * 2, insets.top + insets.bottom + n3 + this.vgap * 2);
            Object var4_11 = null;
            return dimension;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                Dimension dimension = component.getMinimumSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height > n3) {
                    n3 = dimension.height;
                }
                ++n4;
            }
            Dimension dimension = new Dimension(insets.left + insets.right + n2 + this.hgap * 2, insets.top + insets.bottom + n3 + this.vgap * 2);
            Object var4_11 = null;
            return dimension;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.visible) {
                    component.setBounds(this.hgap + insets.left, this.vgap + insets.top, container.width - (this.hgap * 2 + insets.left + insets.right), container.height - (this.vgap * 2 + insets.top + insets.bottom));
                }
                ++n2;
            }
            return;
        }
    }

    void checkLayout(Container container) {
        if (container.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for CardLayout");
        }
    }

    public void first(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.visible) {
                    component.hide();
                    component = container.getComponent(0);
                    component.show();
                    container.validate();
                    Object var3_6 = null;
                    return;
                }
                ++n2;
            }
            return;
        }
    }

    public void next(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.visible) {
                    component.hide();
                    component = container.getComponent(n2 + 1 < n ? n2 + 1 : 0);
                    component.show();
                    container.validate();
                    Object var3_6 = null;
                    return;
                }
                ++n2;
            }
            return;
        }
    }

    public void previous(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.visible) {
                    component.hide();
                    component = container.getComponent(n2 > 0 ? n2 - 1 : n - 1);
                    component.show();
                    container.validate();
                    Object var3_6 = null;
                    return;
                }
                ++n2;
            }
            return;
        }
    }

    public void last(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.visible) {
                    component.hide();
                    component = container.getComponent(n - 1);
                    component.show();
                    container.validate();
                    Object var3_6 = null;
                    return;
                }
                ++n2;
            }
            return;
        }
    }

    public void show(Container container, String string) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            Component component = (Component)this.tab.get(string);
            if (component != null && !component.visible) {
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = container.getComponent(n2);
                    if (component2.visible) {
                        component2.hide();
                        break;
                    }
                    ++n2;
                }
                component.show();
                container.validate();
            }
            return;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }
}

