/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.BigInt;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509Cert;

public class PKCS7 {
    private boolean debug = false;
    private ObjectIdentifier contentType;
    private BigInt version;
    private AlgorithmId[] digestAlgorithmIds;
    private ContentInfo contentInfo;
    private X509Cert[] certificates;
    private SignerInfo[] signerInfos;

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(new DerInputStream(byArray));
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.parse(derInputStream);
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parse(derInputStream);
    }

    private void parse(DerInputStream derInputStream) throws ParsingException {
        try {
            ContentInfo contentInfo = new ContentInfo(derInputStream);
            this.contentType = contentInfo.contentType;
            if (this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
                this.parseSignedData(contentInfo.getContent());
                return;
            }
            throw new ParsingException("content type " + this.contentType + "not supported.");
        }
        catch (IOException iOException) {
            this.debug(iOException);
            throw new ParsingException("IOException.");
        }
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Cert[] x509CertArray, SignerInfo[] signerInfoArray) {
        this.version = new BigInt(1);
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertArray;
        this.signerInfos = signerInfoArray;
    }

    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                DerValue derValue2 = derValueArray2[n2];
                this.digestAlgorithmIds[n2] = AlgorithmId.parse(derValue2);
                ++n2;
            }
        }
        catch (IOException iOException) {
            this.debug(iOException);
            throw new ParsingException("error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(derInputStream);
        DerValue[] derValueArray3 = derInputStream.getSet(2);
        n = derValueArray3.length;
        this.certificates = new X509Cert[n];
        int n3 = 0;
        while (n3 < n) {
            this.certificates[n3] = derValueArray = new X509Cert(derValueArray3[n3]);
            ++n3;
        }
        derInputStream.getSet(0);
        derValueArray = derInputStream.getSet(1);
        n = derValueArray.length;
        this.signerInfos = new SignerInfo[n];
        int n4 = 0;
        while (n4 < n) {
            DerInputStream derInputStream2 = derValueArray[n4].toDerInputStream();
            this.signerInfos[n4] = new SignerInfo(derInputStream2);
            ++n4;
        }
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        int n = 0;
        while (n < this.digestAlgorithmIds.length) {
            this.digestAlgorithmIds[n].encode(derOutputStream3);
            ++n;
        }
        derOutputStream2.write((byte)49, derOutputStream3);
        this.contentInfo.encode(derOutputStream2);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        int n2 = 0;
        while (n2 < this.certificates.length) {
            this.certificates[n2].encode((OutputStream)derOutputStream4);
            ++n2;
        }
        derOutputStream2.write((byte)49, derOutputStream4);
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream2.write((byte)49, derOutputStream5);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        int n3 = 0;
        while (n3 < this.signerInfos.length) {
            this.signerInfos[n3].encode(derOutputStream6);
            ++n3;
        }
        derOutputStream2.write((byte)49, derOutputStream6);
        DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(ContentInfo.SIGNED_DATA_OID, derValue);
        contentInfo.encode(derOutputStream);
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Object object;
        Vector vector = new Vector();
        int n = 0;
        while (n < this.signerInfos.length) {
            object = this.verify(this.signerInfos[n], byArray);
            if (object != null) {
                vector.addElement(object);
            }
            ++n;
        }
        if (vector.size() != 0) {
            object = new SignerInfo[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInt getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Cert[] getCertificates() {
        return this.certificates;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Cert getCertificate(BigInt bigInt, X500Name x500Name) {
        int n = 0;
        while (n < this.certificates.length) {
            X509Cert x509Cert = this.certificates[n];
            X500Name x500Name2 = x509Cert.getSubjectName();
            BigInt bigInt2 = x509Cert.getSerialNumber();
            if (bigInt.equals(bigInt2) && x500Name.equals(x500Name2)) {
                return x509Cert;
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "PKCS7 :: version: " + this.version + "\n";
        string = String.valueOf(string) + "PKCS7 :: digest AlgorithmIds: \n";
        int n = 0;
        while (n < this.digestAlgorithmIds.length) {
            string = String.valueOf(string) + "\t" + this.digestAlgorithmIds[n] + "\n";
            ++n;
        }
        string = String.valueOf(string) + this.contentInfo + "\n";
        string = String.valueOf(string) + "PKCS7 :: certificates: \n";
        int n2 = 0;
        while (n2 < this.certificates.length) {
            string = String.valueOf(string) + "\t" + n2 + ".   " + this.certificates[n2] + "\n";
            ++n2;
        }
        string = String.valueOf(string) + "PKCS7 :: signer infos: \n";
        int n3 = 0;
        while (n3 < this.signerInfos.length) {
            string = String.valueOf(string) + "\t" + n3 + ".  " + this.signerInfos[n3] + "\n";
            ++n3;
        }
        return string;
    }

    private void debug(Throwable throwable) {
        if (this.debug) {
            throwable.printStackTrace();
        }
    }
}

