/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class ContentInfo {
    private static int[] pkcs7 = new int[]{1, 2, 840, 1113549, 1, 7};
    private static int[] data = new int[]{1, 2, 840, 1113549, 1, 7, 1};
    private static int[] sdata = new int[]{1, 2, 840, 1113549, 1, 7, 2};
    private static int[] edata = new int[]{1, 2, 840, 1113549, 1, 7, 3};
    private static int[] sedata = new int[]{1, 2, 840, 1113549, 1, 7, 4};
    private static int[] ddata = new int[]{1, 2, 840, 1113549, 1, 7, 5};
    private static int[] crdata = new int[]{1, 2, 840, 1113549, 1, 7, 6};
    public static final ObjectIdentifier PKCS7_OID = new ObjectIdentifier(pkcs7);
    public static final ObjectIdentifier DATA_OID = new ObjectIdentifier(data);
    public static final ObjectIdentifier SIGNED_DATA_OID = new ObjectIdentifier(sdata);
    public static final ObjectIdentifier ENVELOPED_DATA_OID = new ObjectIdentifier(edata);
    public static final ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID = new ObjectIdentifier(sedata);
    public static final ObjectIdentifier DIGESTED_DATA_OID = new ObjectIdentifier(ddata);
    public static final ObjectIdentifier ENCRYPTED_DATA_OID = new ObjectIdentifier(crdata);
    ObjectIdentifier contentType;
    DerValue content;

    public ContentInfo(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.contentType = objectIdentifier;
        this.content = derValue;
    }

    public ContentInfo(byte[] byArray) {
        DerValue derValue = new DerValue(4, byArray);
        this.contentType = DATA_OID;
        this.content = derValue;
    }

    public ContentInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerValue derValue = derValueArray[0];
        DerInputStream derInputStream2 = new DerInputStream(derValue.toByteArray());
        this.contentType = derInputStream2.getOID();
        this.content = derValueArray[1];
    }

    public DerValue getContent() {
        return this.content;
    }

    public byte[] getData() throws IOException {
        if (this.contentType.equals(DATA_OID)) {
            return this.content.getOctetString();
        }
        throw new IOException("content type is not DATA: " + this.contentType);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.contentType);
        this.content.emit(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getContentBytes() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.content.toByteArray());
        return derInputStream.getOctetString();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "Content Info Sequence\n\tContent type: " + this.contentType + "\n";
        string = String.valueOf(string) + "\tContent: " + this.content;
        return string;
    }
}

