/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.ValidationCallback;
import java.io.WriteAbortedException;
import java.util.Vector;
import sun.io.ObjectInputStreamDelegate;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private InputStream in;
    private int count;
    private boolean blockDataMode;
    private byte[] buffer;
    private DataInputStream dis;
    private IOException abortIOException;
    private ClassNotFoundException abortClassNotFoundException;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Class currentClass;
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private Vector wireHandle2Object;
    private int nextWireOffset;
    private Vector callbacks;
    private int recursionDepth;
    private byte currCode;
    boolean enableResolve;
    private boolean isTrustedSubclass = false;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        if (this instanceof ObjectInputStreamDelegate && this.getClass().getClassLoader() == null) {
            this.isTrustedSubclass = true;
            return;
        }
        this.in = inputStream;
        this.dis = new DataInputStream(this);
        this.readStreamHeader();
        this.resetStream();
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        if (this.isTrustedSubclass) {
            return ((ObjectInputStreamDelegate)((Object)this)).readObjectDelegate();
        }
        return this.readObject(true);
    }

    private final Object readObject(boolean bl) throws OptionalDataException, ClassNotFoundException, IOException {
        ClassNotFoundException classNotFoundException;
        if (this.blockDataMode) {
            if (this.count == 0) {
                this.refill();
            }
            if (this.count > 0) {
                throw new OptionalDataException(this.count);
            }
        }
        this.peekCode();
        Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        boolean bl2 = this.setBlockData(false);
        ++this.recursionDepth;
        Object object2 = null;
        byte by = this.readCode();
        try {
            block43: {
                try {
                    int n = -1;
                    switch (by) {
                        case 112: {
                            object2 = null;
                            break;
                        }
                        case 113: {
                            n = this.readInt() - 0x7E0000;
                            try {
                                object2 = this.wireHandle2Object.elementAt(n);
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw new StreamCorruptedException("Reference to object never serialized.");
                            }
                        }
                        case 116: {
                            Object object3 = object2 = this.readUTF();
                            n = this.assignWireOffset(object2);
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                            }
                            if (object2 != object3) {
                                this.wireHandle2Object.setElementAt(object2, n);
                            }
                            break;
                        }
                        case 118: {
                            ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject(bl);
                            if (objectStreamClass2 == null) {
                                throw new StreamCorruptedException("Class not in stream");
                            }
                            object2 = objectStreamClass2.forClass();
                            if (object2 == null && bl) {
                                throw new ClassNotFoundException(objectStreamClass2.getName());
                            }
                            this.assignWireOffset(object2);
                            break;
                        }
                        case 114: {
                            object2 = this.inputClassDescriptor();
                            break;
                        }
                        case 117: {
                            n = this.inputArray(bl);
                            object2 = this.currentObject;
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                            }
                            if (object2 != this.currentObject) {
                                this.wireHandle2Object.setElementAt(object2, n);
                            }
                            break;
                        }
                        case 115: {
                            n = this.inputObject(bl);
                            object2 = this.currentObject;
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                                this.wireHandle2Object.setElementAt(object2, n);
                            }
                            break;
                        }
                        case 120: {
                            if (!bl2) {
                                throw new StreamCorruptedException("Unexpected end of block data");
                            }
                            this.currCode = (byte)120;
                            this.count = -1;
                            throw new OptionalDataException(true);
                        }
                        case 119: 
                        case 122: {
                            if (by == 122) {
                                int n2;
                                int n3;
                                int n4;
                                int n5 = this.in.read();
                                if ((n5 | (n4 = this.in.read()) | (n3 = this.in.read()) | (n2 = this.in.read())) < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                                this.count = n5 << 24 | n4 << 16 | n3 << 8 | n2;
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("Negative block data size");
                                }
                            } else {
                                this.count = this.in.read();
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                            }
                            if (!bl2) {
                                throw new StreamCorruptedException("Unexpected blockdata");
                            }
                            throw new OptionalDataException(this.count);
                        }
                        case 123: {
                            this.resetStream();
                            IOException iOException = (IOException)this.readObject();
                            this.resetStream();
                            throw new WriteAbortedException("Writing aborted by exception", iOException);
                        }
                        default: {
                            throw new StreamCorruptedException("Unknown code in readObject " + by);
                        }
                    }
                }
                catch (OptionalDataException optionalDataException) {
                    throw optionalDataException;
                }
                catch (IOException iOException) {
                    if (this.abortIOException == null && this.abortClassNotFoundException == null) {
                        this.abortIOException = iOException;
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (this.abortIOException != null || this.abortClassNotFoundException != null) break block43;
                    this.abortClassNotFoundException = classNotFoundException2;
                }
            }
            classNotFoundException = null;
            --this.recursionDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            Object var8_19 = null;
            --this.recursionDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            this.setBlockData(bl2);
            throw throwable;
        }
        this.setBlockData(bl2);
        IOException iOException = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            throw iOException;
        }
        classNotFoundException = this.abortClassNotFoundException;
        if (this.recursionDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        if (this.recursionDepth == 0) {
            this.doValidations();
        }
        return object2;
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.isTrustedSubclass) {
            ((ObjectInputStreamDelegate)((Object)this)).defaultReadObjectDelegate();
            return;
        }
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        if (this.currentClassDesc.getFieldSequence() != null) {
            boolean bl = this.setBlockData(false);
            this.inputClassFields(this.currentObject, this.currentClass, this.currentClassDesc.getFieldSequence());
            this.setBlockData(bl);
        }
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        ValidationCallback validationCallback = new ValidationCallback(objectInputValidation, n);
        if (this.callbacks == null) {
            this.callbacks = new Vector(100, 100);
        }
        if (this.callbacks.isEmpty() || ((ValidationCallback)this.callbacks.lastElement()).priority >= n) {
            this.callbacks.addElement(validationCallback);
            return;
        }
        int n2 = this.callbacks.size();
        int n3 = 0;
        while (n3 < n2) {
            ValidationCallback validationCallback2 = (ValidationCallback)this.callbacks.elementAt(n3);
            if (validationCallback2.priority <= n) {
                this.callbacks.insertElementAt(validationCallback, n3);
                return;
            }
            ++n3;
        }
    }

    private void doValidations() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        int n = this.callbacks.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ValidationCallback validationCallback = (ValidationCallback)this.callbacks.elementAt(n2);
            validationCallback.callback.validateObject();
            ++n2;
        }
        this.callbacks.setSize(0);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.loadClass0(null, objectStreamClass.getName());
    }

    private native Class loadClass0(Class var1, String var2) throws ClassNotFoundException;

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected final boolean enableResolveObject(boolean bl) throws SecurityException {
        if (this.isTrustedSubclass) {
            return ((ObjectInputStreamDelegate)((Object)this)).enableResolveObjectDelegate(bl);
        }
        boolean bl2 = this.enableResolve;
        if (bl) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                this.enableResolve = true;
                return bl2;
            }
            throw new SecurityException("Not trusted class");
        }
        this.enableResolve = false;
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.readShort();
        short s2 = this.readShort();
        if (s != -21267) {
            throw new StreamCorruptedException("InputStream does not contain a serialized object");
        }
        if (s2 != 5) {
            throw new StreamCorruptedException("Version Mismatch, Expected " + 5 + " and got " + s2);
        }
    }

    private ObjectStreamClass inputClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class clazz;
        String string = this.readUTF();
        long l = this.readLong();
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l);
        this.assignWireOffset(objectStreamClass);
        objectStreamClass.read(this);
        boolean bl = this.setBlockData(true);
        try {
            clazz = this.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            clazz = null;
        }
        this.SkipToEndOfBlockData();
        bl = this.setBlockData(bl);
        objectStreamClass.setClass(clazz);
        ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
        objectStreamClass.setSuperclass(objectStreamClass2);
        return objectStreamClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inputArray(boolean bl) throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
        Class clazz = objectStreamClass.forClass();
        if (clazz == null && bl) {
            throw new ClassNotFoundException(objectStreamClass.getName());
        }
        int n = this.readInt();
        this.currentObject = clazz == null ? null : ObjectInputStream.allocateNewArray(clazz, n);
        int n2 = this.assignWireOffset(this.currentObject);
        if (clazz != null && clazz.getComponentType().isPrimitive()) {
            Class clazz2 = clazz.getComponentType();
            if (this.buffer == null) {
                this.buffer = new byte[1024];
            }
            int n3 = this.buffer.length;
            int n4 = this.buffer.length;
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])this.currentObject;
                int n5 = 0;
                while (n5 < n) {
                    if (n3 >= n4) {
                        int n6 = n - n5;
                        n6 = n6 <= n4 ? n6 : n4;
                        this.readFully(this.buffer, 0, n6);
                        n3 = 0;
                    }
                    blArray[n5] = this.buffer[n3] != 0;
                    ++n3;
                    ++n5;
                }
                return n2;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])this.currentObject;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = n - n7;
                    n8 = n8 <= n4 ? n8 : n4;
                    this.readFully(this.buffer, 0, n8);
                    System.arraycopy(this.buffer, 0, byArray, n7, n8);
                    n7 += n8;
                }
                return n2;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])this.currentObject;
                int n9 = 0;
                while (n9 < n) {
                    if (n3 > n4 - 2) {
                        int n10 = (n - n9) * 2;
                        n10 = n10 <= n4 ? n10 : n4;
                        this.readFully(this.buffer, 0, n10);
                        n3 = 0;
                    }
                    sArray[n9] = (short)(((this.buffer[n3] & 0xFF) << 8) + (this.buffer[n3 + 1] & 0xFF));
                    n3 += 2;
                    ++n9;
                }
                return n2;
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])this.currentObject;
                int n11 = 0;
                while (n11 < n) {
                    if (n3 > n4 - 4) {
                        int n12 = (n - n11) * 4;
                        n12 = n12 <= n4 ? n12 : n4;
                        this.readFully(this.buffer, 0, n12);
                        n3 = 0;
                    }
                    nArray[n11] = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    n3 += 4;
                    ++n11;
                }
                return n2;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])this.currentObject;
                int n13 = 0;
                while (n13 < n) {
                    int n14;
                    if (n3 > n4 - 8) {
                        n14 = (n - n13) * 8;
                        n14 = n14 <= n4 ? n14 : n4;
                        this.readFully(this.buffer, 0, n14);
                        n3 = 0;
                    }
                    n14 = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    int n15 = ((this.buffer[n3 + 4] & 0xFF) << 24) + ((this.buffer[n3 + 5] & 0xFF) << 16) + ((this.buffer[n3 + 6] & 0xFF) << 8) + (this.buffer[n3 + 7] & 0xFF);
                    lArray[n13] = ((long)n14 << 32) + ((long)n15 & 0xFFFFFFFFL);
                    n3 += 8;
                    ++n13;
                }
                return n2;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])this.currentObject;
                int n16 = 0;
                while (n16 < n) {
                    int n17;
                    if (n3 > n4 - 4) {
                        n17 = (n - n16) * 4;
                        n17 = n17 <= n4 ? n17 : n4;
                        this.readFully(this.buffer, 0, n17);
                        n3 = 0;
                    }
                    n17 = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    n3 += 4;
                    fArray[n16] = Float.intBitsToFloat(n17);
                    ++n16;
                }
                return n2;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])this.currentObject;
                int n18 = 0;
                while (n18 < n) {
                    int n19;
                    if (n3 > n4 - 8) {
                        n19 = (n - n18) * 8;
                        n19 = n19 <= n4 ? n19 : n4;
                        this.readFully(this.buffer, 0, n19);
                        n3 = 0;
                    }
                    n19 = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    int n20 = ((this.buffer[n3 + 4] & 0xFF) << 24) + ((this.buffer[n3 + 5] & 0xFF) << 16) + ((this.buffer[n3 + 6] & 0xFF) << 8) + (this.buffer[n3 + 7] & 0xFF);
                    n3 += 8;
                    dArray[n18] = Double.longBitsToDouble(((long)n19 << 32) + ((long)n20 & 0xFFFFFFFFL));
                    ++n18;
                }
                return n2;
            } else {
                if (clazz2 != Character.TYPE) throw new InvalidClassException(clazz.getName());
                char[] cArray = (char[])this.currentObject;
                int n21 = 0;
                while (n21 < n) {
                    if (n3 > n4 - 2) {
                        int n22 = (n - n21) * 2;
                        n22 = n22 <= n4 ? n22 : n4;
                        this.readFully(this.buffer, 0, n22);
                        n3 = 0;
                    }
                    cArray[n21] = (char)(((this.buffer[n3] & 0xFF) << 8) + (this.buffer[n3 + 1] & 0xFF));
                    n3 += 2;
                    ++n21;
                }
            }
            return n2;
        } else {
            Object[] objectArray = (Object[])this.currentObject;
            boolean bl2 = clazz != null;
            int n23 = 0;
            while (n23 < n) {
                Object object = this.readObject(bl2);
                if (objectArray != null) {
                    objectArray[n23] = object;
                }
                ++n23;
            }
        }
        return n2;
    }

    private int inputObject(boolean bl) throws IOException, ClassNotFoundException {
        int n;
        block29: {
            Class clazz;
            n = -1;
            this.currentClassDesc = (ObjectStreamClass)this.readObject();
            this.currentClass = this.currentClassDesc.forClass();
            if (this.currentClass == null && (bl || this.currentClassDesc.isExternalizable() && !this.currentClassDesc.hasExternalizableBlockDataMode())) {
                throw new ClassNotFoundException(this.currentClassDesc.getName());
            }
            if (this.currentClassDesc.isExternalizable()) {
                try {
                    boolean bl3;
                    block28: {
                        this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, this.currentClass);
                        n = this.assignWireOffset(this.currentObject);
                        bl3 = this.blockDataMode;
                        if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                            bl3 = this.setBlockData(true);
                        }
                        try {
                            if (this.currentObject == null) break block28;
                            Externalizable externalizable = (Externalizable)this.currentObject;
                            externalizable.readExternal(this);
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                                this.SkipToEndOfBlockData();
                                this.setBlockData(bl3);
                            }
                            throw throwable;
                        }
                    }
                    Object var5_8 = null;
                    if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                        this.SkipToEndOfBlockData();
                        this.setBlockData(bl3);
                    }
                    break block29;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
                }
                catch (InstantiationException instantiationException) {
                    throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
                }
            }
            ObjectStreamClass objectStreamClass = this.currentClassDesc;
            Class clazz2 = this.currentClass;
            int n2 = this.spClass;
            objectStreamClass = this.currentClassDesc;
            clazz2 = this.currentClass;
            while (objectStreamClass != null) {
                Class clazz3 = objectStreamClass.forClass();
                clazz = clazz2;
                while (clazz != null) {
                    if (clazz3 == clazz) break;
                    clazz = clazz.getSuperclass();
                }
                ++this.spClass;
                if (this.spClass >= this.classes.length) {
                    int bl2 = this.classes.length * 2;
                    Class[] classArray = new Class[bl2];
                    ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[bl2];
                    System.arraycopy(this.classes, 0, classArray, 0, this.classes.length);
                    System.arraycopy(this.classdesc, 0, objectStreamClassArray, 0, this.classes.length);
                    this.classes = classArray;
                    this.classdesc = objectStreamClassArray;
                }
                if (clazz == null) {
                    this.classdesc[this.spClass] = objectStreamClass;
                    this.classes[this.spClass] = null;
                } else {
                    this.classdesc[this.spClass] = objectStreamClass;
                    this.classes[this.spClass] = clazz;
                    clazz2 = clazz.getSuperclass();
                }
                objectStreamClass = objectStreamClass.getSuperclass();
            }
            try {
                this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, clazz2);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new InvalidClassException(clazz2.getName(), "NoSuchMethodError");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidClassException(clazz2.getName(), "IllegalAccessException");
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidClassException(clazz2.getName(), "InstantiationException");
            }
            n = this.assignWireOffset(this.currentObject);
            try {
                this.spClass = this.spClass;
                while (this.spClass > n2) {
                    this.currentClassDesc = this.classdesc[this.spClass];
                    this.currentClass = this.classes[this.spClass];
                    if (this.classes[this.spClass] != null) {
                        this.setBlockData(true);
                        this.currentClassDesc.localClassDescriptor();
                        if (!this.invokeObjectReader(this.currentObject, this.currentClass)) {
                            this.defaultReadObject();
                        }
                    } else if (this.currentClassDesc.getFieldSequence() != null) {
                        boolean bl2 = this.setBlockData(false);
                        this.inputClassFields(null, this.currentClass, this.currentClassDesc.getFieldSequence());
                        this.setBlockData(bl2);
                    }
                    if (this.currentClassDesc.hasWriteObject()) {
                        this.setBlockData(true);
                        this.SkipToEndOfBlockData();
                    }
                    this.setBlockData(false);
                    --this.spClass;
                }
            }
            finally {
                clazz = null;
                this.spClass = n2;
            }
        }
        return n;
    }

    private void SkipToEndOfBlockData() throws IOException, ClassNotFoundException {
        while (this.peekCode() != 120) {
            try {
                this.readObject(false);
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.length <= 0) continue;
                this.skip(optionalDataException.length);
            }
        }
        this.readCode();
    }

    private void resetStream() throws IOException {
        int n;
        if (this.wireHandle2Object == null) {
            this.wireHandle2Object = new Vector(100, 100);
        } else {
            this.wireHandle2Object.setSize(0);
        }
        this.nextWireOffset = 0;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            n = 0;
            while (n < this.classes.length) {
                this.classes[n] = null;
                ++n;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            n = 0;
            while (n < this.classdesc.length) {
                this.classdesc[n] = null;
                ++n;
            }
        }
        this.spClass = 0;
        this.setBlockData(true);
        if (this.callbacks != null) {
            this.callbacks.setSize(0);
        }
    }

    private int assignWireOffset(Object object) throws IOException {
        this.wireHandle2Object.addElement(object);
        if (++this.nextWireOffset != this.wireHandle2Object.size()) {
            throw new StreamCorruptedException("Elements not assigned in order");
        }
        return this.nextWireOffset - 1;
    }

    private byte peekCode() throws IOException, StreamCorruptedException {
        while (this.currCode == 0) {
            int n = this.in.read();
            if (n < 0) {
                throw new EOFException("Expecting code");
            }
            this.currCode = (byte)n;
            if (this.currCode < 112 || this.currCode > 123) {
                throw new StreamCorruptedException("Type code out of range, is " + this.currCode);
            }
            if (this.currCode != 121) continue;
            if (this.recursionDepth != 0 || this.currentObject != null || this.currentClassDesc != null) {
                throw new StreamCorruptedException("Illegal stream state for reset");
            }
            this.resetStream();
            this.currCode = 0;
        }
        return this.currCode;
    }

    private byte readCode() throws IOException, StreamCorruptedException {
        byte by = this.peekCode();
        this.currCode = 0;
        return by;
    }

    private void pushbackCode(byte by) {
        this.currCode = by;
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        if (this.blockDataMode && this.count > 0) {
            throw new StreamCorruptedException("Unread data");
        }
        this.count = bl ? 0 : -1;
        this.blockDataMode = bl;
        return !bl;
    }

    public int read() throws IOException {
        int n;
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            n = this.in.read();
            if (n >= 0) {
                --this.count;
            }
        } else {
            n = this.in.read();
        }
        return n;
    }

    private void refill() throws IOException {
        byte by;
        this.count = -1;
        try {
            by = this.peekCode();
        }
        catch (EOFException eOFException) {
            return;
        }
        if (by == 119) {
            by = this.readCode();
            int n = this.in.read();
            if (n < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            this.count = n & 0xFF;
            return;
        }
        if (by == 122) {
            int n;
            int n2;
            int n3;
            by = this.readCode();
            int n4 = this.in.read();
            if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n;
            if (n5 < 0) {
                throw new StreamCorruptedException("Negative block data size");
            }
            this.count = n5;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            int n3 = this.count;
            n3 = n2 <= n3 ? n2 : n3;
            int n4 = this.in.read(byArray, n, n3);
            if (n4 > 0) {
                this.count -= n4;
            }
            return n4;
        }
        return this.in.read(byArray, n, n2);
    }

    public int available() throws IOException {
        if (this.blockDataMode) {
            if (this.count == 0 && this.in.available() > 0) {
                this.refill();
            }
            if (this.count >= 0) {
                return this.count;
            }
            return 0;
        }
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        DataInputStream dataInputStream = this.dis;
        return ((long)dataInputStream.readInt() << 32) + ((long)dataInputStream.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        DataInputStream dataInputStream = this.dis;
        return Float.intBitsToFloat(dataInputStream.readInt());
    }

    public double readDouble() throws IOException {
        DataInputStream dataInputStream = this.dis;
        return Double.longBitsToDouble(((long)dataInputStream.readInt() << 32) + ((long)dataInputStream.readInt() & 0xFFFFFFFFL));
    }

    public void readFully(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = this.dis;
        dataInputStream.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        DataInputStream dataInputStream = this.dis;
        return DataInputStream.readUTF(dataInputStream);
    }

    private native void inputClassFields(Object var1, Class var2, int[] var3) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;

    private static native Object allocateNewObject(Class var0, Class var1) throws InstantiationException, IllegalAccessException;

    private static native Object allocateNewArray(Class var0, int var1);

    private native boolean invokeObjectReader(Object var1, Class var2) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;
}

