/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class DecimalFormat
extends NumberFormat {
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols;
    private transient boolean useExponentialNotation;
    private transient byte minExponentDigits;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    static final long serialVersionUID = 864413376551465018L;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        String string = (String)cachedLocaleData.get(locale);
        if (string == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            String[] stringArray = (String[])resourceBundle.getObject("NumberPatterns");
            string = stringArray[0];
            cachedLocaleData.put(locale, string);
        }
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (d != d) {
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            stringBuffer.append(this.symbols.getNaN());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            return stringBuffer;
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (this.multiplier != 1) {
            d *= (double)this.multiplier;
        }
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            stringBuffer.append(bl ? this.negativePrefix : this.positivePrefix);
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            stringBuffer.append(this.symbols.getInfinity());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            stringBuffer.append(bl ? this.negativeSuffix : this.positiveSuffix);
            return stringBuffer;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(d, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            StringBuffer stringBuffer2 = this.subformat(stringBuffer, fieldPosition, bl, false);
            Object var8_7 = null;
            return stringBuffer2;
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        if (this.multiplier != 1 && this.multiplier != 0) {
            long l2;
            boolean bl3 = false;
            if (l < 0L) {
                l2 = Long.MIN_VALUE / (long)this.multiplier;
                bl3 = l < l2;
            } else {
                l2 = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl4 = bl3 = l > l2;
            }
            if (bl3) {
                double d = bl ? -l : l;
                return this.format(d, stringBuffer, fieldPosition);
            }
        }
        l *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(l, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            StringBuffer stringBuffer2 = this.subformat(stringBuffer, fieldPosition, bl, true);
            Object var8_10 = null;
            return stringBuffer2;
        }
    }

    private StringBuffer subformat(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2) {
        char c;
        char c2 = this.symbols.getZeroDigit();
        int n = c2 - 48;
        char c3 = this.symbols.getGroupingSeparator();
        char c4 = c = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            bl = false;
            this.digitList.decimalAt = 0;
        }
        stringBuffer.append(bl ? this.negativePrefix : this.positivePrefix);
        if (this.useExponentialNotation) {
            boolean bl3;
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
                fieldPosition.setEndIndex(-1);
            } else if (fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(-1);
            }
            int n2 = this.digitList.decimalAt;
            int n3 = this.getMaximumIntegerDigits();
            if (n3 > 1 && n3 != this.getMinimumIntegerDigits()) {
                n2 -= n2 < 0 ? n3 : 1;
                n2 = n2 / n3 * n3;
            } else {
                n2 -= this.getMinimumIntegerDigits();
            }
            int n4 = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
            int n5 = this.digitList.isZero() ? this.getMinimumIntegerDigits() : this.digitList.decimalAt - n2;
            int n6 = this.digitList.count;
            if (n4 > n6) {
                n6 = n4;
            }
            int n7 = 0;
            while (n7 < n6) {
                if (n7 == n5) {
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    stringBuffer.append(c);
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                }
                stringBuffer.append(n7 < this.digitList.count ? (char)(this.digitList.digits[n7] + n) : c2);
                ++n7;
            }
            if (fieldPosition.getField() == 0) {
                if (fieldPosition.getEndIndex() < 0) {
                    fieldPosition.setEndIndex(stringBuffer.length());
                }
            } else if (fieldPosition.getField() == 1) {
                if (fieldPosition.getBeginIndex() < 0) {
                    fieldPosition.setBeginIndex(stringBuffer.length());
                }
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            stringBuffer.append(this.symbols.getExponentialSymbol());
            if (this.digitList.isZero()) {
                n2 = 0;
            }
            boolean bl4 = bl3 = n2 < 0;
            if (bl3) {
                n2 = -n2;
            }
            stringBuffer.append(bl3 ? this.negativePrefix : this.positivePrefix);
            DigitList digitList = this.digitList;
            long l = n2;
            digitList.set(l, 0);
            int n8 = this.digitList.decimalAt;
            while (n8 < this.minExponentDigits) {
                stringBuffer.append(c2);
                ++n8;
            }
            int n9 = 0;
            while (n9 < this.digitList.decimalAt) {
                stringBuffer.append(n9 < this.digitList.count ? (char)(this.digitList.digits[n9] + n) : c2);
                ++n9;
            }
            stringBuffer.append(bl3 ? this.negativeSuffix : this.positiveSuffix);
        } else {
            boolean bl5;
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            int n10 = this.getMinimumIntegerDigits();
            int n11 = 0;
            if (this.digitList.decimalAt > 0 && n10 < this.digitList.decimalAt) {
                n10 = this.digitList.decimalAt;
            }
            if (n10 > this.getMaximumIntegerDigits()) {
                n10 = this.getMaximumIntegerDigits();
                n11 = this.digitList.decimalAt - n10;
            }
            int n12 = stringBuffer.length();
            int n13 = n10 - 1;
            while (n13 >= 0) {
                if (n13 < this.digitList.decimalAt && n11 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n11++] + n));
                } else {
                    stringBuffer.append(c2);
                }
                if (this.isGroupingUsed() && n13 > 0 && this.groupingSize != 0 && n13 % this.groupingSize == 0) {
                    stringBuffer.append(c3);
                }
                --n13;
            }
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            boolean bl6 = bl5 = this.getMinimumFractionDigits() > 0 || !bl2 && n11 < this.digitList.count;
            if (!bl5 && stringBuffer.length() == n12) {
                stringBuffer.append(c2);
            }
            if (this.decimalSeparatorAlwaysShown || bl5) {
                stringBuffer.append(c);
            }
            if (fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            int n14 = 0;
            while (n14 < this.getMaximumFractionDigits()) {
                if (n14 >= this.getMinimumFractionDigits() && (bl2 || n11 >= this.digitList.count)) break;
                if (-1 - n14 > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c2);
                } else if (!bl2 && n11 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n11++] + n));
                } else {
                    stringBuffer.append(c2);
                }
                ++n14;
            }
            if (fieldPosition.getField() == 1) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
        }
        stringBuffer.append(bl ? this.negativeSuffix : this.positiveSuffix);
        return stringBuffer;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index += this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.digitList, false, blArray)) {
            return null;
        }
        double d = 0.0;
        long l = 0L;
        boolean bl = true;
        if (blArray[0]) {
            d = Double.POSITIVE_INFINITY;
        } else if (this.digitList.fitsIntoLong(blArray[1])) {
            bl = false;
            l = this.digitList.getLong();
        } else {
            d = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl) {
                d /= (double)this.multiplier;
            } else {
                d = (double)l / (double)this.multiplier;
                if (d < 0.0) {
                    d = -d;
                }
            }
        }
        if (!blArray[1]) {
            d = -d;
            l = -l;
        }
        if (this.multiplier != 1) {
            l = (long)d;
            boolean bl2 = bl = d != (double)l;
        }
        if (bl) {
            return new Double(d);
        }
        return new Long(l);
    }

    private final boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl, boolean[] blArray) {
        boolean bl2;
        boolean bl3;
        int n;
        block28: {
            block27: {
                n = parsePosition.index;
                bl3 = string.regionMatches(n, this.positivePrefix, 0, this.positivePrefix.length());
                bl2 = string.regionMatches(n, this.negativePrefix, 0, this.negativePrefix.length());
                if (bl3 && bl2) {
                    if (this.positivePrefix.length() > this.negativePrefix.length()) {
                        bl2 = false;
                    } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                        bl3 = false;
                    }
                }
                if (bl3) {
                    n += this.positivePrefix.length();
                } else if (bl2) {
                    n += this.negativePrefix.length();
                } else {
                    return false;
                }
                blArray[0] = false;
                if (bl || !string.regionMatches(n, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) break block27;
                n += this.symbols.getInfinity().length();
                blArray[0] = true;
                break block28;
            }
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c = this.symbols.getZeroDigit();
            char c2 = (char)(c + 9);
            int n2 = 48 - c;
            char c3 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c4 = this.symbols.getGroupingSeparator();
            char c5 = this.symbols.getExponentialSymbol();
            boolean bl4 = false;
            boolean bl5 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            while (n < string.length()) {
                block31: {
                    char c6;
                    char c7;
                    block29: {
                        block30: {
                            c7 = string.charAt(n);
                            if (c7 != c) break block29;
                            n5 = -1;
                            if (digitList.count != 0) break block30;
                            if (bl4) {
                                --digitList.decimalAt;
                            }
                            break block31;
                        }
                        ++n4;
                        c6 = (char)(c7 + n2);
                        if (digitList.count >= 19) break block31;
                        digitList.digits[digitList.count++] = (byte)c6;
                        break block31;
                    }
                    if (c7 > c && c7 <= c2) {
                        ++n4;
                        c6 = (char)(c7 + n2);
                        if (digitList.count < 19) {
                            digitList.digits[digitList.count++] = (byte)c6;
                        }
                        n5 = -1;
                    } else if (!bl && c7 == c3) {
                        if (this.isParseIntegerOnly() || bl4) break;
                        digitList.decimalAt = n4;
                        bl4 = true;
                    } else if (!bl && c7 == c4 && this.isGroupingUsed()) {
                        n5 = n;
                    } else {
                        boolean[] blArray2;
                        DigitList digitList2;
                        ParsePosition parsePosition2;
                        if (bl || c7 != c5 || bl5 || !this.subparse(string, parsePosition2 = new ParsePosition(n + 1), digitList2 = new DigitList(), true, blArray2 = new boolean[2]) || !digitList2.fitsIntoLong(blArray2[1])) break;
                        n = parsePosition2.index;
                        n3 = (int)digitList2.getLong();
                        if (!blArray2[1]) {
                            n3 = -n3;
                        }
                        bl5 = true;
                        break;
                    }
                }
                ++n;
            }
            if (n5 != -1) {
                n = n5;
            }
            if (!bl4) {
                digitList.decimalAt = n4;
            }
            digitList.decimalAt += n3;
        }
        if (bl3) {
            bl3 = string.regionMatches(n, this.positiveSuffix, 0, this.positiveSuffix.length());
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.negativeSuffix, 0, this.negativeSuffix.length());
        }
        if (bl3 && bl2) {
            if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                bl2 = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                bl3 = false;
            }
        }
        if (bl3 == bl2) {
            return false;
        }
        parsePosition.index = n + (bl3 ? this.positiveSuffix.length() : this.negativeSuffix.length());
        blArray[1] = bl3;
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return this.positivePrefix.equals(decimalFormat.positivePrefix) && this.positiveSuffix.equals(decimalFormat.positiveSuffix) && this.negativePrefix.equals(decimalFormat.negativePrefix) && this.negativeSuffix.equals(decimalFormat.negativeSuffix) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private String toPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n >= 0) {
            int n2;
            if (n == 1) {
                stringBuffer.append(this.positivePrefix);
            } else {
                stringBuffer.append(this.negativePrefix);
            }
            if (this.useExponentialNotation) {
                n2 = this.getMaximumIntegerDigits();
                while (n2 > 0) {
                    if (n2 == this.groupingSize) {
                        stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                    }
                    if (n2 <= this.getMinimumIntegerDigits()) {
                        stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    } else {
                        stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
                    }
                    --n2;
                }
            } else {
                int n3 = this.groupingSize;
                int n4 = this.getMinimumIntegerDigits();
                n2 = n3 = (n3 >= n4 ? n3 : n4) + 1;
                while (n2 > 0) {
                    if (n2 == this.groupingSize) {
                        stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                    }
                    if (n2 <= this.getMinimumIntegerDigits()) {
                        stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    } else {
                        stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
                    }
                    --n2;
                }
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            n2 = 0;
            while (n2 < this.getMaximumFractionDigits()) {
                if (n2 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                } else {
                    stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
                }
                ++n2;
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl ? this.symbols.getExponentialSymbol() : (char)'E');
                n2 = 0;
                while (n2 < this.minExponentDigits) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    ++n2;
                }
            }
            if (n == 1) {
                stringBuffer.append(this.positiveSuffix);
                if (this.negativeSuffix.equals(this.positiveSuffix) && this.negativePrefix.equals(String.valueOf(this.symbols.getMinusSign()) + this.positivePrefix)) break;
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
            } else {
                stringBuffer.append(this.negativeSuffix);
            }
            --n;
        }
        return new String(stringBuffer);
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl) {
        char c = '0';
        char c2 = ',';
        char c3 = '.';
        char c4 = '%';
        char c5 = '\u2030';
        char c6 = '#';
        char c7 = ';';
        int n = 69;
        if (bl) {
            c = this.symbols.getZeroDigit();
            c2 = this.symbols.getGroupingSeparator();
            c3 = this.symbols.getDecimalSeparator();
            c4 = this.symbols.getPercent();
            c5 = this.symbols.getPerMill();
            c6 = this.symbols.getDigit();
            c7 = this.symbols.getPatternSeparator();
            n = this.symbols.getExponentialSymbol();
        }
        boolean bl2 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 >= 0 && n4 < string.length()) {
            char c8;
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            char c9 = '\uffffffff';
            int n6 = 1;
            char c10 = '\u0000';
            char c11 = '\u0000';
            int n7 = 0;
            int n8 = -1;
            int n9 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            int n10 = n4;
            while (n10 < string.length()) {
                c8 = string.charAt(n10);
                switch (n9) {
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (c8 == '\'') {
                                if (n10 + 1 < string.length() && string.charAt(n10 + 1) == '\'') {
                                    ++n10;
                                    stringBuffer3.append(c8);
                                    break;
                                }
                                bl3 = false;
                                break;
                            }
                        } else {
                            if (c8 == c6 || c8 == c || c8 == c2 || c8 == c3) {
                                if (n9 == 2 && stringBuffer3.length() > 0) {
                                    throw new IllegalArgumentException("Unquoted special character '" + c8 + "' in pattern \"" + string + '\"');
                                }
                                n9 = 1;
                                if (n5 == 1) {
                                    n2 = n10;
                                }
                                --n10;
                                break;
                            }
                            if (c8 == '\u00a4') {
                                boolean bl4 = n10 + 1 < string.length() && string.charAt(n10 + 1) == '\u00a4';
                                stringBuffer3.append(bl4 ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
                                if (bl4) {
                                    ++n10;
                                }
                                this.isCurrencyFormat = true;
                                break;
                            }
                            if (c8 == '\'') {
                                if (c8 == '\'') {
                                    if (n10 + 1 < string.length() && string.charAt(n10 + 1) == '\'') {
                                        ++n10;
                                        stringBuffer3.append(c8);
                                        break;
                                    }
                                    bl3 = true;
                                    break;
                                }
                            } else {
                                if (c8 == c7) {
                                    if (n9 == 0 || n5 == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + c8 + "' in pattern \"" + string + '\"');
                                    }
                                    n4 = n10 + 1;
                                    n10 = string.length();
                                    break;
                                }
                                if (c8 == c4) {
                                    if (n6 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n6 = 100;
                                    c8 = this.symbols.getPercent();
                                } else if (c8 == c5) {
                                    if (n6 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n6 = 1000;
                                    c8 = this.symbols.getPerMill();
                                }
                            }
                        }
                        stringBuffer3.append(c8);
                        break;
                    }
                    case 1: {
                        if (n5 == 1) {
                            ++n3;
                        } else {
                            if (--n3 != 0) break;
                            n9 = 2;
                            stringBuffer3 = stringBuffer2;
                            break;
                        }
                        if (c8 == c6) {
                            if (c11 > '\u0000') {
                                ++n7;
                            } else {
                                ++c10;
                            }
                            if (n8 < 0 || c9 >= '\u0000') break;
                            n8 = (byte)(n8 + 1);
                            break;
                        }
                        if (c8 == c) {
                            if (n7 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"');
                            }
                            ++c11;
                            if (n8 < 0 || c9 >= '\u0000') break;
                            n8 = (byte)(n8 + 1);
                            break;
                        }
                        if (c8 == c2) {
                            n8 = 0;
                            break;
                        }
                        if (c8 == c3) {
                            if (c9 >= '\u0000') {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            c9 = c10 + c11 + n7;
                            break;
                        }
                        n9 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n10;
                        --n3;
                    }
                }
                ++n10;
            }
            if (c11 == '\u0000' && c10 > '\u0000') {
                if (c9 >= '\u0000') {
                    c8 = c9;
                    if (c8 == '\u0000') {
                        ++c8;
                    }
                    n7 = c10 - c8;
                    c10 = c8 - '\u0001';
                } else {
                    --c10;
                }
                c11 = '\u0001';
            }
            if (c9 < '\u0000' && n7 > 0 || c9 >= '\u0000' && (c9 < c10 || c9 > c10 + c11) || n8 == 0 || bl3) {
                throw new IllegalArgumentException("Malformed pattern \"" + string + '\"');
            }
            if (n5 == 1) {
                this.positivePrefix = new String(stringBuffer);
                this.positiveSuffix = new String(stringBuffer2);
                this.negativePrefix = this.positivePrefix;
                this.negativeSuffix = this.positiveSuffix;
                c8 = c10 + c11 + n7;
                this.setMinimumIntegerDigits(c9 >= '\u0000' ? c9 - c10 : 0);
                if (c11 > '\u0001' && c10 == '\u0000' && n7 == 0) {
                    this.setMinimumIntegerDigits(c11);
                } else if (c11 > '\u0000' && c10 > '\u0000' && c11 != c10 && c8 == c10 + c11) {
                    this.setMinimumIntegerDigits(c11);
                }
                this.setMaximumIntegerDigits(this.useExponentialNotation ? c10 + this.getMinimumIntegerDigits() : 127);
                this.setMaximumFractionDigits(c9 >= '\u0000' ? c8 - c9 : 0);
                this.setMinimumFractionDigits(c9 >= '\u0000' ? c10 + c11 - c9 : 0);
                this.setGroupingUsed(n8 > 0);
                this.groupingSize = (byte)(n8 > 0 ? n8 : 0);
                this.multiplier = n6;
                this.setDecimalSeparatorAlwaysShown(c9 == '\u0000' || c9 == c8);
            } else {
                this.negativePrefix = new String(stringBuffer);
                this.negativeSuffix = new String(stringBuffer2);
                bl2 = true;
            }
            --n5;
        }
        if (!bl2 || this.negativePrefix.equals(this.positivePrefix) && this.negativeSuffix.equals(this.positiveSuffix)) {
            this.negativeSuffix = this.positiveSuffix;
            this.negativePrefix = String.valueOf(this.symbols.getMinusSign()) + this.negativePrefix;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.digitList = new DigitList();
    }
}

