/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale ENGLISH = new Locale("en", "", "");
    public static final Locale FRENCH = new Locale("fr", "", "");
    public static final Locale GERMAN = new Locale("de", "", "");
    public static final Locale ITALIAN = new Locale("it", "", "");
    public static final Locale JAPANESE = new Locale("ja", "", "");
    public static final Locale KOREAN = new Locale("ko", "", "");
    public static final Locale CHINESE = new Locale("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW", "");
    public static final Locale FRANCE = new Locale("fr", "FR", "");
    public static final Locale GERMANY = new Locale("de", "DE", "");
    public static final Locale ITALY = new Locale("it", "IT", "");
    public static final Locale JAPAN = new Locale("ja", "JP", "");
    public static final Locale KOREA = new Locale("ko", "KR", "");
    public static final Locale CHINA = new Locale("zh", "CN", "");
    public static final Locale PRC = new Locale("zh", "CN", "");
    public static final Locale TAIWAN = new Locale("zh", "TW", "");
    public static final Locale UK = new Locale("en", "GB", "");
    public static final Locale US = new Locale("en", "US", "");
    public static final Locale CANADA = new Locale("en", "CA", "");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA", "");
    static final long serialVersionUID = 9149081749638150636L;
    private String language = "";
    private String country = "";
    private String variant = "";
    private int hashcode = -1;
    private static Locale defaultLocale;

    public Locale(String string, String string2, String string3) {
        string = this.toLowerCase(string).intern();
        if (string == "he") {
            string = "iw";
        } else if (string == "yi") {
            string = "ji";
        } else if (string == "id") {
            string = "in";
        }
        this.language = string;
        this.country = this.toUpperCase(string2).intern();
        this.variant = this.toUpperCase(string3).intern();
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public static synchronized void setDefault(Locale locale) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.language");
        }
        defaultLocale = locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.language);
        if (this.country.length() != 0) {
            stringBuffer.append('_');
            stringBuffer.append(this.country);
            if (this.variant.length() != 0) {
                stringBuffer.append('_');
                stringBuffer.append(this.variant);
            }
        }
        return new String(stringBuffer);
    }

    public String getISO3Language() throws MissingResourceException {
        if (this.language.length() == 0) {
            return "";
        }
        this.getISO2Language();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        return (String)resourceBundle.getObject("ShortLanguage");
    }

    public String getISO3Country() throws MissingResourceException {
        if (this.country.length() == 0) {
            return "";
        }
        this.getISO2Country();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        return (String)resourceBundle.getObject("ShortCountry");
    }

    String getISO2Language() throws MissingResourceException {
        if (this.language.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        String string = (String)resourceBundle.getObject("LocaleString");
        String string2 = string.substring(0, 2);
        if (!string2.equals(this.language)) {
            throw new MissingResourceException("Requested resource bundle not installed", "LocaleElements", "LocaleString");
        }
        return string2;
    }

    String getISO2Country() throws MissingResourceException {
        if (this.country.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        String string = (String)resourceBundle.getObject("LocaleString");
        String string2 = string.substring(3, 5);
        if (!string2.equals(this.country)) {
            throw new MissingResourceException("Requested resource bundle not installed", "LocaleElements", "LocaleString");
        }
        return string2;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(defaultLocale);
    }

    public String getDisplayLanguage(Locale locale) {
        String string = this.language;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Languages"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = defaultLocale;
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(defaultLocale);
    }

    public String getDisplayCountry(Locale locale) {
        String string = this.country;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Countries"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = defaultLocale;
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(defaultLocale);
    }

    public String getDisplayVariant(Locale locale) {
        String[] stringArray;
        if (this.variant.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String[] stringArray2 = this.getDisplayVariantArray(resourceBundle);
        try {
            stringArray = (String[])resourceBundle.getObject("LocaleNamePatterns");
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = null;
        }
        return Locale.formatList(stringArray, stringArray2);
    }

    public final String getDisplayName() {
        return this.getDisplayName(defaultLocale);
    }

    public String getDisplayName(Locale locale) {
        String[] stringArray;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayCountry(locale);
        String[] stringArray2 = this.getDisplayVariantArray(resourceBundle);
        try {
            stringArray = (String[])resourceBundle.getObject("LocaleNamePatterns");
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = null;
        }
        String string3 = null;
        String[] stringArray3 = null;
        if (string.length() != 0) {
            string3 = string;
            if (string2.length() != 0) {
                stringArray3 = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
                stringArray3[0] = string2;
            } else {
                stringArray3 = stringArray2;
            }
        } else if (string2.length() != 0) {
            string3 = string2;
            stringArray3 = stringArray2;
        } else {
            return Locale.formatList(stringArray, stringArray2);
        }
        Object[] objectArray = new Object[]{new Integer(stringArray3.length != 0 ? 2 : 1), string3, stringArray3.length != 0 ? Locale.formatList(stringArray, stringArray3) : null};
        if (stringArray != null) {
            MessageFormat messageFormat = new MessageFormat(stringArray[0]);
            Object[] objectArray2 = objectArray;
            StringBuffer stringBuffer = ((Format)messageFormat).format(objectArray2, new StringBuffer(), new FieldPosition(0));
            return new String(stringBuffer);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)objectArray[1]);
        if (objectArray.length > 2) {
            stringBuffer.append(" (");
            stringBuffer.append((String)objectArray[2]);
            stringBuffer.append(")");
        }
        return new String(stringBuffer);
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        if (this.hashCode() != locale.hashCode()) {
            return false;
        }
        if (!this.language.equals(locale.language)) {
            return false;
        }
        if (!this.country.equals(locale.country)) {
            return false;
        }
        return this.variant.equals(locale.variant);
    }

    private String toLowerCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toLowerCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private String toUpperCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toUpperCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private String findStringMatch(String[][] stringArray, String string, String string2) {
        int n;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2][0])) {
                return stringArray[n2][1];
            }
            ++n2;
        }
        if (!string2.equals(string)) {
            n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        if (!"EN".equals(string) && "EN".equals(string2)) {
            n = 0;
            while (n < stringArray.length) {
                if ("EN".equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        return "";
    }

    private String[] getDisplayVariantArray(ResourceBundle resourceBundle) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.variant, "_");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringTokenizer.nextToken();
            try {
                stringArray[n] = (String)resourceBundle.getObject("%%" + string);
            }
            catch (MissingResourceException missingResourceException) {
                stringArray[n] = string;
            }
            ++n;
        }
        return stringArray;
    }

    private static String formatList(String[] stringArray, String[] stringArray2) {
        Object object;
        if (stringArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray2.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray2[n]);
                ++n;
            }
            return new String(stringBuffer);
        }
        if (stringArray2.length > 3) {
            object = new MessageFormat(stringArray[2]);
            stringArray2 = Locale.composeList((MessageFormat)object, stringArray2);
        }
        object = new Object[stringArray2.length + 1];
        System.arraycopy(stringArray2, 0, object, 1, stringArray2.length);
        object[0] = new Integer(stringArray2.length);
        MessageFormat messageFormat = new MessageFormat(stringArray[1]);
        Object object2 = object;
        StringBuffer stringBuffer = ((Format)messageFormat).format(object2, new StringBuffer(), new FieldPosition(0));
        return new String(stringBuffer);
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length <= 3) {
            return stringArray;
        }
        Object object = stringArray2 = new String[]{stringArray[0], stringArray[1]};
        String[] stringArray3 = ((Format)messageFormat).format(object, new StringBuffer(), new FieldPosition(0));
        object = new String((StringBuffer)stringArray3);
        stringArray3 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 2, stringArray3, 1, stringArray3.length - 1);
        stringArray3[0] = object;
        return Locale.composeList(messageFormat, stringArray3);
    }

    static {
        String string = System.getProperty("user.region", "");
        String string2 = "";
        int n = string.indexOf(95);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        defaultLocale = new Locale(System.getProperty("user.language", "EN"), string, string2);
    }
}

