/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.util.Stack;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveKey;

class ClientVector
extends Stack
implements Runnable {
    private int num;
    private KeepAliveCache cache;
    private KeepAliveKey key;
    HttpClient[] inUse;
    private int nap;

    ClientVector(KeepAliveCache keepAliveCache, KeepAliveKey keepAliveKey, int n) {
        this.cache = keepAliveCache;
        this.key = keepAliveKey;
        this.nap = n;
        this.inUse = new HttpClient[KeepAliveCache.MAXCONNS];
    }

    synchronized HttpClient get() {
        if (this.empty()) {
            return null;
        }
        HttpClient httpClient = (HttpClient)this.pop();
        if (this.inUse.length == this.num) {
            HttpClient[] httpClientArray = new HttpClient[this.inUse.length * 2];
            System.arraycopy(this.inUse, 0, httpClientArray, 0, this.inUse.length);
            this.inUse = httpClientArray;
        }
        this.inUse[this.num++] = httpClient;
        return httpClient;
    }

    synchronized void put(HttpClient httpClient) {
        if (this.num > 0) {
            --this.num;
        }
        int n = 0;
        while (n < this.inUse.length) {
            if (this.inUse[n] == httpClient) {
                this.inUse[n] = null;
                break;
            }
            ++n;
        }
        this.push(httpClient);
        this.notifyAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        int n;
        do {
            HttpClient httpClient;
            try {
                Thread.sleep(this.nap);
            }
            catch (InterruptedException interruptedException) {}
            KeepAliveCache keepAliveCache = this.cache;
            synchronized (keepAliveCache) {
                ClientVector clientVector = this;
                synchronized (clientVector) {
                    int n2 = 0;
                    while (n2 < this.size()) {
                        httpClient = (HttpClient)this.elementAt(n2);
                        httpClient.closeServer();
                        ++n2;
                    }
                    this.removeAllElements();
                    if (this.num == 0) {
                        this.cache.removeVector(this.key);
                        return;
                    }
                }
            }
            int n3 = 0;
            while (n3 < this.inUse.length) {
                httpClient = this.inUse[n3];
                if (httpClient != null && httpClient.kas.hurry()) {
                    this.put(httpClient);
                }
                ++n3;
            }
            ClientVector clientVector = this;
            synchronized (clientVector) {
                n = this.num + this.size();
            }
        } while (n > 0);
        this.cache.removeVector(this.key);
    }
}

