/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Date;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants {
    String name;
    long time = -1L;
    long crc = -1L;
    long size = -1L;
    int method = -1;
    byte[] extra;
    String comment;
    int flag;
    int version;
    long csize = -1L;
    long offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.name = string;
    }

    ZipEntry() {
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = ZipEntry.javaToDosTime(l);
    }

    public long getTime() {
        return ZipEntry.dosToJavaTime(this.time);
    }

    public void setSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setCrc(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = l;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && byArray.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
        this.extra = byArray;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException("invalid entry comment length");
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    private static long dosToJavaTime(long l) {
        Date date = new Date((int)((l >> 25 & 0x7FL) + 80L), (int)((l >> 21 & 0xFL) - 1L), (int)(l >> 16 & 0x1FL), (int)(l >> 11 & 0x1FL), (int)(l >> 5 & 0x3FL), (int)(l << 1 & 0x3EL));
        return date.getTime();
    }

    private static long javaToDosTime(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return 0x210000L;
        }
        return n - 1980 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }
}

