/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioTranslatorStream;
import sun.audio.InvalidAudioFormatException;
import sun.audio.NativeAudioStream;

public class AudioStream
extends FilterInputStream {
    NativeAudioStream audioIn;

    public AudioStream(InputStream inputStream) throws IOException {
        super(inputStream);
        try {
            this.audioIn = new NativeAudioStream(inputStream);
        }
        catch (InvalidAudioFormatException invalidAudioFormatException) {
            this.audioIn = new AudioTranslatorStream(inputStream);
        }
        this.in = this.audioIn;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = super.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                return n3;
            }
            n3 += n4;
            Thread.currentThread();
            Thread.yield();
        }
        return n3;
    }

    public AudioData getData() throws IOException {
        byte[] byArray = new byte[this.audioIn.getLength()];
        int n = this.read(byArray, 0, this.audioIn.getLength());
        this.close();
        if (n != this.audioIn.getLength()) {
            throw new IOException("audio data read error");
        }
        return new AudioData(byArray);
    }

    public int getLength() {
        return this.audioIn.getLength();
    }
}

