/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;

public class Socket {
    SocketImpl impl;
    private static SocketImplFactory factory;

    protected Socket() {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.impl = socketImpl;
    }

    public Socket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, null, 0, true);
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, null, 0, true);
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2, true);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress, n, inetAddress2, n2, true);
    }

    public Socket(String string, int n, boolean bl) throws IOException {
        this(InetAddress.getByName(string), n, null, 0, bl);
    }

    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this(inetAddress, n, null, 0, bl);
    }

    private Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, boolean bl) throws IOException {
        this();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port out range:" + n);
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("port out range:" + n2);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetAddress.getHostAddress(), n);
        }
        try {
            this.impl.create(bl);
            if (inetAddress2 != null || n2 > 0) {
                if (inetAddress2 == null) {
                    inetAddress2 = InetAddress.anyLocalAddress;
                }
                this.impl.bind(inetAddress2, n2);
            }
            this.impl.connect(inetAddress, n);
            return;
        }
        catch (SocketException socketException) {
            this.impl.close();
            throw socketException;
        }
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = (InetAddress)this.impl.getOption(15);
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        return inetAddress;
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.impl.setOption(1, new Boolean(bl));
    }

    public boolean getTcpNoDelay() throws SocketException {
        return (Boolean)this.impl.getOption(1);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (!bl) {
            this.impl.setOption(128, new Boolean(bl));
            return;
        }
        this.impl.setOption(128, new Integer(n));
    }

    public int getSoLinger() throws SocketException {
        Object object = this.impl.getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public synchronized void close() throws IOException {
        this.impl.close();
    }

    public String toString() {
        return "Socket[addr=" + this.impl.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }
}

