/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

public class Deflater {
    private int strm;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;

    public Deflater(int n, boolean bl) {
        this.level = n;
        this.strategy = 0;
        this.init(bl);
    }

    public Deflater(int n) {
        this(n, false);
    }

    public Deflater() {
        this(-1, false);
    }

    public synchronized void setInput(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = byArray;
        this.off = n;
        this.len = n2;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray);
    }

    public synchronized native void setDictionary(byte[] var1, int var2, int var3);

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public synchronized void setStrategy(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 2: 
        }
        if (this.strategy != n) {
            this.strategy = n;
            this.setParams = true;
        }
    }

    public synchronized void setLevel(int n) {
        if ((n < 0 || n > 9) && n != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        if (this.level != n) {
            this.level = n;
            this.setParams = true;
        }
    }

    public boolean needsInput() {
        return this.len <= 0;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized native int deflate(byte[] var1, int var2, int var3);

    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length);
    }

    public synchronized native int getAdler();

    public synchronized native int getTotalIn();

    public synchronized native int getTotalOut();

    public synchronized native void reset();

    public synchronized native void end();

    protected void finalize() {
        this.end();
    }

    private native void init(boolean var1);

    static {
        System.loadLibrary("zip");
    }
}

