/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class AlgorithmId
implements Serializable {
    private static boolean debug;
    private ObjectIdentifier algid;
    protected DerValue params;
    private static final int[] MD2_data;
    private static final int[] MD5_data;
    private static final int[] SHA1_data;
    public static final ObjectIdentifier MD2_oid;
    public static final ObjectIdentifier MD5_oid;
    public static final ObjectIdentifier SHA_oid;
    private static final int[] DH_data;
    private static final int[] dsa_data;
    private static final int[] RSA_data;
    private static final int[] RSAEncryption_data;
    public static final ObjectIdentifier DH_oid;
    public static final ObjectIdentifier DSA_oid;
    public static final ObjectIdentifier RSA_oid;
    public static final ObjectIdentifier RSAEncryption_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] shaWithDSA_data;
    public static final ObjectIdentifier md2WithRSAEncryption_oid;
    public static final ObjectIdentifier md5WithRSAEncryption_oid;
    public static final ObjectIdentifier shaWithDSA_oid;

    public static AlgorithmId getAlgorithmId(String string) throws NoSuchAlgorithmException {
        return AlgorithmId.get(string);
    }

    public static AlgorithmId get(String string) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier = AlgorithmId.algOID(string);
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier);
    }

    public static AlgorithmId parse(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (derValue.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            derValue2 = null;
        } else {
            derValue2 = derInputStream.getDerValue();
            if (derValue2.tag == 5) {
                derValue2 = null;
            }
        }
        AlgorithmId algorithmId = AlgorithmId.buildAlgorithmId(objectIdentifier, derValue2);
        algorithmId.decodeParams();
        return algorithmId;
    }

    private static AlgorithmId buildAlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        String string = Security.getAlgorithmProperty(objectIdentifier.toString(), "Class");
        if (debug) {
            System.out.println("dynamic class name for [" + objectIdentifier.toString() + "|Class]: " + string);
        }
        if (string == null || string.equals("")) {
            return new AlgorithmId(objectIdentifier, derValue);
        }
        try {
            Class clazz = Class.forName(string);
            Object object = clazz.newInstance();
            if (!(object instanceof AlgorithmId)) {
                System.err.println("Misconfiguration:  faulty algorithm config, " + string);
                return new AlgorithmId(objectIdentifier, derValue);
            }
            AlgorithmId algorithmId = (AlgorithmId)object;
            algorithmId.algid = objectIdentifier;
            algorithmId.params = derValue;
            algorithmId.decodeParams();
            return algorithmId;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Misconfiguration:  unknown algorithm class, " + string);
            return new AlgorithmId(objectIdentifier, derValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(String.valueOf(string) + " [internal error]");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Misconfiguration:  faulty algorithm class, " + string);
            return new AlgorithmId(objectIdentifier, derValue);
        }
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier) {
        this.algid = objectIdentifier;
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.algid = objectIdentifier;
        this.params = derValue;
        this.decodeParams();
    }

    public AlgorithmId() {
    }

    protected void decodeParams() throws IOException {
    }

    public final void emit(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid);
        if (this.params == null) {
            derOutputStream2.putNull();
        } else {
            derOutputStream2.putDerValue(this.params);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public final void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.emit(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public final byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.emit(derOutputStream);
        return derOutputStream.toByteArray();
    }

    private static ObjectIdentifier algOID(String string) {
        if (string.equals("MD5")) {
            return MD5_oid;
        }
        if (string.equals("MD2")) {
            return MD2_oid;
        }
        if (string.equals("SHA") || string.equals("SHA1") || string.equals("SHA-1")) {
            return SHA_oid;
        }
        if (string.equals("RSA")) {
            return RSA_oid;
        }
        if (string.equals("Diffie-Hellman") || string.equals("DH")) {
            return DH_oid;
        }
        if (string.equals("DSA")) {
            return DSA_oid;
        }
        if (string.equals("MD5withRSA") || string.equals("MD5/RSA")) {
            return md5WithRSAEncryption_oid;
        }
        if (string.equals("MD2withRSA") || string.equals("MD2/RSA")) {
            return md2WithRSAEncryption_oid;
        }
        if (string.equals("SHAwithDSA") || string.equals("SHA/DSA")) {
            return shaWithDSA_oid;
        }
        return null;
    }

    private String algName() {
        if (this.algid.equals(MD5_oid)) {
            return "MD5";
        }
        if (this.algid.equals(MD2_oid)) {
            return "MD2";
        }
        if (this.algid.equals(SHA_oid)) {
            return "SHA";
        }
        if (this.algid.equals(RSAEncryption_oid) || this.algid.equals(RSA_oid)) {
            return "RSA";
        }
        if (this.algid.equals(DH_oid)) {
            return "Diffie-Hellman";
        }
        if (this.algid.equals(DSA_oid)) {
            return "DSA";
        }
        if (this.algid.equals(md5WithRSAEncryption_oid)) {
            return "MD5withRSA";
        }
        if (this.algid.equals(md2WithRSAEncryption_oid)) {
            return "MD2withRSA";
        }
        if (this.algid.equals(shaWithDSA_oid)) {
            return "SHA1withDSA";
        }
        return "OID." + this.algid.toString();
    }

    public final ObjectIdentifier getOID() {
        return this.algid;
    }

    public String getName() {
        return this.algName();
    }

    public String toString() {
        return "[" + this.algName() + this.paramsToString() + "]";
    }

    protected String paramsToString() {
        if (this.params == null) {
            return "";
        }
        return ", params unparsed";
    }

    public boolean equals(AlgorithmId algorithmId) {
        if (!this.algid.equals(algorithmId.algid)) {
            return false;
        }
        if (this.params == null && algorithmId.params == null) {
            return true;
        }
        if (this.params == null) {
            return false;
        }
        return this.params.equals(algorithmId.params);
    }

    public boolean equals(Object object) {
        if (object instanceof AlgorithmId) {
            return this.equals((AlgorithmId)object);
        }
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier objectIdentifier) {
        return this.algid.equals(objectIdentifier);
    }

    static {
        MD2_data = new int[]{1, 2, 840, 113549, 2, 2};
        MD5_data = new int[]{1, 2, 840, 113549, 2, 5};
        SHA1_data = new int[]{1, 3, 14, 3, 2, 26};
        MD2_oid = new ObjectIdentifier(MD2_data);
        MD5_oid = new ObjectIdentifier(MD5_data);
        SHA_oid = new ObjectIdentifier(SHA1_data);
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        dsa_data = new int[]{1, 3, 14, 3, 2, 12};
        RSA_data = new int[]{1, 2, 5, 8, 1, 1};
        RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        DH_oid = new ObjectIdentifier(DH_data);
        DSA_oid = new ObjectIdentifier(dsa_data);
        RSA_oid = new ObjectIdentifier(RSA_data);
        RSAEncryption_oid = new ObjectIdentifier(RSAEncryption_data);
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        shaWithDSA_data = new int[]{1, 3, 14, 3, 2, 13};
        md2WithRSAEncryption_oid = new ObjectIdentifier(md2WithRSAEncryption_data);
        md5WithRSAEncryption_oid = new ObjectIdentifier(md5WithRSAEncryption_data);
        shaWithDSA_oid = new ObjectIdentifier(shaWithDSA_data);
    }
}

