# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.4
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Math::GSL::SparseMatrix;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::SparseMatrixc;
bootstrap Math::GSL::SparseMatrix;
package Math::GSL::SparseMatrix;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::SparseMatrix;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::SparseMatrix;

*gsl_error = *Math::GSL::SparseMatrixc::gsl_error;
*gsl_stream_printf = *Math::GSL::SparseMatrixc::gsl_stream_printf;
*gsl_strerror = *Math::GSL::SparseMatrixc::gsl_strerror;
*gsl_set_error_handler = *Math::GSL::SparseMatrixc::gsl_set_error_handler;
*gsl_set_error_handler_off = *Math::GSL::SparseMatrixc::gsl_set_error_handler_off;
*gsl_set_stream_handler = *Math::GSL::SparseMatrixc::gsl_set_stream_handler;
*gsl_set_stream = *Math::GSL::SparseMatrixc::gsl_set_stream;
*gsl_spmatrix_alloc = *Math::GSL::SparseMatrixc::gsl_spmatrix_alloc;
*gsl_spmatrix_alloc_nzmax = *Math::GSL::SparseMatrixc::gsl_spmatrix_alloc_nzmax;
*gsl_spmatrix_free = *Math::GSL::SparseMatrixc::gsl_spmatrix_free;
*gsl_spmatrix_realloc = *Math::GSL::SparseMatrixc::gsl_spmatrix_realloc;
*gsl_spmatrix_set_zero = *Math::GSL::SparseMatrixc::gsl_spmatrix_set_zero;
*gsl_spmatrix_nnz = *Math::GSL::SparseMatrixc::gsl_spmatrix_nnz;
*gsl_spmatrix_compare_idx = *Math::GSL::SparseMatrixc::gsl_spmatrix_compare_idx;
*gsl_spmatrix_tree_rebuild = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_rebuild;
*gsl_spmatrix_memcpy = *Math::GSL::SparseMatrixc::gsl_spmatrix_memcpy;
*gsl_spmatrix_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_get;
*gsl_spmatrix_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_set;
*gsl_spmatrix_ptr = *Math::GSL::SparseMatrixc::gsl_spmatrix_ptr;
*gsl_spmatrix_compcol = *Math::GSL::SparseMatrixc::gsl_spmatrix_compcol;
*gsl_spmatrix_ccs = *Math::GSL::SparseMatrixc::gsl_spmatrix_ccs;
*gsl_spmatrix_crs = *Math::GSL::SparseMatrixc::gsl_spmatrix_crs;
*gsl_spmatrix_cumsum = *Math::GSL::SparseMatrixc::gsl_spmatrix_cumsum;
*gsl_spmatrix_fprintf = *Math::GSL::SparseMatrixc::gsl_spmatrix_fprintf;
*gsl_spmatrix_fscanf = *Math::GSL::SparseMatrixc::gsl_spmatrix_fscanf;
*gsl_spmatrix_fwrite = *Math::GSL::SparseMatrixc::gsl_spmatrix_fwrite;
*gsl_spmatrix_fread = *Math::GSL::SparseMatrixc::gsl_spmatrix_fread;
*gsl_spmatrix_scale = *Math::GSL::SparseMatrixc::gsl_spmatrix_scale;
*gsl_spmatrix_minmax = *Math::GSL::SparseMatrixc::gsl_spmatrix_minmax;
*gsl_spmatrix_add = *Math::GSL::SparseMatrixc::gsl_spmatrix_add;
*gsl_spmatrix_d2sp = *Math::GSL::SparseMatrixc::gsl_spmatrix_d2sp;
*gsl_spmatrix_sp2d = *Math::GSL::SparseMatrixc::gsl_spmatrix_sp2d;
*gsl_spmatrix_equal = *Math::GSL::SparseMatrixc::gsl_spmatrix_equal;
*gsl_spmatrix_transpose = *Math::GSL::SparseMatrixc::gsl_spmatrix_transpose;
*gsl_spmatrix_transpose2 = *Math::GSL::SparseMatrixc::gsl_spmatrix_transpose2;
*gsl_spmatrix_transpose_memcpy = *Math::GSL::SparseMatrixc::gsl_spmatrix_transpose_memcpy;

############# Class : Math::GSL::SparseMatrix::gsl_spmatrix_tree ##############

package Math::GSL::SparseMatrix::gsl_spmatrix_tree;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::SparseMatrix );
%OWNER = ();
%ITERATORS = ();
*swig_tree_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_tree_get;
*swig_tree_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_tree_set;
*swig_node_array_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_node_array_get;
*swig_node_array_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_node_array_set;
*swig_n_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_n_get;
*swig_n_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_n_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::SparseMatrixc::new_gsl_spmatrix_tree(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::SparseMatrixc::delete_gsl_spmatrix_tree($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Math::GSL::SparseMatrix::gsl_spmatrix ##############

package Math::GSL::SparseMatrix::gsl_spmatrix;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::SparseMatrix );
%OWNER = ();
%ITERATORS = ();
*swig_size1_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_size1_get;
*swig_size1_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_size1_set;
*swig_size2_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_size2_get;
*swig_size2_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_size2_set;
*swig_i_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_i_get;
*swig_i_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_i_set;
*swig_data_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_data_get;
*swig_data_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_data_set;
*swig_p_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_p_get;
*swig_p_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_p_set;
*swig_nzmax_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_nzmax_get;
*swig_nzmax_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_nzmax_set;
*swig_nz_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_nz_get;
*swig_nz_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_nz_set;
*swig_tree_data_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_data_get;
*swig_tree_data_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_tree_data_set;
*swig_work_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_work_get;
*swig_work_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_work_set;
*swig_work_sze_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_work_sze_get;
*swig_work_sze_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_work_sze_set;
*swig_work_dbl_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_work_dbl_get;
*swig_work_dbl_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_work_dbl_set;
*swig_sptype_get = *Math::GSL::SparseMatrixc::gsl_spmatrix_sptype_get;
*swig_sptype_set = *Math::GSL::SparseMatrixc::gsl_spmatrix_sptype_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::SparseMatrixc::new_gsl_spmatrix(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::SparseMatrixc::delete_gsl_spmatrix($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Math::GSL::SparseMatrix;

*GSL_MAJOR_VERSION = *Math::GSL::SparseMatrixc::GSL_MAJOR_VERSION;
*GSL_MINOR_VERSION = *Math::GSL::SparseMatrixc::GSL_MINOR_VERSION;
*GSL_POSZERO = *Math::GSL::SparseMatrixc::GSL_POSZERO;
*GSL_NEGZERO = *Math::GSL::SparseMatrixc::GSL_NEGZERO;
*GSL_SUCCESS = *Math::GSL::SparseMatrixc::GSL_SUCCESS;
*GSL_FAILURE = *Math::GSL::SparseMatrixc::GSL_FAILURE;
*GSL_CONTINUE = *Math::GSL::SparseMatrixc::GSL_CONTINUE;
*GSL_EDOM = *Math::GSL::SparseMatrixc::GSL_EDOM;
*GSL_ERANGE = *Math::GSL::SparseMatrixc::GSL_ERANGE;
*GSL_EFAULT = *Math::GSL::SparseMatrixc::GSL_EFAULT;
*GSL_EINVAL = *Math::GSL::SparseMatrixc::GSL_EINVAL;
*GSL_EFAILED = *Math::GSL::SparseMatrixc::GSL_EFAILED;
*GSL_EFACTOR = *Math::GSL::SparseMatrixc::GSL_EFACTOR;
*GSL_ESANITY = *Math::GSL::SparseMatrixc::GSL_ESANITY;
*GSL_ENOMEM = *Math::GSL::SparseMatrixc::GSL_ENOMEM;
*GSL_EBADFUNC = *Math::GSL::SparseMatrixc::GSL_EBADFUNC;
*GSL_ERUNAWAY = *Math::GSL::SparseMatrixc::GSL_ERUNAWAY;
*GSL_EMAXITER = *Math::GSL::SparseMatrixc::GSL_EMAXITER;
*GSL_EZERODIV = *Math::GSL::SparseMatrixc::GSL_EZERODIV;
*GSL_EBADTOL = *Math::GSL::SparseMatrixc::GSL_EBADTOL;
*GSL_ETOL = *Math::GSL::SparseMatrixc::GSL_ETOL;
*GSL_EUNDRFLW = *Math::GSL::SparseMatrixc::GSL_EUNDRFLW;
*GSL_EOVRFLW = *Math::GSL::SparseMatrixc::GSL_EOVRFLW;
*GSL_ELOSS = *Math::GSL::SparseMatrixc::GSL_ELOSS;
*GSL_EROUND = *Math::GSL::SparseMatrixc::GSL_EROUND;
*GSL_EBADLEN = *Math::GSL::SparseMatrixc::GSL_EBADLEN;
*GSL_ENOTSQR = *Math::GSL::SparseMatrixc::GSL_ENOTSQR;
*GSL_ESING = *Math::GSL::SparseMatrixc::GSL_ESING;
*GSL_EDIVERGE = *Math::GSL::SparseMatrixc::GSL_EDIVERGE;
*GSL_EUNSUP = *Math::GSL::SparseMatrixc::GSL_EUNSUP;
*GSL_EUNIMPL = *Math::GSL::SparseMatrixc::GSL_EUNIMPL;
*GSL_ECACHE = *Math::GSL::SparseMatrixc::GSL_ECACHE;
*GSL_ETABLE = *Math::GSL::SparseMatrixc::GSL_ETABLE;
*GSL_ENOPROG = *Math::GSL::SparseMatrixc::GSL_ENOPROG;
*GSL_ENOPROGJ = *Math::GSL::SparseMatrixc::GSL_ENOPROGJ;
*GSL_ETOLF = *Math::GSL::SparseMatrixc::GSL_ETOLF;
*GSL_ETOLX = *Math::GSL::SparseMatrixc::GSL_ETOLX;
*GSL_ETOLG = *Math::GSL::SparseMatrixc::GSL_ETOLG;
*GSL_EOF = *Math::GSL::SparseMatrixc::GSL_EOF;
*GSL_SPMATRIX_TRIPLET = *Math::GSL::SparseMatrixc::GSL_SPMATRIX_TRIPLET;
*GSL_SPMATRIX_CCS = *Math::GSL::SparseMatrixc::GSL_SPMATRIX_CCS;
*GSL_SPMATRIX_CRS = *Math::GSL::SparseMatrixc::GSL_SPMATRIX_CRS;

@EXPORT_OK = qw/
               gsl_spmatrix_alloc
               gsl_spmatrix_get
               gsl_spmatrix_set
               gsl_spmatrix_free
               gsl_spmatrix_transpose
               gsl_spmatrix_transpose2
               gsl_spmatrix_transpose_memcpy
               gsl_spmatrix_set_zero
               gsl_spmatrix_add
               gsl_spmatrix_nnz
               gsl_spmatrix_scale
               gsl_spmatrix_d2sp
               gsl_spmatrix_sp2d
               gsl_spmatrix_minmax
               gsl_spmatrix_ccs
               gsl_spmatrix_crs
               gsl_spmatrix_memcpy
               gsl_spmatrix_ptr
               gsl_spmatrix_fwrite
               gsl_spmatrix_fread
               gsl_spmatrix_fprintf
               gsl_spmatrix_fscanf
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

__END__

=encoding utf8

=head1 NAME

Math::GSL::SparseMatrix - Sparse Matrices

=head1 SYNOPSIS

    use Math::GSL::SparseMatrix qw/:all/;
    use Math::GSL::Matrix qw/gsl_matrix_alloc/;
    my $sparse = gsl_spmatrix_alloc(100,100);
    my $status = gsl_spmatrix_set($sparse,50,50,42.42);
    my $value  = gsl_spmatrix_get($sparse,50,50);

    # multiply every element by 5
    $status = gsl_spmatrix_scale($sparse, 5);

    # get the number of non-zero elements
    my $nnz = gsl_spmatrix_nnz($sparse);

    # fine min and max values, other than zero elements
    ($status, $min, $max) = gsl_spmatrix_minmax($sparse);

    # set all elements to zero
    $status = gsl_spmatrix_set_zero($sparse);

    my $dense  = gsl_matrix_alloc(100,100);
    # convert a sparse matrix to a dense matrix
    $status = gsl_spmatrix_sp2d($dense, $sparse);

    # convert a dense matrix to a sparse matrix
    $status = gsl_spmatrix_d2sp($sparse, $dense);

=head1 DESCRIPTION

NOTE: This module requires GSL 2.0 or higher.

For more informations on the functions, we refer you to the GSL offcial
documentation: L<http://www.gnu.org/software/gsl/manual/html_node/>

=head1 AUTHORS

Jonathan "Duke" Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008-2016 Jonathan "Duke" Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut


1;
