/*
 * Decompiled with CFR 0.152.
 */
package netscape.palomar.util;

import java.util.Enumeration;
import java.util.Vector;
import netscape.palomar.util.CascadedExceptionToken;
import netscape.palomar.util.Environment;
import netscape.palomar.util.Warning;

public class CascadedException
extends Exception {
    public static final int unknownArgument = 0;
    public static final int unknownProperty = 1;
    public static final int unknownMethod = 2;
    public static final int unknownTrigger = 3;
    public static final int fileNotFound = 4;
    public static final int cantWriteToFile = 5;
    public static final int invalidProjectElementLocation = 6;
    public static final int CANT_LOAD_PALETTE_FILE = 7;
    public static final int CANT_SAVE_PALETTE_FILE = 8;
    public static final int CLONE_NOT_SUPPORTED = 9;
    public static final int HTML_PARSER_FAILURE = 10;
    public static final int HTML_PARSER_NOT_TEXT = 11;
    public static final int HTML_PARSER_TEXT_FAILURE = 12;
    public static final int HTML_PARSER_NOT_TOKEN = 13;
    public static final int HTML_PARSER_TOKEN_FAILURE = 14;
    public static final int HTML_PARSER_TIL_TOKEN_FAILURE = 15;
    public static final int HTML_PARSER_CLOSE = 16;
    public static final int HTML_PARSER_WRITE = 17;
    public static final int HTML_PARSER_READ = 18;
    public static final int CANT_VIEW_OBJECT = 19;
    public static final int INVALID_ARGUMENT = 20;
    public static final int NO_PROPERTY_TYPE = 21;
    public static final int CANT_LOAD_SELECTED_ELEMENT = 22;
    public static final int CANT_GET_ARCHIVE = 23;
    public static final int IO_ERROR = 24;
    public static final int SECURITY_EXCEPTION = 25;
    public static final int CANT_GET_TWISTER_INSTALL_DIR = 26;
    public static final int NO_PROJECT_IS_ACTIVE = 27;
    public static final int NO_PROJECT_ELEMENT_IS_SELECTED = 28;
    public static final int CANT_INSERT_BEFORE_OR_AFTER_ROOT_ELEMENT = 29;
    public static final int UNDO_NOT_AVAILABLE = 30;
    public static final int REDO_NOT_AVAILABLE = 31;
    public static final int NOTHING_IN_CLIPBOARD_TO_PASTE = 32;
    public static final int CANT_CUT_THIS_ITEM = 33;
    public static final int CANT_DELETE_THIS_ITEM = 34;
    public static final int CANT_PASTE_THAT_TYPE_HERE = 35;
    public static final int CANT_COPY_THIS_ITEM = 36;
    public static final int HAS_PARENT = 37;
    public static final int SET_PARENT = 38;
    public static final int NOT_MY_CHILD = 39;
    public static final int PARENT_CLONE = 40;
    public static final int CHILD_CLONE = 41;
    public static final int END_OF_TREE = 42;
    public static final int ADD_FILE_TO_ARCHIVE = 43;
    public static final int CANT_VIEW_PAGE = 100;
    protected Exception previous;
    protected int errorID;
    private Vector tokens = new Vector();

    public CascadedException(int id) {
        this.errorID = id;
    }

    public CascadedException(int id, Exception e) {
        this.previous = e;
        this.errorID = id;
    }

    public int getErrorID() {
        return this.errorID;
    }

    public Exception getPrevious() {
        return this.previous;
    }

    public void addToken(String name, String value) {
        this.tokens.addElement(new CascadedExceptionToken(name, value));
    }

    public String singleLevelString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getTextForId(this.errorID));
        s.append("\n");
        s.append(this.getClass().getName());
        s.append("[#" + this.errorID + "]");
        return s.toString();
    }

    public String getMessage() {
        return this.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.singleLevelString());
        if (this.previous != null) {
            s.append("\n     because:\n");
            s.append(this.previous.toString());
            if (this.previous.getMessage() == null) {
                s.append(": <null message>");
            }
        }
        return s.toString();
    }

    protected String getTextForId(int id) {
        String s = this.lookup(id);
        return this.substituteTokens(s);
    }

    protected String substituteTokens(String message) {
        String returnString = new String(message);
        Enumeration e = this.tokens.elements();
        while (e.hasMoreElements()) {
            CascadedExceptionToken t = (CascadedExceptionToken)e.nextElement();
            String token = "$" + t.name;
            int startOfToken = returnString.indexOf(token);
            if (startOfToken == -1) {
                returnString = returnString + "\n" + t.name + " = " + t.value;
                continue;
            }
            String firstHalf = returnString.substring(0, startOfToken);
            int endOfToken = startOfToken + token.length();
            String secondHalf = endOfToken >= returnString.length() ? "" : returnString.substring(endOfToken);
            returnString = firstHalf + t.value + secondHalf;
        }
        return returnString;
    }

    protected String lookup(int id) {
        switch (id) {
            case 0: {
                return "unknown argument $name in the method";
            }
            case 1: {
                return "unknown property $name";
            }
            case 2: {
                return "unknown method $name";
            }
            case 3: {
                return "unknown trigger $name";
            }
            case 4: {
                return "file '$filename' does not exist";
            }
            case 5: {
                return "can't write to file '$filename'";
            }
            case 6: {
                return "$projectElement's can't be placed there.";
            }
            case 7: {
                return "Can't load palette file $filename";
            }
            case 8: {
                return "Can't save palette file $filename";
            }
            case 9: {
                return "Clone not supported; must be reimplemented in subclass";
            }
            case 10: {
                return "Unable to parse the HTML at this level";
            }
            case 11: {
                return "Attept to read a text block when a token is next";
            }
            case 12: {
                return "Unable to retrieve a text block from HTML stream";
            }
            case 13: {
                return "Attept to read a token when a text block is next";
            }
            case 14: {
                return "Unable to find a valid token";
            }
            case 15: {
                return "Unable to find the ending token";
            }
            case 16: {
                return "Unable to close the HTML parse stream";
            }
            case 17: {
                return "Unable to write HTML to file $filename";
            }
            case 18: {
                return "Unable to read HTML file $filename";
            }
            case 19: {
                return "View of type $classname1 cannot view object of type $classname2";
            }
            case 20: {
                return "Value \"$argval\" not valid for argument \"$arg\" in method $methodname";
            }
            case 21: {
                return "Unable to retrieve the class file $classname for property $property";
            }
            case 22: {
                return "Unable to import the selected element";
            }
            case 23: {
                return "Unable to create or open archive $name";
            }
            case 24: {
                return "Error $opname file $filename";
            }
            case 25: {
                return "Security exception trying to $opname";
            }
            case 26: {
                return "Can't find Twister installation directory, must have class path with 'twister' in it";
            }
            case 28: {
                return "No project element us currently selected.";
            }
            case 29: {
                return "You can't insert elements before or after the root element.";
            }
            case 27: {
                return "No project is currently active.";
            }
            case 30: {
                return "Nothing to undo";
            }
            case 31: {
                return "Nothing to redo";
            }
            case 32: {
                return "Nothing in the clipboard to paste.";
            }
            case 33: {
                return "You can't cut this item.";
            }
            case 34: {
                return "You can't delete this item.";
            }
            case 35: {
                return "You can't paste this type of item here.";
            }
            case 36: {
                return "You can't copy this item.";
            }
            case 38: {
                return "Failure setting the parent of tag $tag";
            }
            case 37: {
                return "Unable to re-parent, parent already set on $child";
            }
            case 39: {
                return "Attempt to add child $child to parent, but it already has different parent";
            }
            case 40: {
                return "Clone failure on Tree element, unable to clone $parent";
            }
            case 41: {
                return "Clone failure on Tree element, unable to initialize newly cloned $parent";
            }
            case 42: {
                return "Invalid call to TreeEnumeration.nextElement() after all elements already fetched";
            }
            case 100: {
                return "Can't view page.";
            }
            case 43: {
                return "Can't add file $filename to archive $archname";
            }
        }
        return "identifer " + id + " not in CascadedException lookup table!";
    }

    public static void printException(Exception e, String location) {
        Warning w = new Warning(0, e);
        w.addToken("msg", location);
        Environment.getWarningList().addWarning(w);
    }
}

