/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_idmap.h"

#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ enum ndr_err_code ndr_push_id_type(struct ndr_push *ndr, int ndr_flags, enum id_type r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_id_type(struct ndr_pull *ndr, int ndr_flags, enum id_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_id_type(struct ndr_print *ndr, const char *name, enum id_type r)
{
	const char *val = NULL;

	switch (r) {
		case ID_TYPE_NOT_SPECIFIED: val = "ID_TYPE_NOT_SPECIFIED"; break;
		case ID_TYPE_UID: val = "ID_TYPE_UID"; break;
		case ID_TYPE_GID: val = "ID_TYPE_GID"; break;
		case ID_TYPE_BOTH: val = "ID_TYPE_BOTH"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_unixid(struct ndr_push *ndr, int ndr_flags, const struct unixid *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id));
		NDR_CHECK(ndr_push_id_type(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_unixid(struct ndr_pull *ndr, int ndr_flags, struct unixid *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_id_type(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_unixid(struct ndr_print *ndr, const char *name, const struct unixid *r)
{
	ndr_print_struct(ndr, name, "unixid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "id", r->id);
	ndr_print_id_type(ndr, "type", r->type);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_id_mapping(struct ndr_push *ndr, int ndr_flags, enum id_mapping r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_id_mapping(struct ndr_pull *ndr, int ndr_flags, enum id_mapping *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_id_mapping(struct ndr_print *ndr, const char *name, enum id_mapping r)
{
	const char *val = NULL;

	switch (r) {
		case ID_UNKNOWN: val = "ID_UNKNOWN"; break;
		case ID_MAPPED: val = "ID_MAPPED"; break;
		case ID_UNMAPPED: val = "ID_UNMAPPED"; break;
		case ID_EXPIRED: val = "ID_EXPIRED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_id_map(struct ndr_push *ndr, int ndr_flags, const struct id_map *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_unixid(ndr, NDR_SCALARS, &r->xid));
		NDR_CHECK(ndr_push_id_mapping(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_id_map(struct ndr_pull *ndr, int ndr_flags, struct id_map *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_unixid(ndr, NDR_SCALARS, &r->xid));
		NDR_CHECK(ndr_pull_id_mapping(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_id_map(struct ndr_print *ndr, const char *name, const struct id_map *r)
{
	ndr_print_struct(ndr, name, "id_map");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_unixid(ndr, "xid", &r->xid);
	ndr_print_id_mapping(ndr, "status", r->status);
	ndr->depth--;
}

